/* helpinfo.c
   **
   ** released to the PUBLIC DOMAIN jul 10 1994 by John Dennis
   **
   ** displays helpfile info and contents
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "help.h"

char line[255];
FILE *help;
HFileHdr Fheader;
HTopicHdr *topics;
int setup;
int CurrTopic;
static int numTopics;

void HelpInit(char *fileName)
{
    int i;

    setup = 0;
    if ((help = fopen(fileName, "rb")) == NULL)
    {
        return;
    }
    fread(&Fheader, sizeof(HFileHdr), 1, help);
    numTopics = (Fheader.topics[1] << 8) | Fheader.topics[0];
    if ((topics = calloc(numTopics, sizeof(HTopicHdr))) == NULL)
    {
        return;
    }
    for (i = 0; i < numTopics; i++)
    {
        fread(&topics[i], sizeof(HTopicHdr), 1, help);
    }
    setup = 1;
    CurrTopic = 0;
}

void DisplayPage(long offset)
{
    int done;
    int line_num;
    char *s;

    done = 0;
    line_num = 0;

    fseek(help, offset, SEEK_SET);

    while (!done)
    {
        if (fgets(line, 254, help) == NULL)
            break;

        if (!strncmp(line, "*Page", 5) || !strncmp(line, "*End", 4))
            break;

        if (*line != '\n')
        {
            if ((s = strchr(line, '\n')) != NULL)
                *s = '\0';

            printf("%s\n", line);
        }
        line_num++;
    }
}

void DoHelp(int topic)
{
    long offset[20];
    int page;
    int pages;
    int done;

    if (topic < 0 || topic > numTopics)
    {
        return;
    }
    fseek(help, topics[topic].offset, SEEK_SET);

    if (fgets(line, 254, help) == NULL)
        return;

    if (strncmp(line, "*Begin", 6))
        return;

    done = 0;
    pages = 1;
    offset[pages - 1] = ftell(help);

    while (!done)
    {
        if (fgets(line, 254, help) == NULL)
        {
            return;
        }
        if (!strncmp(line, "*End", 4))
            break;

        if (!strncmp(line, "*Page", 5))
        {
            pages++;
            offset[pages - 1] = ftell(help);
        }
    }

    fseek(help, offset[0], SEEK_SET);

    done = 0;
    page = 0;

    while (page < pages)
    {
        DisplayPage(offset[page++]);
    }
}

int main(int argc, char *argv[])
{
    int curr;

    printf("\nMsgedsq HELP file info, by John Dennis.");

    if (argc < 2)
    {
        printf("\nusage: helpinfo <src helpfile>\n");
        exit(-1);
    }
    HelpInit(argv[1]);

    curr = 0;
    while (curr < numTopics)
    {
        DoHelp(curr++);
    }
    return 1;
}

/* end of file */
