/* menu.c
   **
   ** released into the PUBLIC DOMAIN 10 jul 1994 by John Dennis
   **
   ** Moving bar menu code for msgedsq.
   **
 */

#define DEBUG 0

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "msged.h"
#include "main.h"
#include "keys.h"

#if DEBUG

#include "winsys.h"
#include "keys.h"

#define MN_BTXT    0
#define MN_NTXT    1
#define MN_STXT    2

int Menu[] =
{
    LCYAN | _BLUE,              /* border */
    CYAN | _BLUE,               /* normal text */
    BLACK | _CYAN               /* selected text */
};

#endif

void SelShowItem(char *text, int y, int len, int Attr, int indent)
{
    char line[256];

    memset(line, ' ', 40);
    strcpy(line + indent, text);
    WPutsn(0, y, len, Attr, line);
}

void SelShowPage(char **text, int top, int bot, int len, int pos, int Attr, int indent)
{
    int i;
    int y = top;

    for (i = pos; text[i] != NULL; i++)
    {
        if (y > bot)
            break;

        SelShowItem(text[i], y++, len, Attr, indent);
    }
    if (y <= bot)
    {
        while (y <= bot)
            SelShowItem(" ", y++, len, Attr, indent);
    }
}

void CalcDef(int max, int cur, int *top, int miny, int maxy, int *y)
{
    int dif = maxy - miny;

    unused(cur);
    if ((max - 1) - *top < dif && max > dif)
    {
        *y = maxy;
        *top = (max - 1) - dif;
    }
}

int SelBox(char **Itms, int y1, int y2, int len, int def, unsigned long wid, int Sel, int Norm, int indent)
{
    EVT e;
    int Cnt = 0;
    int Stuff = 0;
    int done;
    int Cury;
    int Msg;
    int Curr;
    int Top;
    int page;
    int i;

    for (i = 0; Itms[i] != NULL; i++)
        Cnt++;

    if (Cnt < y2)
    {
        y2 = Cnt;
    }
    Curr = def;
    Cury = y1;
    page = y2 - y1;
    Top = Curr;

    if (Curr + y1 < y1)
    {
        Cury = y1 + Curr;
        Top = 0;
    }
    else
    {
        if ((Cnt - Curr) <= (y2 - y1))
        {
            Top -= ((y2 - y1 + 1) - (Cnt - Top));
            Cury = y1 + (def - Top);
            if (Top < 0)
            {
                Top = 0;
                Cury--;
            }
        }
    }
    done = 0;

    SelShowPage(Itms, y1, y2, len, Top, Norm, indent);
    SelShowItem(Itms[Curr], Cury, len, Sel, indent);

    TTClearQue();               /* clear input queue */

    while (!done)
    {
        if (!Stuff)
            Msg = MnuGetMsg(&e, wid);
        else
        {
            e.msgtype = WM_CHAR;
            Msg = Stuff;
            Stuff = 0;
        }

        switch (e.msgtype)
        {
        case WM_MOUSE:
            switch (Msg)
            {
            case RMOU_CLCK:
            case MOU_RBTUP:
                return -1;

            case LMOU_RPT:
            case MOU_LBTDN:
                /* case MOU_LBTUP: */
            case LMOU_CLCK:
                /* case MOUSE_EVT: */
                {
                    int x, y;

                    WndGetRel(e.x, e.y, &x, &y);
                    if (y >= y1 && y <= y2) /* in window */
                    {
                        Stuff = 0;
                        if (x >= 0 && x < len)
                        {
                            if (y == Cury)
                            {
                                if (Msg == LMOU_CLCK || Msg == MOU_LBTUP)
                                    return Curr;
                                else
                                    continue;
                            }
                            SelShowItem(Itms[Curr], Cury, len, Norm, indent);

                            if (y > Cury)
                                Curr += y - Cury;
                            else
                                Curr -= Cury - y;

                            Cury = y;

                            SelShowItem(Itms[Curr], Cury, len, Sel, indent);

                            if (Msg == LMOU_CLCK || Msg == MOU_LBTUP)
                                return Curr;
                        }
                    }
                    else
                    {
                        if (Msg != LMOU_CLCK)
                        {
                            if (y < y1)
                                Stuff = Key_Up;
                            else
                                Stuff = Key_Dwn;
                        }
                    }
                }
                break;

            default:
                break;
            }
            break;

        case WM_CHAR:
            switch (Msg)
            {
            case Key_Home:
                if (!Curr)
                    break;
                SelShowItem(Itms[Curr], Cury, len, Norm, indent);
                Curr = 0;
                Top = 0;
                Cury = y1;
                SelShowPage(Itms, y1, y2, len, Top, Norm, indent);
                SelShowItem(Itms[Curr], Cury, len, Sel, indent);
                break;

            case Key_End:
                if (Curr == Cnt - 1)
                    break;
                SelShowItem(Itms[Curr], Cury, len, Norm, indent);
                Curr = Cnt - 1;
                while (Curr && Curr >= (Cnt - page))
                    Curr--;
                Top = Curr;
                Curr = Cnt - 1;
                Cury = Curr - Top + y1;
                CalcDef(Cnt, Curr, &Top, y1, y2, &Cury);
                SelShowPage(Itms, y1, y2, len, Top, Norm, indent);
                SelShowItem(Itms[Curr], Cury, len, Sel, indent);
                break;

            case Key_Dwn:
                if (Curr == Cnt - 1)
                    break;

                SelShowItem(Itms[Curr], Cury, len, Norm, indent);
                Curr++;
                if (Cury == y2)
                {
                    WScroll(0, y1, len - 1, y2, 1);
                    Top++;
                }
                else
                    Cury++;
                SelShowItem(Itms[Curr], Cury, len, Sel, indent);
                break;

            case Key_Up:
                if (!Curr)
                    break;

                SelShowItem(Itms[Curr], Cury, len, Norm, indent);
                Curr--;
                if (Cury == y1)
                {
                    WScroll(0, y1, len - 1, y2, 0);

                    if (Top)
                        Top--;
                }
                else
                    Cury--;
                SelShowItem(Itms[Curr], Cury, len, Sel, indent);
                break;

            case Key_PgUp:
                if (!Curr)
                    break;

                SelShowItem(Itms[Curr], Cury, len, Norm, indent);
                if ((Curr -= page) < 0)
                    Curr = 0;

                Top = Curr;
                Cury = y1;
                SelShowPage(Itms, y1, y2, len, Top, Norm, indent);
                SelShowItem(Itms[Curr], Cury, len, Sel, indent);
                break;

            case Key_PgDn:
                if (Curr == Cnt - 1)
                    break;

                SelShowItem(Itms[Curr], Cury, len, Norm, indent);
                Top = Curr;

                if ((Curr += page) > Cnt - 1)
                    Curr = Cnt - 1;

                Cury = Curr - Top + y1;
                CalcDef(Cnt, Curr, &Top, y1, y2, &Cury);
                SelShowPage(Itms, y1, y2, len, Top, Norm, indent);
                SelShowItem(Itms[Curr], Cury, len, Sel, indent);
                break;

            case Key_Ent:
                return Curr;

            case Key_Esc:
                return -1;

            default:
                if (Msg > 31 && Msg < 127)
                {
                    i = Curr + 1;

                    while (i < Cnt)
                    {
                        if (toupper(*Itms[i]) == toupper((char) Msg))
                            break;
                        i++;
                    }
                    if (i == Cnt)
                    {
                        for (i = 0; i < Curr; i++)
                            if (toupper(*Itms[i]) == toupper((char) Msg))
                                break;
                    }
                    if (i != Curr)
                    {
                        SelShowItem(Itms[Curr], Cury, len, Norm, indent);
                        Curr = i;
                        Cury = y1;
                        Top = Curr;

                        /* Get the cursor position right... */

                        if ((Cnt - 1) - Curr < y2 - y1)
                        {
                            if (Curr > y2 - y1)
                            {
                                Cury = y2;
                                Top = Curr - (y2 - y1);
                            }
                            else
                            {
                                Cury = Curr + y1;
                                Top = 0;
                            }
                        }
/*                              CalcDef(Cnt, Curr, &Top, y1, y2, &Cury); */
                        SelShowPage(Itms, y1, y2, len, Top, Norm, indent);
                        SelShowItem(Itms[Curr], Cury, len, Sel, indent);
                    }
                }
                break;

            }
            break;
        }
    }
    return -1;
}

#ifndef NODOMENU

int DoMenu(int x1, int y1, int x2, int y2, char **Itms, int def)
{
    WND *hCurr, *hWnd;
    int ret;

    unused(def);
    hCurr = Wtop();
    hWnd = WndOpen(x1 - 2, y1 - 1, x2 + 3, y2 + 1, DBDR | SHADOW, cm[MN_BTXT], cm[MN_NTXT]);

    if (!hWnd)
        return -1;

    ret = SelBox(Itms, 0, y2 - y1, x2 - x1 + 4, 0, hWnd->wid, cm[MN_STXT], cm[MN_NTXT], 2);

    WClose(hWnd);
    WCurr(hCurr);

    return ret;
}

#endif

#if DEBUG

int main(void)
{
    char *test[] =
    {
        "atest 1",
        "btest 2",
        "ctest 3",
        "dtest 4",
        "etest 5",
        "ftest 6",
        "gtest 7",
        "htest 8",
        "itest 9",
        "jtest 10",
        "itest 9",
        "dtest 4",
        "etest 5",
        "ftest 6",
        "jtest 10",
        "ktest 11",
        "itest 9",
        "jtest 10",
        NULL
    };

    TTopen();
    DoMenu(12, 12, 40, 20, test, 0);
    TTclose();
    return (0);
}
#endif

/*--- end ---*/
