/* strextra.c

   Released into the PUBLIC DOMAIN 30 jul 1990 by jim nutt
   Modified by Paul Edwards, and also released to the Public Domain

   A few string handling routines for msged.

 */

#include <string.h>
#include <ctype.h>
#include <stdlib.h>

#include "strextra.h"

void strins(char *l, char c, int x)

{
    int i = strlen(l);

    if (x > (i + 1))
        return;
    else
    {
        x--;
        memmove((l + x + 1), (l + x), (i - x) + 1);
        *(l + x) = c;
    }
}

void strdel(char *l, int x)

{
    int i = strlen(l);

    if (x > i)
        return;
    x--;
    memmove((l + x), (l + x + 1), (i - x) + 1);
    *(l + i) = 0;
}

/*
 *    strncmpi() ->    strncmp(), ignore case
 */

int strncmpi(const char *s, const char *t, size_t x)
{
    long n = (long) x;

    for (; n-- && (tolower(*s) == tolower(*t)); ++t)
        if (!*s++)
            return (0);         /* equal */

    if (n < 0)                  /* maximum hit */
        return (0);             /* equal */

    return ((tolower(*s) > tolower(*t)) ? 1 : (-1));  /* not equal */
}

int stricmp(const char *s, const char *t)
{
    int ret;
    
    s--;
    t--;
    do
    {
        s++;
        t++;
        ret = tolower((unsigned char)*s) - tolower((unsigned char)*t);
        if (ret != 0)
        {
            return (ret);
        }
    } while (*s != '\0');
    return (0);
}

#ifndef __IBMC__
char *strdup(const char *s)
{
    char *p;
    
    p = malloc(strlen(s)+1);
    if (p != NULL)
    {
        strcpy(p, s);
    }
    return (p);
}
#endif

#ifndef __IBMC__
int memicmp(const void *s1, const void *s2, size_t n)
#else
int memicmp(void *s1, void *s2, size_t n)
#endif
{
    size_t x;
    int ret;
    
    for (x = 0; x < n; x++)
    {
        ret = (tolower((unsigned char)*(char *)s1)
            - tolower((unsigned char)*(char *)s2));
        if (ret != 0)
        {
            return (ret);
        }
    }
    return (0);
}

char *strlwr(char *s)
{
    char *p = s;
    
    while (*p != '\0')
    {
        *p = (char)tolower((unsigned char)*p);
        p++;
    }
    return (s);
}

char *strupr(char *s)
{
    char *p = s;
    
    while (*p != '\0')
    {
        *p = (char)toupper((unsigned char)*p);
        p++;
    }
    return (s);
}

