/* system.c
   **
   ** released into the PUBLIC DOMAIN 10 jul 1994 by John Dennis
   **
   ** Code that handles system events and passes them through
   ** MnuGetMsg() back to the caller. Hotspots their location
   ** are also handled.
   **
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "WinSys.h"

HotGroup *HotSpot[MAX_HOT_GROUP];
int (*KeyPreProc) (int ch) = NULL;
int NumHots = 0;
EVT e;

void PushHotGroup(HotGroup * New)
{
    if (NumHots == MAX_HOT_GROUP)
        return;

    HotSpot[NumHots] = New;
    NumHots++;
}

void PopHotGroup(void)
{
    if (NumHots == 0)
        return;

    NumHots--;
}

int LocateHotItem(int x, int y, unsigned long wid)
{
    int gr, it;

    for (gr = 0; gr < NumHots; gr++)
    {
        if (!wid || HotSpot[gr]->wid == wid)
        {
            for (it = 0; it < HotSpot[gr]->num; it++)
            {
                if (x >= HotSpot[gr]->harr[it].x1 && x <= HotSpot[gr]->harr[it].x2 &&
                    y >= HotSpot[gr]->harr[it].y1 && y <= HotSpot[gr]->harr[it].y2)
                {
                    return HotSpot[gr]->harr[it].id;
                }
            }
        }
    }
    return 0;
}

/*/$/ unsigned int MnuGetMsg(int *mtype, int *p1, int *p2, unsigned long wid)
   **
   ** Returns a key or mouse press and defines
   ** the return type in p1.  Should be used over
   ** the TTGetMsg counterpart.
 */

unsigned int MnuGetMsg(EVT * event, unsigned long wid)
{
    unsigned int ch = 0;
    int proc = 0;
    int id;

    if (KeyPreProc != NULL)
    {
        ch = KeyPreProc(0);
        if (ch)
        {
            proc = 1;
            e.msgtype = WM_CHAR;
            e.msg = ch;
        }
    }
    if (ch == 0)
    {
        ch = TTGetMsg(&e);
    }
    *event = e;

    switch (e.msgtype)
    {
    case WM_MOUSE:
        if ((id = LocateHotItem(e.x, e.y, wid)) != 0)
        {
            event->msgtype = WM_COMMAND;
            event->id = id;     /* id of screen object */
        }
        break;

    case WM_CHAR:
        if (!proc)
        {
            if (KeyPreProc != NULL)
                event->msg = KeyPreProc(ch);
        }
        break;

    default:
        break;
    }
    return event->msg;
}

void RegisterKeyProc(int (*fnc) (int ch))
{
    KeyPreProc = fnc;
}

/* end */
