/* template.c
   **
   ** released into the PUBLIC DOMAIN 10 jul 1994 by John Dennis
   **
   ** Handles the creation of messages from a template.
 */

#define TEXTLEN 250

#include "msged.h"
#include "date.h"
#include "strextra.h"

LINE *makequote(LINE * l, char *isfrom);
char *attrib_lineold(msg * m, char *format);
char *attrib_line(msg * m, msg * old, int olda, char *format);
LINE *insline(LINE * cl);

int MakeTemplateMsg(msg * m, msg * oldmsg, int olda, int type)
{
    LINE *ln = NULL, *n;
    FILE *fp;
    char buf[TEXTLEN];
    char *l;

    if (!ST->template || (fp = fopen(ST->template, "r")) == NULL)
    {
        if (m->text && (type & MT_QUO))
        {
            ln = m->text;
            ln = makequote(ln, (oldmsg != NULL) ? oldmsg->isfrom : m->isfrom);
        }
        return 0;
    }
    while (fgets(buf, TEXTLEN - 1, fp))
    {
        if (buf[0] == ';')
            continue;

        if (buf[0] == '@' && buf[1] && buf[1] != '@')
        {
            switch (tolower(buf[1]))
            {
            case 'f':
                if (!(type & MT_FOR))
                    continue;
                break;

            case 'l':
                if (!(type & MT_FOL))
                    continue;
                break;

            case 'r':
                if (!(type & MT_RED))
                    continue;
                break;

            case 'a':
                if (!(type & MT_ARC))
                    continue;
                break;

            case 'q':
                if (!(type & MT_QUO))
                    continue;
                break;

            case 'n':
/*                  if ((type & MT_FOR) || (type & MT_RED)) continue; */
                if (!(type & MT_NEW))
                    continue;
                break;

            case 'm':
                if (ln)
                {               /* assign msg to follow */
                    ln->next = m->text;
                    if (ln->next)
                    {
                        ln->next->prev = ln;
                        ln = ln->next;
                    }
                }
                else
                    ln = m->text;
                if (!(type & MT_QUO)) /* don't want a quote */
                {
                    while (ln != NULL && ln->next != NULL)
                        ln = ln->next;
                }
                else
                {               /* we do want a quote */
                    ln = makequote(ln, (oldmsg != NULL) ? oldmsg->isfrom : m->isfrom);

                    /* just in case we didn't get the beginning */

                    ln = m->text;
                    while (ln != NULL && ln->next != NULL)
                    {
                        ln = ln->next;
                    }
                }
                continue;

            default:            /* break on things we don't know */
                break;
            }

            if (buf[2])         /* could be a blank line... */
            {
                l = attrib_line(m, oldmsg, olda, buf + 2);
            }
            else
                l = strdup("\n");
        }
        else
            l = attrib_line(m, oldmsg, olda, buf);

        if ((n = calloc(1, sizeof(LINE))) == NULL)
            outamemory();

        n->templt = 1;          /* mark as a template line */

        if (ln)
            n->next = ln->next;

        n->prev = ln;

        if (ln)
            ln->next = n;

        if (n->next)
            n->next->prev = n;

        n->text = l;
        ln = n;
    }
    fclose(fp);

    /* we've finished; assign it to the beginning of the msg */

    if (m->text == NULL && ln != NULL)
    {
        /* Find beginning of msg and assign it. */

        while (ln->prev)
        {
            ln = ln->prev;
        }
        m->text = ln;
    }
    ln = m->text;
    while (ln && ln->prev)
    {
        ln = ln->prev;
    }
    m->text = ln;
    return (0);
}

/* end */
