/* userlist - look up name in fido userlist */
/* written by Paul Edwards */
/* released to the public domain */
/* modified to make it do a binary search by Bill Bond */
/* note - the fido userlist consists of fixed length
   records sorted alphabetically
   The records look like:
   Bloggs, Joe      3:666/666
*/

#include "msged.h"
#include "strextra.h"

static long filelength(FILE *fp);

ADDRESS lookup(char *name, char *fn)
{
    FILE *fp;
    ADDRESS tmpAddr;
    char buf[200];
    char revName[200];
    int lenRev, result, fureclen, done = 0;
    long low, mid, high;
    char *p;

    tmpAddr = CurArea.addr;
    if (tmpAddr.domain != NULL)
    {
        tmpAddr.domain = strdup(tmpAddr.domain);
    }
    tmpAddr.notfound = 1;
    fp = fopen(fn, "r");
    if (fp == NULL)
    {
        return (tmpAddr);
    }
    makeReverse(revName, name);
    strlwr(revName);
    lenRev = strlen(revName);
    if (fgets(buf, sizeof buf, fp) != NULL)
    {
        fureclen = strlen(buf) + 1;
    }
    high = filelength(fp) / fureclen;
    low = 0;
    while (low <= high && !done)
    {
        mid = low + (high - low) / 2;
        fseek(fp, (long) mid * fureclen, SEEK_SET);
        if (fgets(buf, sizeof buf, fp) != NULL)
        {
            strlwr(buf);
            result = strncmp(buf, revName, lenRev);
            if (result > 0)
            {
                high = mid - 1;
            }
            else if (result < 0)
            {
                low = mid + 1;
            }
            else
            {
                p = buf + strlen(buf) - 1;
                while ((p >= buf) && (isspace(*p)))
                {
                    *p = '\0';
                    p--;
                }
                while ((p >= buf) && (!isspace(*p)))
                {
                    p--;
                }
                if ((p >= buf) && (isspace(*p)))
                {
                    p++;
                }
                if (tmpAddr.domain != NULL)
                {
                    free(tmpAddr.domain);
                }
                fclose(fp);
                return (parsenode(p));
            }
        }
        else
        {
            done = 0;           /* force end of loop */
        }
    }
    fclose(fp);
    return (tmpAddr);
}

void makeReverse(char *revName, char *name)
{
    char *lastSpace;
    int len;

    lastSpace = strrchr(name, ' ');
    if (lastSpace == NULL)
    {
        strcpy(revName, name);
        return;
    }
    len = strlen(lastSpace + 1);
    memcpy(revName, lastSpace + 1, len);
    memcpy(revName + len, ", ", 2);
    memcpy(revName + len + 2, name, (size_t) (lastSpace - name));
    *(revName + len + 2 + (size_t) (lastSpace - name)) = '\0';
    return;
}

static long filelength(FILE *fp)
{
    long ret;
    
    ret = fseek(fp, 0, SEEK_END);
    if (ret != 0L)
    {
        return (0L);
    }
    ret = ftell(fp);
    if (ret < 0)
    {
        ret = 0;
    }    
    return (ret);
}
