/*
 *  STREXTRA.C
 *
 *  Written on 30-Jul-90 by jim nutt.  Changes on 10-Jul-94 by John Dennis,
 *  Paul Edwards and Andrew Clarke.  Released to the public domain.
 *
 *  A few string handling routines.  Modified for use in SMAPI 13-Jan-97.
 */

#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include "strextra.h"

#ifndef _MSC_VER

int stricmp(const char *s, const char *t)
{
    while (*s != '\0')
    {
        int rc;
        rc = tolower((unsigned char)*s) - tolower((unsigned char)*t);
        if (rc != 0)
        {
            return rc;
        }
        s++;
        t++;
    }

    if (*t != '\0')
    {
        return -tolower((unsigned char)*t);
    }

    return 0;
}

#endif

#ifndef __IBMC__

char *strdup(const char *s)
{
    char *p;
    p = malloc(strlen(s) + 1);
    if (p != NULL)
    {
        strcpy(p, s);
    }
    return p;
}

#endif
