{DEBUGGING}
{A+,B+,D+,E-,F-,G+,I+,L+,N+,O+,P+,Q+,R+,S+,T+,V+,X+,Y+}
{M 16384,0,655360}
{GO!}
{$A+,B+,D-,E-,F-,G+,I-,L-,N+,O+,P+,Q-,R-,S-,T+,V+,X+,Y-}
{$M 16384,0,655360}

{
Go!3D, version 151
capabilities:
  not shaded triangles
  lambert shaded triangles
  gouraud shaded triangles
  texture mapped triangles (affine)
  pregenerated sin,cos,yoffset
  9 mul matrix rotation
  phong shading
feature:
  shake sort
  texture mapping (perspective correct)
  strauss shading
  z-buffer or s-buffer
  4vertex polygons
  VESA standart graphics
  overwriting as a protected mode application
  a almoast compleet asm code
..so watch out
needs:
  any suggestions, optimizations, improovements, bugs found or repaired,
   questions please email at stratil@fenix.cz. If code is changed, save the
   former state as a comment. Any documents on the 'feature' subjects would
   be appriciated
distribution:
  This program is freeware. It may be distributed freely and used by anyone.
   It should help other programmers in improoving their skills. If code is
   improoved, please mail me a copy to the address above (or below).

Coded by Pavel Stratil, 1997
stratil@fenix.cz
}


type
    VirtualArray = array[1..64000] of byte;
    VPointer = ^VirtualArray;

const maxpoints=500;
      maxfaces=500;

var
   { original points }
   ox : array [1..maxpoints] of integer;
   oy : array [1..maxpoints] of integer;
   oz : array [1..maxpoints] of integer;
   { rotated points }
   rx : array [1..maxpoints] of single;
   ry : array [1..maxpoints] of single;
   rz : array [1..maxpoints] of single;
   { put points }
   px : array [1..maxpoints] of integer;
   py : array [1..maxpoints] of integer;
   { original normals }
   nox : array [1..maxfaces] of single;
   noy : array [1..maxfaces] of single;
   noz : array [1..maxfaces] of single;
   { rotated normals }
   rnx : array [1..maxfaces] of single;
   rny : array [1..maxfaces] of single;
   rnz : array [1..maxfaces] of single;
   { points to create a face }
   pt1 : array [1..maxfaces] of word;
   pt2 : array [1..maxfaces] of word;
   pt3 : array [1..maxfaces] of word;
   { multiply to get verticies ot of points }
   vmul : array [ 1..maxpoints ] of single;
   { pregenerate sinus, cosinus, y offset }
   gsin : array [ 0..255 ] of single;
   gcos : array [ 0..255 ] of single;
   yoffset : array [ 0..199 ] of word;
   { shade value }
   xshade : array [ 0..maxfaces ] of byte;
   { ((c2-c1)/2) }
   xshademul : array [ 0..255 ] of byte;
   { ((c2-c1)/2)+c1 }
   xshadeadd : array [ 0..255 ] of byte;
   { cover type - none, lambert, texture, gouraud }
   cover : array [ 0..maxfaces ] of byte;
   { texture }
   _u1 : array [1..maxfaces] of byte;
   _u2 : array [1..maxfaces] of byte;
   _u3 : array [1..maxfaces] of byte;
   _v1 : array [1..maxfaces] of byte;
   _v2 : array [1..maxfaces] of byte;
   _v3 : array [1..maxfaces] of byte;
   _width : array [1..maxfaces] of byte;
   _map : array [1..maxfaces] of pointer;
   { Phong }
   _ambient : array [1..maxfaces] of single;
   _diffuse : array [1..maxfaces] of single;
   _specular : array [1..maxfaces] of single;
   _specpower : array [1..maxfaces] of byte;
   xcoloradd : array [ 0..255 ] of byte;


    lx,ly,lz:single;
    lalfa,lbeta,lgama:byte;
    ptcount,pointcount:word;
    origox,origoy,dist:integer;

    singles : array [1..3] of single;

function KeyPressed:boolean;
begin
  asm
    mov	ah,1
    int	16h
    jnz	@true
    mov	[@result],false
    jmp	@end
@true:
    mov	[@result],true
@end:
  end;
end;

function pow(x:single;exp:word):single;
var s:single;
begin
asm
 fld x
 fst dword ptr [bp-4]
 mov cx,exp
 dec cx
 jz @end
@1:
 fmul x
 dec cx
 jnz @1
 fstp dword ptr [bp-4]
@end:
end;
end;

function ReadKey:char;assembler;
asm
  mov ah,0h
  int 16h
end;

function VSetup(VScreen:VPointer):word;
begin
  new(Vscreen);
  VSetup:=seg(vscreen^);
end;

procedure VDispose(Va:word);
var vscreen:pointer absolute va;
begin
  dispose(Vscreen);
end;

procedure poffset(Xres,YRes:word);
var count:word;
begin
 for count:=0 to Yres-1 do yoffset[count]:=count*Xres;
end;

procedure sinus;
var w:byte;
begin
  for w:=0 to 255 do
  gsin[w]:=sin(w*pi/128);
end;

procedure cosinus;
var w:byte;
begin
  for w:=0 to 255 do
  gcos[w]:=cos(w*pi/128);
end;

procedure SetRGB(color,r,g,b:Byte);assembler;
asm
  mov dx,3c8h
  mov al,[Color]
  out dx,al
  inc dx
  mov al,[r]
  out dx,al
  mov al,[g]
  out dx,al
  mov al,[b]
  out dx,al
end;

procedure LoadCoords(filename:string);
var s1,s2,s3:string;
    souradnice,i,i1,i2,i3,i4:integer;
    soubor:text;
label MainLoop;
begin
  assign(soubor,filename);
  reset(soubor);
  readln(soubor,pointcount);
  readln(soubor,ptcount);
MainLoop:
     readln(soubor,s1);
     readln(soubor,s1);
     i:=0;
     s2:='';
     repeat
        inc(i);
        s3:=copy(s1,i,1);
        if s3=',' then s3:='';
        s2:=s2+s3;
     until s3='';
     val(s2,i1,i2);
     s2:='';
     repeat
        inc(i);
        s3:=copy(s1,i,1);
        if s3='' then s3:='';
        s2:=s2+s3;
     until s3='';
     val(s2,i4,i2);
     i:=0;
     repeat
        inc(i);
        readln(soubor,s1);
        i2:=0;
        s2:='';
        repeat
           inc(i2);
           s3:=copy(s1,i2,1);
           if s3='=' then s3:='';
           s2:=s2+s3;
        until s3='';
        val(s2,souradnice,i3);
        s2:='';
        repeat
          inc(i2);
          s3:=copy(s1,i2,1);
          if s3=',' then s3:='';
          s2:=s2+s3;
        until s3='';
        val(s2,ox[souradnice],i3);
        s2:='';
        repeat
           inc(i2);
           s3:=copy(s1,i2,1);
           if s3=',' then s3:='';
           s2:=s2+s3;
        until s3='';
        val(s2,oy[souradnice],i3);
        s2:='';
        repeat
           inc(i2);
           s3:=copy(s1,i2,1);
           if s3='' then s3:='';
           s2:=s2+s3;
        until s3='';
        val(s2,oz[souradnice],i3);
     until i=i1;
     readln(soubor,s1);
     i:=0;
     repeat
        inc(i);
        readln(soubor,s1);
        i2:=0;
        s2:='';
        repeat
           inc(i2);
           s3:=copy(s1,i2,1);
           if s3='=' then s3:='';
           s2:=s2+s3;
       until s3='';
       val(s2,souradnice,i3);
       s2:='';
       repeat
          inc(i2);
          s3:=copy(s1,i2,1);
          if s3=',' then s3:='';
          s2:=s2+s3;
       until s3='';
       val(s2,pt1[souradnice],i3);
       s2:='';
       repeat
          inc(i2);
          s3:=copy(s1,i2,1);
          if s3=',' then s3:='';
          s2:=s2+s3;
       until s3='';
       val(s2,pt2[souradnice],i3);
       s2:='';
       repeat
          inc(i2);
          s3:=copy(s1,i2,1);
          if s3='-' then s3:='';
          s2:=s2+s3;
       until s3='';
       val(s2,pt3[souradnice],i3);
       s2:='';
       repeat
          inc(i2);
          s3:=copy(s1,i2,1);
          if s3='' then s3:='';
          s2:=s2+s3;
       until s3='';
       val(s2,xshade[souradnice],i3);
    until i=i4;
    readln(soubor,s1);
    if s1<>'' then goto MainLoop;
  close(soubor);
end;

procedure Flip(source,target:word);assembler;
asm
  push ds
  mov ax,target
  mov es,ax
  mov ax,Source
  mov ds,ax
  xor si,si
  xor di,di
  mov cx,16000
  db $f3,66h,$a5
  pop ds
end;

procedure Cls(target:word);assembler;
asm
  mov ax,[bp+offset target]
  mov es,ax
  xor di,di
  db 66h; xor ax,ax
  mov cx,16000
  db 0f3h,66h,0abh
end;

procedure PPix(x,y:integer;color:byte;target:word);assembler;
asm
  mov bx,y
  add bx,bx
  mov ax,target
  mov es,ax
  mov bx,word ptr yoffset[bx]
  mov di,x
  mov al,color
  mov byte ptr es:[bx+di],al
end;

procedure xchgs(var x1,x2:single);
var z:single;
begin
z:=x1;
x1:=x2;
x2:=z;
end;

procedure xchgi(var x1,x2:integer);
var z:integer;
begin
z:=x1;
x1:=x2;
x2:=z;
end;

procedure xchgb(var x1,x2:byte);
var z:byte;
begin
z:=x1;
x1:=x2;
x2:=z;
end;

procedure Striangle(num,target:word);
var
 pcolor:byte; {visualization}
 x1,y1,x2,y2,x3,y3:integer;
 x,minY,mxaY,xa,xb,yy,p1,q1,p2,q2,p3,q3:integer; {triangle}
begin
 if rnz[num]>0 then {visualization}
 begin
  begin
   pcolor:=xshadeadd[xshade[num]]+xshademul[xshade[num]];
   x1:=px[pt1[num]];
   y1:=py[pt1[num]];
   x2:=px[pt2[num]];
   y2:=py[pt2[num]];
   x3:=px[pt3[num]];
   y3:=py[pt3[num]];
  end;
  {triangle}
  minY:=y1; mxaY:=y1;
  if y2<minY then minY:=y2;
  if y2>mxaY then mxaY:=y2;
  if y3<minY then minY:=y3;
  if y3>mxaY then mxaY:=y3;
  p1:=x1-x3; q1:=y1-y3;
  p2:=x2-x1; q2:=y2-y1;
  p3:=x3-x2; q3:=y3-y2;
  for yy:=minY to mxaY do
    begin
      xa:=320;
      xb:=-1;
      if (y3>=yy) or (y1>=yy) then
        if (y3<=yy) or (y1<=yy) then
          if not(y3=y1) then begin
              x:=(yy-y3)*p1 div q1+x3;
              if x<xa then xa:=x;
              if x>xb then xb:=x;
            end;
      if (y1>=yy) or (y2>=yy) then
        if (y1<=yy) or (y2<=yy) then
          if not(y1=y2) then begin
              x:=(yy-y1)*p2 div q2+x1;
              if x<xa then xa:=x;
              if x>xb then xb:=x;
            end;
      if (y2>=yy) or (y3>=yy) then
        if (y2<=yy) or (y3<=yy) then
          if not(y2=y3) then begin
              x:=(yy-y2)*p3 div q3+x2;
              if x<xa then xa:=x;
              if x>xb then xb:=x;
            end;
      if xa<=xb then
                 asm
                   mov bx,yy
                   add bx,bx
                   mov ax,target
                   mov es,ax
                   mov bx,word ptr yoffset[bx]
                   mov di,xa
                   add di,bx
                   mov al,pcolor
                   mov ah,al
                   mov cx,xb
                   sub cx,xa
                   inc cx
                   shr cx,1
                   jnc @1
                   mov es:[di],al
                   inc di
                 @1:
                   rep stosw
                 end;
    end;
  end;
end;


procedure Ltriangle(num,target:word);
var
 x1,y1,x2,y2,x3,y3:integer; {shading}
 pcolor:byte;
 dot:single;
 x,minY,mxaY,xa,xb,yy,p1,q1,p2,q2,p3,q3:integer; {triangle}
begin
 if rnz[num]>0 then
 begin
  begin  {color}
   dot:=rnx[num]*lx+rny[num]*ly+rnz[num]*lz;
   dot:=dot*xshademul[xshade[num]]+xshadeadd[xshade[num]];
   pcolor:=round(dot);
   x1:=px[pt1[num]];
   y1:=py[pt1[num]];
   x2:=px[pt2[num]];
   y2:=py[pt2[num]];
   x3:=px[pt3[num]];
   y3:=py[pt3[num]];
  end;
  {triangle}
  minY:=y1; mxaY:=y1;
  if y2<minY then minY:=y2;
  if y2>mxaY then mxaY:=y2;
  if y3<minY then minY:=y3;
  if y3>mxaY then mxaY:=y3;
  p1:=x1-x3; q1:=y1-y3;
  p2:=x2-x1; q2:=y2-y1;
  p3:=x3-x2; q3:=y3-y2;
  for yy:=minY to mxaY do
    begin
      xa:=320;
      xb:=-1;
      if (y3>=yy) or (y1>=yy) then
        if (y3<=yy) or (y1<=yy) then
          if not(y3=y1) then begin
              x:=(yy-y3)*p1 div q1+x3;
              if x<xa then xa:=x;
              if x>xb then xb:=x;
            end;
      if (y1>=yy) or (y2>=yy) then
        if (y1<=yy) or (y2<=yy) then
          if not(y1=y2) then begin
              x:=(yy-y1)*p2 div q2+x1;
              if x<xa then xa:=x;
              if x>xb then xb:=x;
            end;
      if (y2>=yy) or (y3>=yy) then
        if (y2<=yy) or (y3<=yy) then
          if not(y2=y3) then begin
              x:=(yy-y2)*p3 div q3+x2;
              if x<xa then xa:=x;
              if x>xb then xb:=x;
            end;
      if xa<=xb then
                 asm
                   mov bx,yy
                   add bx,bx
                   mov ax,target
                   mov es,ax
                   mov bx,word ptr yoffset[bx]
                   mov di,xa
                   add di,bx
                   mov al,pcolor
                   mov ah,al
                   mov cx,xb
                   sub cx,xa
                   inc cx
                   shr cx,1
                   jnc @1
                   mov es:[di],al
                   inc di
                 @1:
                   rep stosw
                 end;
    end;
  end;
end;

procedure GTriangle(num,target:word);
var
 w1,w2,w3,inc,i13,i12,i23,dot1,dot2,dot3,test,color,c1,c2:single; {shading}
 x1,x2,x3,y1,y2,y3:integer;
 col1,col2,col3:byte;
 ideal:boolean;
 x,ax,bx,yy,p1,q1,p2,q2,p3,q3:integer; {triangle}
begin
  if rnz[num]>0 then
  begin
   x1:=px[pt1[num]];
   y1:=py[pt1[num]];
   x2:=px[pt2[num]];
   y2:=py[pt2[num]];
   x3:=px[pt3[num]];
   y3:=py[pt3[num]];

   dot1:=(rx[pt1[num]]*lx+ry[pt1[num]]*ly+rz[pt1[num]]*lz)*vmul[pt1[num]];
   dot2:=(rx[pt2[num]]*lx+ry[pt2[num]]*ly+rz[pt2[num]]*lz)*vmul[pt2[num]];
   dot3:=(rx[pt3[num]]*lx+ry[pt3[num]]*ly+rz[pt3[num]]*lz)*vmul[pt3[num]];
   col1:=round(dot1*xshademul[xshade[num]])+xshadeadd[xshade[num]];
   col2:=round(dot2*xshademul[xshade[num]])+xshadeadd[xshade[num]];
   col3:=round(dot3*xshademul[xshade[num]])+xshadeadd[xshade[num]];

   if (y1>y2) then
   begin
    xchgi(y1,y2);
    xchgi(x1,x2);
    xchgb(col1,col2);
   end;
   if (y1>y3) then
   begin
    xchgi(y1,y3);
    xchgi(x1,x3);
    xchgb(col1,col3);
   end;
   if (y2>y3) then
   begin
    xchgi(y2,y3);
    xchgi(x2,x3);
    xchgb(col2,col3);
   end;

   if (y3-y1+1<>0) then i13:=(col3-col1)/(y3-y1+1) else i13:=0;
   if (y3-y2+1<>0) then i23:=(col3-col2)/(y3-y2+1) else i23:=0;
   if (y2-y1+1<>0) then i12:=(col2-col1)/(y2-y1+1) else i12:=0;

   if (y3-y1)<>0 then test:=(x3-x1)/(y3-y1) else test:=0;
   test:=test*(y2-y1);
   test:=test+x1;
   if x2>=test then ideal:=true else ideal:=false;

   c1:=col1;
   c2:=col1;

   {triangle}
   p1:=x1-x3; q1:=y1-y3;
   p2:=x2-x1; q2:=y2-y1;
   p3:=x3-x2; q3:=y3-y2;

  for yy:=y1 to y2 do
    begin
      ax:=320;
      bx:=-1;
      if (y3>=yy) or (y1>=yy) then
        if (y3<=yy) or (y1<=yy) then
          if not(y3=y1) then begin
              x:=(yy-y3)*p1 div q1+x3;
              if x<ax then ax:=x;
              if x>bx then bx:=x;
            end;
      if (y1>=yy) or (y2>=yy) then
        if (y1<=yy) or (y2<=yy) then
          if not(y1=y2) then begin
              x:=(yy-y1)*p2 div q2+x1;
              if x<ax then ax:=x;
              if x>bx then bx:=x;
            end;
      if (y2>=yy) or (y3>=yy) then
        if (y2<=yy) or (y3<=yy) then
          if not(y2=y3) then begin
              x:=(yy-y2)*p3 div q3+x2;
              if x<ax then ax:=x;
              if x>bx then bx:=x;
            end;
      inc:=(c2-c1)/(bx-ax+1);
      color:=c1;
      for ax:=ax to bx do
      begin
       ppix(ax,yy,round(color),target);
       color:=color+inc;
      end;
      if ax<=bx then begin
      if ideal=false then
        begin {noideal}
         c1:=c1+i12;
         c2:=c2+i13;
        end
        else
        begin {ideal}
         c1:=c1+i13;
         c2:=c2+i12;
        end;
     end;
  end;
  for yy:=y2 to y3 do
    begin
      ax:=320;
      bx:=-1;
      if (y3>=yy) or (y1>=yy) then
        if (y3<=yy) or (y1<=yy) then
          if not(y3=y1) then begin
              x:=(yy-y3)*p1 div q1+x3;
              if x<ax then ax:=x;
              if x>bx then bx:=x;
            end;
      if (y1>=yy) or (y2>=yy) then
        if (y1<=yy) or (y2<=yy) then
          if not(y1=y2) then begin
              x:=(yy-y1)*p2 div q2+x1;
              if x<ax then ax:=x;
              if x>bx then bx:=x;
            end;
      if (y2>=yy) or (y3>=yy) then
        if (y2<=yy) or (y3<=yy) then
          if not(y2=y3) then begin
              x:=(yy-y2)*p3 div q3+x2;
              if x<ax then ax:=x;
              if x>bx then bx:=x;
            end;
      if ax<=bx then
      begin
       inc:=(c2-c1)/(bx-ax+1);
       color:=c1;
       for ax:=ax to bx do
       begin
        ppix(ax,yy,round(color),target);
        color:=color+inc;
       end;
       if ideal=false then
       begin{noideal}
        c1:=c1+i23;
        c2:=c2+i13;
       end
       else
       begin{ideal}
        c1:=c1+i13;
        c2:=c2+i23;
       end;
      end;
    end;
  end;
end;

procedure Ttriangle(num,target:word);
{texturing is the same as gouraud. Instead of interpolating the colors, you
interpolate the u,v}
var
 x1,y1,x2,y2,x3,y3,tx1,ty1,tx2,ty2,tx3,ty3:integer;
 u,v,incu,incv,test,u1,v1,u2,v2,inc12u,inc13u,inc23u,inc12v,inc13v,inc23v:single;
 cnt,x,minY,maxY,midY,xa,xb,yy,p1,q1,p2,q2,p3,q3:integer;
 width,gu,gv:word;
 bitmap:pointer;
 ideal:boolean;
 color:byte;
begin
 if rnz[num]>0 then
 begin
  bitmap:=_map[num];
  width:=_width[num];
  tx1:=_u1[num];
  ty1:=_v1[num];
  tx2:=_u2[num];
  ty2:=_v2[num];
  tx3:=_u3[num];
  ty3:=_v3[num];
   x1:=px[pt1[num]];
   y1:=py[pt1[num]];
   x2:=px[pt2[num]];
   y2:=py[pt2[num]];
   x3:=px[pt3[num]];
   y3:=py[pt3[num]];

  if (y1>y2) then
  begin
   xchgi(y1,y2);
   xchgi(x1,x2);
   xchgi(ty1,ty2);
   xchgi(tx1,tx2);
  end;
  if (y1>y3) then
  begin
   xchgi(y1,y3);
   xchgi(x1,x3);
   xchgi(ty1,ty3);
   xchgi(tx1,tx3);
  end;
  if (y2>y3) then
  begin
   xchgi(y2,y3);
   xchgi(x2,x3);
   xchgi(ty2,ty3);
   xchgi(tx2,tx3);
  end;

  if (y2-y1+1)<>0 then inc12u:=(tx2-tx1)/(y2-y1+1) else inc12u:=0;
  if (y3-y2+1)<>0 then inc23u:=(tx3-tx2)/(y3-y2+1) else inc23u:=0;
  if (y3-y1+1)<>0 then inc13u:=(tx3-tx1)/(y3-y1+1) else inc13u:=0;
  if (y2-y1+1)<>0 then inc12v:=(ty2-ty1)/(y2-y1+1) else inc12v:=0;
  if (y3-y2+1)<>0 then inc23v:=(ty3-ty2)/(y3-y2+1) else inc23v:=0;
  if (y3-y1+1)<>0 then inc13v:=(ty3-ty1)/(y3-y1+1) else inc13v:=0;

  if (y3-y1)<>0 then test:=(x3-x1)/(y3-y1) else test:=0;
  test:=test*(y2-y1);
  test:=test+x1;
  if x2>=test then ideal:=true else ideal:=false;

  u1:=tx1;v1:=ty1;u2:=tx1;v2:=ty1;

  p1:=x1-x3; q1:=y1-y3;
  p2:=x2-x1; q2:=y2-y1;
  p3:=x3-x2; q3:=y3-y2;

  for yy:=Y1 to Y2 do
    begin
      xa:=320;
      xb:=-1;
      if (y3>=yy) or (y1>=yy) then
        if (y3<=yy) or (y1<=yy) then
          if not(y3=y1) then begin
              x:=(yy-y3)*p1 div q1+x3;
              if x<xa then xa:=x;
              if x>xb then xb:=x;
            end;
      if (y1>=yy) or (y2>=yy) then
        if (y1<=yy) or (y2<=yy) then
          if not(y1=y2) then begin
              x:=(yy-y1)*p2 div q2+x1;
              if x<xa then xa:=x;
              if x>xb then xb:=x;
            end;
      if (y2>=yy) or (y3>=yy) then
        if (y2<=yy) or (y3<=yy) then
          if not(y2=y3) then begin
              x:=(yy-y2)*p3 div q3+x2;
              if x<xa then xa:=x;
              if x>xb then xb:=x;
            end;

      if xa<=xb then
      begin
       incu:=(u2-u1)/(xb-xa+1);
       incv:=(v2-v1)/(xb-xa+1);
       u:=u1;
       v:=v1;
       for cnt:=xa to xb do
       begin
         gu:=round(u);
         gv:=round(v);
         asm
           mov di,word ptr bitmap
           mov ax,gv
           mul width
           add ax,gu
           add di,ax
           mov bl,ds:[di]
           mov color,bl
         end;
         ppix(cnt,yy,color,target);
         u:=u+incu;
         v:=v+incv;
       end;
       if ideal=false then
       begin
         u1:=u1+inc12u;
         u2:=u2+inc13u;
         v1:=v1+inc12v;
         v2:=v2+inc13v;
       end else
       begin
         u1:=u1+inc13u;
         u2:=u2+inc12u;
         v1:=v1+inc13v;
         v2:=v2+inc12v;
       end;
     end;
   end;

  for yy:=Y2+1 to Y3 do
    begin
      xa:=320;
      xb:=-1;
      if (y3>=yy) or (y1>=yy) then
        if (y3<=yy) or (y1<=yy) then
          if not(y3=y1) then begin
              x:=(yy-y3)*p1 div q1+x3;
              if x<xa then xa:=x;
              if x>xb then xb:=x;
            end;
      if (y1>=yy) or (y2>=yy) then
        if (y1<=yy) or (y2<=yy) then
          if not(y1=y2) then begin
              x:=(yy-y1)*p2 div q2+x1;
              if x<xa then xa:=x;
              if x>xb then xb:=x;
            end;
      if (y2>=yy) or (y3>=yy) then
        if (y2<=yy) or (y3<=yy) then
          if not(y2=y3) then begin
              x:=(yy-y2)*p3 div q3+x2;
              if x<xa then xa:=x;
              if x>xb then xb:=x;
            end;
      if xa<=xb then
      begin
       incu:=(u2-u1)/(xb-xa+1);
       incv:=(v2-v1)/(xb-xa+1);
       u:=u1;
       v:=v1;
       for cnt:=xa to xb do
       begin
         gu:=round(u);
         gv:=round(v);
         asm
           mov di,word ptr bitmap
           mov ax,gv
           mul width
           add ax,gu
           add di,ax
           mov bl,ds:[di]
           mov color,bl
         end;
         ppix(cnt,yy,color,target);
         u:=u+incu;
         v:=v+incv;
       end;
       if ideal=false then
       begin
         u1:=u1+inc23u;
         u2:=u2+inc13u;
         v1:=v1+inc23v;
         v2:=v2+inc13v;
       end else
       begin
         u1:=u1+inc13u;
         u2:=u2+inc23u;
         v1:=v1+inc13v;
         v2:=v2+inc23v;
       end;
     end;
   end;
 end;
end;

procedure PTriangle(num,target:word);
var
 intensity,w1,w2,w3,inc,i13,i12,i23,dot1,dot2,dot3,test,dot,d1,d2:single; {shading}
 x1,x2,x3,y1,y2,y3:integer;
 ideal:boolean;
 x,ax,bx,yy,p1,q1,p2,q2,p3,q3:integer; {triangle}
 specpower,colormul,coloradd:byte;
 specular,diffuse,ambient:single;

begin
  if rnz[num]>0 then
  begin
   x1:=px[pt1[num]];
   y1:=py[pt1[num]];
   x2:=px[pt2[num]];
   y2:=py[pt2[num]];
   x3:=px[pt3[num]];
   y3:=py[pt3[num]];

   specpower:=_specpower[num];
   specular:=_specular[num];
   diffuse:=_diffuse[num];
   ambient:=_ambient[num];
   colormul:=xshademul[xshade[num]];
   coloradd:=xcoloradd[xshade[num]];

   dot1:=(rx[pt1[num]]*lx+ry[pt1[num]]*ly+rz[pt1[num]]*lz)*vmul[pt1[num]];
   dot2:=(rx[pt2[num]]*lx+ry[pt2[num]]*ly+rz[pt2[num]]*lz)*vmul[pt2[num]];
   dot3:=(rx[pt3[num]]*lx+ry[pt3[num]]*ly+rz[pt3[num]]*lz)*vmul[pt3[num]];

   if (y1>y2) then
   begin
    xchgi(y1,y2);
    xchgi(x1,x2);
    xchgs(dot1,dot2);
   end;
   if (y1>y3) then
   begin
    xchgi(y1,y3);
    xchgi(x1,x3);
    xchgs(dot1,dot3);
   end;
   if (y2>y3) then
   begin
    xchgi(y2,y3);
    xchgi(x2,x3);
    xchgs(dot2,dot3);
   end;

   if (y3-y1+1<>0) then i13:=(dot3-dot1)/(y3-y1+1) else i13:=0;
   if (y3-y2+1<>0) then i23:=(dot3-dot2)/(y3-y2+1) else i23:=0;
   if (y2-y1+1<>0) then i12:=(dot2-dot1)/(y2-y1+1) else i12:=0;

   if (y3-y1)<>0 then test:=(x3-x1)/(y3-y1) else test:=0;
   test:=test*(y2-y1);
   test:=test+x1;
   if x2>=test then ideal:=true else ideal:=false;

   d1:=dot1;
   d2:=dot1;

   {triangle}
   p1:=x1-x3; q1:=y1-y3;
   p2:=x2-x1; q2:=y2-y1;
   p3:=x3-x2; q3:=y3-y2;

  for yy:=y1 to y2 do
    begin
      ax:=320;
      bx:=-1;
      if (y3>=yy) or (y1>=yy) then
        if (y3<=yy) or (y1<=yy) then
          if not(y3=y1) then begin
              x:=(yy-y3)*p1 div q1+x3;
              if x<ax then ax:=x;
              if x>bx then bx:=x;
            end;
      if (y1>=yy) or (y2>=yy) then
        if (y1<=yy) or (y2<=yy) then
          if not(y1=y2) then begin
              x:=(yy-y1)*p2 div q2+x1;
              if x<ax then ax:=x;
              if x>bx then bx:=x;
            end;
      if (y2>=yy) or (y3>=yy) then
        if (y2<=yy) or (y3<=yy) then
          if not(y2=y3) then begin
              x:=(yy-y2)*p3 div q3+x2;
              if x<ax then ax:=x;
              if x>bx then bx:=x;
            end;
      inc:=(d2-d1)/(bx-ax+1);
      dot:=d1;
      for ax:=ax to bx do
      begin
       intensity:=abs(ambient+(diffuse*dot)+(specular*pow(dot,specpower)));
       ppix(ax,yy,round(colormul*intensity)+coloradd,target);
       dot:=dot+inc;
      end;
      if ax<=bx then begin
      if ideal=false then
        begin {noideal}
         d1:=d1+i12;
         d2:=d2+i13;
        end
        else
        begin {ideal}
         d1:=d1+i13;
         d2:=d2+i12;
        end;
     end;
  end;
  for yy:=y2 to y3 do
    begin
      ax:=320;
      bx:=-1;
      if (y3>=yy) or (y1>=yy) then
        if (y3<=yy) or (y1<=yy) then
          if not(y3=y1) then begin
              x:=(yy-y3)*p1 div q1+x3;
              if x<ax then ax:=x;
              if x>bx then bx:=x;
            end;
      if (y1>=yy) or (y2>=yy) then
        if (y1<=yy) or (y2<=yy) then
          if not(y1=y2) then begin
              x:=(yy-y1)*p2 div q2+x1;
              if x<ax then ax:=x;
              if x>bx then bx:=x;
            end;
      if (y2>=yy) or (y3>=yy) then
        if (y2<=yy) or (y3<=yy) then
          if not(y2=y3) then begin
              x:=(yy-y2)*p3 div q3+x2;
              if x<ax then ax:=x;
              if x>bx then bx:=x;
            end;
      if ax<=bx then
      begin
       inc:=(d2-d1)/(bx-ax+1);
       dot:=d1;
       for ax:=ax to bx do
       begin
       intensity:=abs(ambient+(diffuse*dot)+(specular*pow(dot,specpower)));
       ppix(ax,yy,round(colormul*intensity)+coloradd,target);
        dot:=dot+inc;
       end;
       if ideal=false then
       begin{noideal}
        d1:=d1+i23;
        d2:=d2+i13;
       end
       else
       begin{ideal}
        d1:=d1+i13;
        d2:=d2+i23;
       end;
      end;
    end;
  end;
end;


procedure gcoords(alfa,beta,gama:byte);
var sinx,siny,sinz,cosx,cosy,cosz:single;
    mx1,mx2,mx3,my1,my2,my3,mz1,mz2,mz3:single;
    c:word;s:single;
begin
 mx1:=gsin[gama]*gsin[beta]*gsin[alfa]+gcos[gama]*gcos[alfa];
 my1:=gcos[beta]*gsin[alfa];
 mz1:=gsin[gama]*gcos[alfa]-gcos[gama]*gsin[beta]*gsin[alfa];
 mx2:=gsin[gama]*gsin[beta]*gcos[alfa]-gcos[gama]*gsin[alfa];
 my2:=gcos[beta]*gcos[alfa];
 mz2:=-gcos[gama]*gsin[beta]*gcos[alfa]-gsin[gama]*gsin[alfa];
 mx3:=-gsin[gama]*gcos[beta];
 my3:=gsin[beta];
 mz3:=gcos[gama]*gcos[beta];
 for c:=1 to pointcount do begin
   rx[c]:=mx1*ox[c]+my1*oy[c]+mz1*oz[c];
   ry[c]:=mx2*ox[c]+my2*oy[c]+mz2*oz[c];
   rz[c]:=mx3*ox[c]+my3*oy[c]+mz3*oz[c];
   s:=(dist+rz[c])/dist;
   px[c]:=round(origoX+s*rx[c]);
   py[c]:=round(origoY+s*ry[c]);
 end;
 for c:=1 to ptcount do begin
   rnz[c]:=mx3*nox[c]+my3*noy[c]+mz3*noz[c];
   if rnz[c]>0 then begin
     rny[c]:=mx2*nox[c]+my2*noy[c]+mz2*noz[c];
     rnz[c]:=mx3*nox[c]+my3*noy[c]+mz3*noz[c];
   end;
 end;
end;

procedure rot(var a,b,c,inca,incb,incc:byte;target:word);
var cnt:word;
begin
  a:=byte(a+inca);
  b:=byte(b+incb);
  c:=byte(c+incc);
  GCoords(a,b,c);
  for cnt:=1 to ptcount do
  case cover[cnt] of
   0:Ptriangle(cnt,target);
   1:Ttriangle(cnt,target);
   2:Gtriangle(cnt,target);
   3:Ltriangle(cnt,target);
   4:Striangle(cnt,target);
  end;
  flip(target,$0a000);
  cls(target);
end;

procedure prepare;
var vl,light,z,x,y,norm:extended;
c:word;
begin
 for c:=1 to ptcount do
 begin
  x:=(oy[pt2[c]]-oy[pt1[c]])*(oz[pt1[c]]-oz[pt3[c]])-(oz[pt2[c]]-oz[pt1[c]])*(oy[pt1[c]]-oy[pt3[c]]);
  y:=(oz[pt2[c]]-oz[pt1[c]])*(ox[pt1[c]]-ox[pt3[c]])-(ox[pt2[c]]-ox[pt1[c]])*(oz[pt1[c]]-oz[pt3[c]]);
  z:=(ox[pt2[c]]-ox[pt1[c]])*(oy[pt1[c]]-oy[pt3[c]])-(oy[pt2[c]]-oy[pt1[c]])*(ox[pt1[c]]-ox[pt3[c]]);
  norm:=sqrt(sqr(x)+sqr(y)+sqr(z));
  nox[c]:=x/norm;
  noy[c]:=y/norm;
  noz[c]:=z/norm;
 end;
 for c:=1 to pointcount do
 begin
  vl:=sqrt(sqr(oy[c])+sqr(oz[c])+sqr(ox[c]));
  vmul[c]:=1/vl;
 end;
 light:=sqrt(sqr(lx)+sqr(ly)+sqr(lz));
 lx:=lx/light;
 ly:=ly/light;
 lz:=lz/light;
end;

procedure setshades(rh,gh,bh,rl,gl,bl,col1,col2,color:byte);
var rr,gg,bb,r,g,b,incr,incg,incb:single;
    count,cto:byte;
begin
 incr:=(rh-rl)/abs(col2-col1);
 incg:=(gh-gl)/abs(col2-col1);
 incb:=(bh-bl)/abs(col2-col1);
 if col1<col2 then
 begin
   count:=col1;
   cto:=col2;
 end else
 begin
   count:=col2;
   cto:=col1;
 end;
 r:=rl; g:=gl; b:=bl;
 rr:=rl; gg:=gl; bb:=bl;
 for count:=count to cto do
 begin
   setrgb(count,round(r),round(g),round(b));
   rr:=rr+incr;
   gg:=gg+incg;
   bb:=bb+incb;
   r:=rr; g:=gg; b:=bb;
 end;
 setrgb(count,round(r),round(g),round(b));
 xshademul[color]:=(abs(col2-col1) div 2);
 xshadeadd[color]:=(abs(col2-col1) div 2)+col1;
 xcoloradd[color]:=col1;
end;

const map:array[0..41,0..41] of byte=(
(14, 6,14, 6, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6, 6,14, 6,14,14, 6,14, 6,14, 6,14, 6,14,6,14,6,14,6,14,6,14),
( 6,14, 6,14,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14,14, 6,14, 6, 6,14, 6,14, 6,14, 6,14, 6,14,6,14,6,14,6,14,6),
(14, 6,14, 6, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6, 6,14, 6,14,14, 6,14, 6,14, 6,14, 6,14,6,14,6,14,6,14,6,14),
( 6,14, 6,14,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14,14, 6,14, 6, 6,14, 6,14, 6,14, 6,14, 6,14,6,14,6,14,6,14,6),
(14, 6,14, 6, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6, 6,14, 6,14,14, 6,14, 6,14, 6,14, 6,14,6,14,6,14,6,14,6,14),
( 6,14, 6,14,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14,14, 6,14, 6, 6,14, 6,14, 6,14, 6,14, 6,14,6,14,6,14,6,14,6),
(14, 6,14, 6, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6, 6,14, 6,14,14, 6,14, 6,14, 6,14, 6,14,6,14,6,14,6,14,6,14),
( 6,14, 6,14,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14,14, 6,14, 6, 6,14, 6,14, 6,14, 6,14, 6,14,6,14,6,14,6,14,6),
(14, 6,14, 6, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6, 6,14, 6,14,14, 6,14, 6,14, 6,14, 6,14,6,14,6,14,6,14,6,14),
( 6,14, 6,14,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14,14, 6,14, 6, 6,14, 6,14, 6,14, 6,14, 6,14,6,14,6,14,6,14,6),
(14, 6,14, 6, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6, 6,14, 6,14,14, 6,14, 6,14, 6,14, 6,14,6,14,6,14,6,14,6,14),
( 6,14, 6,14,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14,14, 6,14, 6, 6,14, 6,14, 6,14, 6,14, 6,14,6,14,6,14,6,14,6),
(14, 6,14, 6, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6, 6,14, 6,14,14, 6,14, 6,14, 6,14, 6,14,6,14,6,14,6,14,6,14),
( 6,14, 6,14,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14,14, 6,14, 6, 6,14, 6,14, 6,14, 6,14, 6,14,6,14,6,14,6,14,6),
(14, 6,14, 6, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6, 6,14, 6,14,14, 6,14, 6,14, 6,14, 6,14,6,14,6,14,6,14,6,14),
( 6,14, 6,14,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14,14, 6,14, 6, 6,14, 6,14, 6,14, 6,14, 6,14,6,14,6,14,6,14,6),
(14, 6,14, 6, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6, 6,14, 6,14,14, 6,14, 6,14, 6,14, 6,14,6,14,6,14,6,14,6,14),
( 6,14, 6,14,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14,14, 6,14, 6, 6,14, 6,14, 6,14, 6,14, 6,14,6,14,6,14,6,14,6),
(14, 6,14, 6, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6, 6,14, 6,14,14, 6,14, 6,14, 6,14, 6,14,6,14,6,14,6,14,6,14),
( 6,14, 6,14,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14,14, 6,14, 6, 6,14, 6,14, 6,14, 6,14, 6,14,6,14,6,14,6,14,6),
(14, 6,14, 6, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6, 6,14, 6,14,14, 6,14, 6,14, 6,14, 6,14,6,14,6,14,6,14,6,14),
( 6,14, 6,14,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14,14, 6,14, 6, 6,14, 6,14, 6,14, 6,14, 6,14,6,14,6,14,6,14,6),
(14, 6,14, 6, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6, 6,14, 6,14,14, 6,14, 6,14, 6,14, 6,14,6,14,6,14,6,14,6,14),
( 6,14, 6,14,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14,14, 6,14, 6, 6,14, 6,14, 6,14, 6,14, 6,14,6,14,6,14,6,14,6),
(14, 6,14, 6, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6, 6,14, 6,14,14, 6,14, 6,14, 6,14, 6,14,6,14,6,14,6,14,6,14),
( 6,14, 6,14,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14,14, 6,14, 6, 6,14, 6,14, 6,14, 6,14, 6,14,6,14,6,14,6,14,6),
(14, 6,14, 6, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6, 6,14, 6,14,14, 6,14, 6,14, 6,14, 6,14,6,14,6,14,6,14,6,14),
( 6,14, 6,14,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14,14, 6,14, 6, 6,14, 6,14, 6,14, 6,14, 6,14,6,14,6,14,6,14,6),
(14, 6,14, 6, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6, 6,14, 6,14,14, 6,14, 6,14, 6,14, 6,14,6,14,6,14,6,14,6,14),
( 6,14, 6,14,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14,14, 6,14, 6, 6,14, 6,14, 6,14, 6,14, 6,14,6,14,6,14,6,14,6),
(14, 6,14, 6, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6, 6,14, 6,14,14, 6,14, 6,14, 6,14, 6,14,6,14,6,14,6,14,6,14),
( 6,14, 6,14,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14,14, 6,14, 6, 6,14, 6,14, 6,14, 6,14, 6,14,6,14,6,14,6,14,6),
(14, 6,14, 6, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6, 6,14, 6,14,14, 6,14, 6,14, 6,14, 6,14,6,14,6,14,6,14,6,14),
( 6,14, 6,14,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14,14, 6,14, 6, 6,14, 6,14, 6,14, 6,14, 6,14,6,14,6,14,6,14,6),
(14, 6,14, 6, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6, 6,14, 6,14,14, 6,14, 6,14, 6,14, 6,14,6,14,6,14,6,14,6,14),
( 6,14, 6,14,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14,14, 6,14, 6, 6,14, 6,14, 6,14, 6,14, 6,14,6,14,6,14,6,14,6),
(14, 6,14, 6, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6, 6,14, 6,14,14, 6,14, 6,14, 6,14, 6,14,6,14,6,14,6,14,6,14),
( 6,14, 6,14,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14,14, 6,14, 6, 6,14, 6,14, 6,14, 6,14, 6,14,6,14,6,14,6,14,6),
(14, 6,14, 6, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6, 6,14, 6,14,14, 6,14, 6,14, 6,14, 6,14,6,14,6,14,6,14,6,14),
( 6,14, 6,14,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14,14, 6,14, 6, 6,14, 6,14, 6,14, 6,14, 6,14,6,14,6,14,6,14,6),
(14, 6,14, 6, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6, 6,14, 6,14,14, 6,14, 6,14, 6,14, 6,14,6,14,6,14,6,14,6,14),
( 6,14, 6,14,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14, 6,14,14, 6,14, 6, 6,14, 6,14, 6,14, 6,14, 6,14,6,14,6,14,6,14,6));


var
aa,bb,cc,incaa,incbb,inccc:byte;
vp:vpointer;
adr:word;
rd:char;
time:longint absolute $0:$046c;
c,frame,etime,stime:longint;

begin
 for frame:=2000000 downto 0 do asm nop; end;
 writeln(' This is the GO! 3D engine, ver. 1.51');
 writeln; writeln; writeln; writeln;
 for frame:=2000000 downto 0 do asm nop; end;
 writeln('',
 'Capabilities:',#13#10,
 ' not shaded triangles',#13#10,
 ' lambert shaded triangles',#13#10,
 ' gouraud shaded triangles',#13#10,
 ' texture mapped triangles (affine)',#13#10,
 ' pregenerated sin,cos,yoffset',#13#10,
 ' 9 mul matrix rotation',#13#10,
 ' phong shading');
 writeln; writeln; writeln; writeln;
 writeln('Usage Keys:',#13#10,
 'Z,X,C,V,B,N',#13#10    ,
 'A,S : Rotation',#13#10,
 '1,2,3,4,5 : Face cover type (Color, Lambert, Gouraud, Affine Texture, Phong');
 readln;
 writeln; writeln; writeln;
 writeln('Loading..');
 asm  mov ax,13h; int 10h end;
 sinus;
 cosinus;
 poffset(320,200);
 LoadCoords('cube.x');
 for adr:=1 to 20 do
 begin
   setrgb(6,63,63,0); setrgb(14,63,0,0);
  _map[adr]:=@map;
  _width[adr]:=42;
  _u1[adr]:=0;
  _v1[adr]:=0;
  _u2[adr]:=41;
  _v2[adr]:=0;
  _u3[adr]:=41;
  _v3[adr]:=41;
  _ambient[adr]:=0.0;
  _diffuse[adr]:=0.8;
  _specular[adr]:=1.2;
  _specpower[adr]:=2;
   cover[adr]:=1;
end;
 incaa:=0;
 incbb:=0;
 inccc:=0;
 aa:=00;
 bb:=00;
 cc:=00;
 lx:=0;
 ly:=0;
 lz:=10;
 origox:=160;
 origoy:=100;
 dist:=32678;
 adr:=vsetup(vp);
 cls(adr);
 prepare;
 stime:=time;
repeat
 inc(frame);
 rot(aa,bb,cc,incaa,incbb,inccc,adr);
 if keypressed then
  begin rd:=readkey;
   case rd of
         '1':begin for c:=0 to 21 do cover[c]:=4;
             setshades(0,0,63,0,0,0,1,64,1); end;
         '2':begin for c:=0 to 21 do cover[c]:=3;
             setshades(0,0,63,0,0,0,1,64,1); end;
         '3':begin for c:=0 to 21 do cover[c]:=2;
             setshades(0,0,63,0,0,0,1,64,1); end;
         '4':begin for c:=0 to 21 do cover[c]:=1;
             setrgb(6,63,63,0); setrgb(14,63,0,0);end;
         '5':begin for c:=0 to 21 do cover[c]:=0;
              setshades(0,0,48,0,0,0,1,72,1);
              setrgb(72,60,60,63); setrgb(71,55,55,63); setrgb(70,50,50,63);
              setrgb(69,45,45,63); setrgb(68,45,45,63); setrgb(67,40,40,63);
              setrgb(66,35,35,63); setrgb(65,30,30,63); setrgb(64,25,25,63);
              setrgb(63,16,16,63); setrgb(62,12,12,63); setrgb(61,8,8,63);
              setrgb(60,4,4,63); setrgb(59,0,0,59); setrgb(58,0,0,55); setrgb(57,0,0,51);end;
 
         'z':inc(incbb);
         'x':dec(incbb);
         'c':inc(inccc);
         'v':dec(inccc);
         'b':inc(incaa);
         'n':dec(incaa);
         't':begin lx:=lx+0.01;
                   ly:=ly+0.01;
                   lz:=lz-0.02; end;
         's':begin aa:=0;
                   bb:=0;
                   cc:=0;
                   incaa:=0;
                   incbb:=0;
                   inccc:=0; end;
      'a':begin
           incaa:=0;
           incbb:=0;
           inccc:=0;
          end;
     end;
   end;
 until rd=#27;
 etime:=time;
 asm  mov ax,3 ; int 10h end;
 writeln((Frame*18.2)/(ETime-STime):5:2, ' fps');
end.


Development:
Version 10  - Created
Version 11  - Rewritten kernel
               Unshaded triangles
               Lambert shaded triangles
               Gouraud shaded triangles
Version 12  - Texture mapped triangles (affine)
Version 13  - Pregenerated sin,cos,yoffset
Version 14  - 9 mul matrix rotation
Version 15  - Phong shading
Version 151 - Improoved power routine
