; AVRDEMO1.ASM
; (C) 1998 DIGITIP
; This example shows how to implement single LED driver with Atmel AT90S1200.
; BCD (binary coded decimal) value present on port D0-D3 and latched with
; \WR converted to 7 segment LED code and shown on display. If input value
; exceeds 9, display turned off. Simple code modification allows showing
; hex values A-F. Code is not memory efficient, but fast.
;-------------------------------------------------------------------------;
; Simplified schematic                                                    ;
;            ____     ____            _________________________           ; 
;         --|RST  \_/  VCC|--       /    |           |A         \         ;
;         --|PD0   A   PB7|--      |     |         * * *         |        ;
;     \WR --|PD1   T   PB6|-- ---G-|     |       *       *       |        ;
;         --|XT2   9   PB5|-- ---F-|     |\_F___ *       * ___B_/|        ;
;         --|XT1   0   PB4|-- ---E-|     |       *       *       |        ;
;     D0  --|PD2   S   PB3|-- ---D-|     |\_G_____ * * *         |        ;
;     D1  --|PD3   1   PB2|-- ---C-|     |       *       *       |        ;
;     D2  --|PD4   2   PB1|-- ---B-|      \_E___ *       * ___C_/|        ;
;     D3  --|PD5   0   PB0|-- ---A-|             *       *       |        ;
;         --|GND   0   PD6|--                      * * *         |        ;
;            -------------                           \________D_/         ;
;                                                                         ;
; Data in BCD format written to 4 bit port D0-D3 and must followed by     ;
; low pulse on input \WR. D0-D3 must remain unchanged until \WR low.      ;
;-------------------------------------------------------------------------;
.include "1200def.inc"
.include "ll90avr.inc"			; Include LED code definitions

.CSEG
; Initialization routine
		ldi	R16,0xFF	; Set up I/O ports
		out	DDRB,R16	; PORTB for output
		inc	R16		; R16=0
		out	DDRD,R16	; PORTD for input
		rjmp	Set0		; Display 0 after reset
; Main loop here
WaitWR:		sbic	PORTD,1		; If WR low, read D0-D3,
		rjmp	WaitWR		; else loop forever
		in	R16,PORTD	; Read port state to R16
		lsr	R16		; Shift D0-D3 state to R16
		lsr	R16		; low nibble
		andi	R16,0x0F	; Mask unused bits
		breq	Set0		; BCD=0, if zero flag set
		dec	R16		; Decrease R16 by 1
		breq	Set1		; BCD=1, if zero
		dec	R16
		breq	Set2		; BCD=2?
		dec	R16
		breq	Set3		; BCD=3?
		dec	R16
		breq	Set4		; BCD=4?
		dec	R16
		breq	Set5		; BCD=5?
		dec	R16
		breq	Set6		; BCD=6?
		dec	R16
		breq	Set7		; BCD=7?
		dec	R16
		breq	Set8		; BCD=8?
		dec	R16
		breq	Set9		; BCD=9?
		rjmp	DSPOff		; BCD greater than 9, turn display off
					; If HEX codes required to display,
					; add code for digits A-F
Set0:		ldi	R16,CLEDCHR0	; Load character '0' bitmap to R16
		rjmp	DSPWrite	; Jump to display write
Set1:		ldi	R16,CLEDCHR1	; Load character '1' bitmap to R16
		rjmp	DSPWrite	; Jump to display write
Set2:		ldi	R16,CLEDCHR2	; Load character '2' bitmap to R16
		rjmp	DSPWrite	; Jump to display write
Set3:		ldi	R16,CLEDCHR3	; Load character '3' bitmap to R16
		rjmp	DSPWrite	; Jump to display write
Set4:		ldi	R16,CLEDCHR4	; Load character '4' bitmap to R16
		rjmp	DSPWrite	; Jump to display write
Set5:		ldi	R16,CLEDCHR5	; Load character '5' bitmap to R16
		rjmp	DSPWrite	; Jump to display write
Set6:		ldi	R16,CLEDCHR6	; Load character '6' bitmap to R16
		rjmp	DSPWrite	; Jump to display write
Set7:		ldi	R16,CLEDCHR7	; Load character '7' bitmap to R16
		rjmp	DSPWrite	; Jump to display write
Set8:		ldi	R16,CLEDCHR8	; Load character '8' bitmap to R16
		rjmp	DSPWrite	; Jump to display write
Set9:		ldi	R16,CLEDCHR9	; Load character '9' bitmap to R16
		rjmp	DSPWrite	; Jump to display write
DSPOff:		ldi	R16,CLEDCHRNONE	; Load 'no character' bitmap to R16
DSPWrite:	out	PORTB,R16	; Write character bitmap to display
		rjmp	WaitWR		; and check \WR pin again
