; <<< LL51ML.INC - part of LEDLibrary       (C) 1998 DIGITIP >>>
$NOLIST
; 
;                                                          a          
;  7-SEGMENT LED CODES (part of LEDLibrary)              f   b        
;  (C) 1998 DIGITIP                                       g         
;                                                        edc h     
; 
; Metalink 8051 assembler specific mnemonic

; Segment bit definitions. Change for your needs.
; Example: Segment D = bit 2 ---> LS_D 1 SHL 2
LS_A	equ	1 SHL 0		; LED segment A bit
LS_B	equ	1 SHL 1		; LED segment B bit
LS_C	equ	1 SHL 2		; LED segment C bit
LS_D	equ	1 SHL 3		; LED segment D bit
LS_E	equ	1 SHL 4		; LED segment E bit
LS_F	equ	1 SHL 5		; LED segment F bit
LS_G	equ	1 SHL 6		; LED segment G bit
LS_H	equ	1 SHL 7		; LED segment H bit

; LED character bitmaps
; NOTE: some characters available only in lower- or uppercase letters.
;       Uppercase symbolic name used if only one combination possible.
LEDCHR0 equ (LS_A OR LS_B OR LS_C OR LS_D OR LS_E OR LS_F)		; '0'
LEDCHR1 equ (LS_B OR LS_C)						; '1'
LEDCHR2 equ (LS_A OR LS_B OR LS_D OR LS_E OR LS_G)			; '2'
LEDCHR3 equ (LS_A OR LS_B OR LS_C OR LS_D OR LS_G)			; '3'
LEDCHR4 equ (LS_B OR LS_C OR LS_F OR LS_G)				; '4'
LEDCHR5 equ (LS_A OR LS_C OR LS_E OR LS_F OR LS_G)			; '5'
LEDCHR6 equ (LS_A OR LS_C OR LS_D OR LS_E OR LS_F OR LS_G)		; '6'
LEDCHR7 equ (LS_A OR LS_B OR LS_C)					; '7'
LEDCHR8 equ (LS_A OR LS_B OR LS_C OR LS_D OR LS_E OR LS_F OR LS_G)	; '8'
LEDCHR9 equ (LS_A OR LS_B OR LS_C OR LS_D OR LS_F OR LS_G)		; '9'
LEDCHRA equ (LS_A OR LS_B OR LS_C OR LS_E OR LS_F OR LS_G)		; 'A'
LEDCHRB equ (LS_C OR LS_D OR LS_E OR LS_F OR LS_G)			; 'b'
LEDCHRC equ (LS_A OR LS_D OR LS_E OR LS_F)				; 'C'
LEDCHRCL equ (LS_D OR LS_E OR LS_G)					; 'c'
LEDCHRD equ (LS_B OR LS_C OR LS_D OR LS_E OR LS_G)			; 'd'
LEDCHRE equ (LS_A OR LS_D OR LS_E OR LS_F OR LS_G)			; 'E'
LEDCHRF equ (LS_A OR LS_E OR LS_F OR LS_G)				; 'F'
LEDCHRH equ (LS_A OR LS_B OR LS_E OR LS_F OR LS_G)			; 'H'
LEDCHRI equ (LS_B OR LS_C)						; 'I'
LEDCHRIL equ (LS_C)							; 'i'
LEDCHRJ equ (LS_B OR LS_C OR LS_D)					; 'J'
LEDCHRJL equ (LS_C OR LS_D)						; 'j'
LEDCHRL equ (LS_D OR LS_E OR LS_F)					; 'L'
LEDCHRN equ (LS_C OR LS_E OR LS_G)					; 'n'
LEDCHRO equ (LS_A OR LS_B OR LS_C OR LS_D OR LS_E OR LS_F)		; 'O'
LEDCHROL equ (LS_C OR LS_D OR LS_E OR LS_G)				; 'o'
LEDCHRP equ (LS_A OR LS_B OR LS_E OR LS_F OR LS_G)			; 'P'
LEDCHRR equ (LS_E OR LS_G)						; 'r'
LEDCHRS equ (LS_A OR LS_C OR LS_E OR LS_F OR LS_G)			; 'S'
LEDCHRT equ (LS_D OR LS_E OR LS_F OR LS_G)				; 't'
LEDCHRU equ (LS_B OR LS_C OR LS_D OR LS_E OR LS_F)			; 'U'
LEDCHRUL equ (LS_C OR LS_D OR LS_E)					; 'u'
LEDCHRY equ (LS_B OR LS_C OR LS_D OR LS_F OR LS_G)			; 'Y'
LEDCHRMINUS equ (LS_G)							; '-'
LEDCHRSPACE equ (LS_D)							; '_'
LEDCHRNONE equ 0							; 'off'

; Inverted LED character bitmaps for direct LED driving
CLEDCHR0 equ NOT LEDCHR0
CLEDCHR1 equ NOT LEDCHR1
CLEDCHR2 equ NOT LEDCHR2
CLEDCHR3 equ NOT LEDCHR3
CLEDCHR4 equ NOT LEDCHR4
CLEDCHR5 equ NOT LEDCHR5
CLEDCHR6 equ NOT LEDCHR6
CLEDCHR7 equ NOT LEDCHR7
CLEDCHR8 equ NOT LEDCHR8
CLEDCHR9 equ NOT LEDCHR9
CLEDCHRA equ NOT LEDCHRA
CLEDCHRB equ NOT LEDCHRB
CLEDCHRC equ NOT LEDCHRC
CLEDCHRCL equ NOT LEDCHRCL
CLEDCHRD equ NOT LEDCHRD
CLEDCHRE equ NOT LEDCHRE
CLEDCHRF equ NOT LEDCHRF
CLEDCHRH equ NOT LEDCHRH
CLEDCHRI equ NOT LEDCHRI
CLEDCHRIL equ NOT LEDCHRIL
CLEDCHRJ equ NOT LEDCHRJ
CLEDCHRJL equ NOT LEDCHRJL
CLEDCHRL equ NOT LEDCHRL
CLEDCHRN equ NOT LEDCHRN
CLEDCHRO equ NOT LEDCHRO
CLEDCHROL equ NOT LEDCHROL
CLEDCHRP equ NOT LEDCHRP
CLEDCHRR equ NOT LEDCHRR
CLEDCHRS equ NOT LEDCHRS
CLEDCHRT equ NOT LEDCHRT
CLEDCHRU equ NOT LEDCHRU
CLEDCHRUL equ NOT LEDCHRUL
CLEDCHRY equ NOT LEDCHRY
CLEDCHRMINUS equ NOT LEDCHRMINUS
CLEDCHRSPACE equ NOT LEDCHRSPACE
CLEDCHRNONE equ NOT LEDCHRNONE
; Example:
; mov	P1,CLEDCHR2	; Write inverted LED character '2' to port 1
$LIST