; <<< LL90AVR.INC - part of LEDLibrary      (C) 1998 DIGITIP >>>     
.NOLIST
; 
;                                                          a          
;  7-SEGMENT LED CODES (part of LEDLibrary)              f   b        
;  (C) 1998 DIGITIP                                       g         
;                                                        edc h     
; 
; Atmel AVR assembler specific mnemonic
;
; This file defines various seven segment LED display codes for easier
; implementing LED display.

; Segment bit definitions. Change for your needs.
; Example: Segment E = bit 0 ---> LS_E 1 SHL 0
.equ LS_A=1<<0		; LED segment A bit
.equ LS_B=1<<1		; LED segment B bit
.equ LS_C=1<<2		; LED segment C bit
.equ LS_D=1<<3		; LED segment D bit
.equ LS_E=1<<4		; LED segment E bit
.equ LS_F=1<<5		; LED segment F bit
.equ LS_G=1<<6		; LED segment G bit
.equ LS_H=1<<7		; LED segment H bit

; LED character bitmaps
; NOTE: some characters available only in lower- or uppercase letters.
;       Uppercase symbolic name used if only one combination possible.
.equ LEDCHR0=LS_A|LS_B|LS_C|LS_D|LS_E|LS_F				; '0'
.equ LEDCHR1=LS_B|LS_C							; '1'
.equ LEDCHR2=LS_A|LS_B|LS_D|LS_E|LS_G					; '2'
.equ LEDCHR3=LS_A|LS_B|LS_C|LS_D|LS_G					; '3'
.equ LEDCHR4=LS_B|LS_C|LS_F|LS_G					; '4'
.equ LEDCHR5=LS_A|LS_C|LS_E|LS_F|LS_G					; '5'
.equ LEDCHR6=LS_A|LS_C|LS_D|LS_E|LS_F|LS_G				; '6'
.equ LEDCHR7=LS_A|LS_B|LS_C						; '7'
.equ LEDCHR8=LS_A|LS_B|LS_C|LS_D|LS_E|LS_F|LS_G				; '8'
.equ LEDCHR9=LS_A|LS_B|LS_C|LS_D|LS_F|LS_G				; '9'
.equ LEDCHRA=LS_A|LS_B|LS_C|LS_E|LS_F|LS_G				; 'A'
.equ LEDCHRB=LS_C|LS_D|LS_E|LS_F|LS_G					; 'b'
.equ LEDCHRC=LS_A|LS_D|LS_E|LS_F					; 'C'
.equ LEDCHRCL=LS_D|LS_E|LS_G						; 'c'
.equ LEDCHRD=LS_B|LS_C|LS_D|LS_E|LS_G					; 'd'
.equ LEDCHRE=LS_A|LS_D|LS_E|LS_F|LS_G					; 'E'
.equ LEDCHRF=LS_A|LS_E|LS_F|LS_G					; 'F'
.equ LEDCHRH=LS_A|LS_B|LS_E|LS_F|LS_G					; 'H'
.equ LEDCHRI=LS_B|LS_C							; 'I'
.equ LEDCHRIL=LS_C							; 'i'
.equ LEDCHRJ=LS_B|LS_C|LS_D						; 'J'
.equ LEDCHRJL=LS_C|LS_D							; 'j'
.equ LEDCHRL=LS_D|LS_E|LS_F						; 'L'
.equ LEDCHRN=LS_C|LS_E|LS_G						; 'n'
.equ LEDCHRO=LS_A|LS_B|LS_C|LS_D|LS_E|LS_F				; 'O'
.equ LEDCHROL=LS_C|LS_D|LS_E|LS_G					; 'o'
.equ LEDCHRP=LS_A|LS_B|LS_E|LS_F|LS_G					; 'P'
.equ LEDCHRR=LS_E|LS_G							; 'r'
.equ LEDCHRS=LS_A|LS_C|LS_E|LS_F|LS_G					; 'S'
.equ LEDCHRT=LS_D|LS_E|LS_F|LS_G					; 't'
.equ LEDCHRU=LS_B|LS_C|LS_D|LS_E|LS_F					; 'U'
.equ LEDCHRUL=LS_C|LS_D|LS_E						; 'u'
.equ LEDCHRY=LS_B|LS_C|LS_D|LS_F|LS_G					; 'Y'
.equ LEDCHRMINUS=LS_G							; '-'
.equ LEDCHRSPACE=LS_D							; '_'
.equ LEDCHRNONE=0							; 'off'

; Inverted LED character bitmaps for direct LED driving
.equ CLEDCHR0=~LEDCHR0
.equ CLEDCHR1=~LEDCHR1
.equ CLEDCHR2=~LEDCHR2
.equ CLEDCHR3=~LEDCHR3
.equ CLEDCHR4=~LEDCHR4
.equ CLEDCHR5=~LEDCHR5
.equ CLEDCHR6=~LEDCHR6
.equ CLEDCHR7=~LEDCHR7
.equ CLEDCHR8=~LEDCHR8
.equ CLEDCHR9=~LEDCHR9
.equ CLEDCHRA=~LEDCHRA
.equ CLEDCHRB=~LEDCHRB
.equ CLEDCHRC=~LEDCHRC
.equ CLEDCHRCL=~LEDCHRCL
.equ CLEDCHRD=~LEDCHRD
.equ CLEDCHRE=~LEDCHRE
.equ CLEDCHRF=~LEDCHRF
.equ CLEDCHRH=~LEDCHRH
.equ CLEDCHRI=~LEDCHRI
.equ CLEDCHRIL=~LEDCHRIL
.equ CLEDCHRJ=~LEDCHRJ
.equ CLEDCHRJL=~LEDCHRJL
.equ CLEDCHRL=~LEDCHRL
.equ CLEDCHRN=~LEDCHRN
.equ CLEDCHRO=~LEDCHRO
.equ CLEDCHROL=~LEDCHROL
.equ CLEDCHRP=~LEDCHRP
.equ CLEDCHRR=~LEDCHRR
.equ CLEDCHRS=~LEDCHRS
.equ CLEDCHRT=~LEDCHRT
.equ CLEDCHRU=~LEDCHRU
.equ CLEDCHRUL=~LEDCHRUL
.equ CLEDCHRY=~LEDCHRY
.equ CLEDCHRMINUS=~LEDCHRMINUS
.equ CLEDCHRSPACE=~LEDCHRSPACE
.equ CLEDCHRNONE=~LEDCHRNONE

; Example:
; ldi R20,LEDCHR2	; Load LED character '2' bitmap to register R20
; out PORTB,R20		; Store to port B register
.LIST