#ifdef UNDERSCORES
#define KS _KS
#define SALL _SALL
#define SCUR _SCUR
#define saltvalue _saltvalue
#define BigKS _BigKS
#define crypt_cout _crypt_cout
#endif

#ifdef ALIGN_LOG2
#define DO_ALIGN(log2) .align (log2)
#else
#define DO_ALIGN(log2) .align (1 << (log2))
#endif

.globl KS
.globl SALL
.globl SCUR
.globl saltvalue
.globl BigKS
.globl crypt_cout

/*
 * Alignments to make sure KS does not overlap (mod 8K) with SALL or SCUR,
 * important for DEC Alphas.
 */

.data
DO_ALIGN(7)
crypt_cout:
.space (2 * 8)
saltvalue:
.space 8
DO_ALIGN(7)
SALL:
.space (8 * 64 * 8)
KS:
.space (16 * 8)
SCUR:
.space (8 * 64 * 8)
.comm BigKS, (8 * 128 * 16 * 8)
