#include <stdio.h>
#include "fcrypt.h"

#ifdef BENCHMARK
#include <string.h>
#include <sys/time.h>
#include <signal.h>
#ifndef CRYPT_128K
#define number "1"
#else
#define number "2"
#endif

long count = 0;

void handler() {
  fprintf(stderr, count ? " %lu\n" : " FAILED\n", count);
  printf("-DCOUNT"number"=%lu", count);

  exit(0);
}

#endif

int main() {

#ifndef BENCHMARK
  sbpb24 i = 0x01020203;
  char *c = (char *)&i;

  if (sizeof(i) > 4) {
    printf("-DCRYPT_64BIT ");
    i = 0x0102020202020203;
  }

  switch (*c) {
  case 1:
    break;
  case 3:
    printf("-DCRYPT_LENDIAN"); break;
  default:
    fprintf(stderr, "Error: Unknown machine endianness\n"); return 1;
  }

#ifdef COMPARE
#if COUNT1 >= COUNT2
  rename("fcrypt1.o", "fcrypt.o"); unlink("fcrypt2.o");
#else
  printf(" -DCRYPT_128K");
#ifdef ASM_SPARC
  printf(" -DCRYPT_MIXED");
#endif
  rename("fcrypt2.o", "fcrypt.o"); unlink("fcrypt1.o");
#endif
#endif

  return 0;

#else
  struct itimerval itv;

  fprintf(stderr, "Running benchmark #"number"...");

  init_des();
  crypt_setsalt(crypt_getsalt("CC")); crypt_setkey("U*U*U*U*");
  crypt_binary("CCNf8Sbh3HDfQ", -1); XForm2();

  if (memcmp(crypt_cout, crypt_cbin, crypt_binsize)) handler(); else {
    signal (SIGVTALRM, handler);
    memset(&itv, 0, sizeof(itv));
    itv.it_value.tv_sec = 10;
    setitimer (ITIMER_VIRTUAL, &itv, NULL);

    for (count = 0; ; count++) XForm2();
  }

#endif
}
