/*
 * Fast MD5 based crypt() implementation. Copyright (c) 1997 by Solar Designer.
 *
 * Note: only passwords up to 15 characters long supported. Be sure to define
 * CRYPT_LENDIAN when compiling for little endian machines (x86, Alpha) for a
 * significant performance increase.
 *
 * Based on the RSA Data Security, Inc. MD5 Message-Digest Algorithm and the
 * MD5 based crypt() often used in FreeBSD, by Poul-Henning Kamp, his original
 * copyright notice follows:
 *
 * ----------------------------------------------------------------------------
 * "THE BEER-WARE LICENSE" (Revision 42):
 * <phk@login.dknet.dk> wrote this file.  As long as you retain this notice you
 * can do whatever you want with this stuff. If we meet some day, and you think
 * this stuff is worth it, you can buy me a beer in return.   Poul-Henning Kamp
 * ----------------------------------------------------------------------------
 */

#include <stdio.h>
#include <string.h>

/*
 * UINT4 defines a four byte word. Setting it this way seems fine for 32 and
 * 64 bit systems, however you'll have to use "unsigned long" for 16 bit ones,
 * or when using a 16 bit compiler (who would do that anyway?).
 */
typedef unsigned int UINT4;

#define S11 7
#define S12 12
#define S13 17
#define S14 22
#define S21 5
#define S22 9
#define S23 14
#define S24 20
#define S31 4
#define S32 11
#define S33 16
#define S34 23
#define S41 6
#define S42 10
#define S43 15
#define S44 21

#define Ca 0x67452301
#define Cb 0xefcdab89
#define Cc 0x98badcfe
#define Cd 0x10325476

unsigned char PADDING[56] = {
  0x80, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

/*
 * F, G, H and I are basic MD5 functions.
 */
#define F(x, y, z) (((x) & (y)) | (~(x) & (z)))
#define G(x, y, z) (((x) & (z)) | ((y) & ~(z)))
#define H(x, y, z) ((x) ^ (y) ^ (z))
#define I(x, y, z) ((y) ^ ((x) | ~(z)))

/*
 * ROTATE_LEFT rotates x left n bits.
 */
#define ROTATE_LEFT(x, n) (x) = (((x) << (n)) | ((x) >> (32 - (n))))

/*
 * FF, GG, HH, and II transformations for rounds 1, 2, 3, and 4.
 * Rotation is separate from addition to prevent recomputation.
 */

#define FF(a, b, c, d, x, s, ac) \
 (a) += F ((b), (c), (d)) + (x) + (UINT4)(ac); \
 ROTATE_LEFT ((a), (s)); \
 (a) += (b);

#define GG(a, b, c, d, x, s, ac) \
 (a) += G ((b), (c), (d)) + (x) + (UINT4)(ac); \
 ROTATE_LEFT ((a), (s)); \
 (a) += (b);

#define HH(a, b, c, d, x, s, ac) \
 (a) += H ((b), (c), (d)) + (x) + (UINT4)(ac); \
 ROTATE_LEFT ((a), (s)); \
 (a) += (b);
 
#define II(a, b, c, d, x, s, ac) \
 (a) += I ((b), (c), (d)) + (x) + (UINT4)(ac); \
 ROTATE_LEFT ((a), (s)); \
 (a) += (b);

UINT4 state[4];

#if defined(CRYPT_LENDIAN) || defined(MD5_ASM)
#define final ((unsigned char *)&state)
#define DECODE(x) ((UINT4 *)(x))
#define ENCODE()
#else
unsigned char final[16];
inline UINT4 *DECODE(unsigned char *x) {
  static UINT4 y[15];
  register int i;

  for (i = 0; i < 14; i++) {
    y[i] = (UINT4)x[0] + ((UINT4)x[1] << 8) +
      ((UINT4)x[2] << 16) + ((UINT4)x[3] << 24);
    x += 4;
  }
  y[14] = *(UINT4 *)x;

  return y;
}
inline void ENCODE() {
  register int i, j;

  for (i = 0, j = 0; i < 4; i++, j += 4) {
    final[j] = state[i] & 0xFF;
    final[j + 1] = (state[i] >> 8) & 0xFF;
    final[j + 2] = (state[i] >> 16) & 0xFF;
    final[j + 3] = state[i] >> 24;
  }
}
#endif

/*
 * MD5 basic transformation. Transforms state based on x.
 */

#ifdef MD5_ASM

extern void MD5(UINT4 x[15]);

#else

inline void MD5(UINT4 x[15])
{
  register UINT4 a, b = Cb, c = Cc, d = Cd;

  /* Round 1 */
  a = 0xd76aa477 + x[0]; ROTATE_LEFT(a, S11); a += Cb; /* 1 */
  FF (d, a, Cb, Cc, x[1], S12, 0xe8c7b756); /* 2 */
  FF (c, d, a, Cb, x[2], S13, 0x242070db); /* 3 */
  FF (b, c, d, a, x[ 3], S14, 0xc1bdceee); /* 4 */
  FF (a, b, c, d, x[ 4], S11, 0xf57c0faf); /* 5 */
  FF (d, a, b, c, x[ 5], S12, 0x4787c62a); /* 6 */
  FF (c, d, a, b, x[ 6], S13, 0xa8304613); /* 7 */
  FF (b, c, d, a, x[ 7], S14, 0xfd469501); /* 8 */
  FF (a, b, c, d, x[ 8], S11, 0x698098d8); /* 9 */
  FF (d, a, b, c, x[ 9], S12, 0x8b44f7af); /* 10 */
  FF (c, d, a, b, x[10], S13, 0xffff5bb1); /* 11 */
  FF (b, c, d, a, x[11], S14, 0x895cd7be); /* 12 */
  FF (a, b, c, d, x[12], S11, 0x6b901122); /* 13 */
  FF (d, a, b, c, x[13], S12, 0xfd987193); /* 14 */
  FF (c, d, a, b, x[14], S13, 0xa679438e); /* 15 */
  FF (b, c, d, a, 0,     S14, 0x49b40821); /* 16 */

  /* Round 2 */
  GG (a, b, c, d, x[ 1], S21, 0xf61e2562); /* 17 */
  GG (d, a, b, c, x[ 6], S22, 0xc040b340); /* 18 */
  GG (c, d, a, b, x[11], S23, 0x265e5a51); /* 19 */
  GG (b, c, d, a, x[ 0], S24, 0xe9b6c7aa); /* 20 */
  GG (a, b, c, d, x[ 5], S21, 0xd62f105d); /* 21 */
  GG (d, a, b, c, x[10], S22,  0x2441453); /* 22 */
  GG (c, d, a, b, 0,     S23, 0xd8a1e681); /* 23 */
  GG (b, c, d, a, x[ 4], S24, 0xe7d3fbc8); /* 24 */
  GG (a, b, c, d, x[ 9], S21, 0x21e1cde6); /* 25 */
  GG (d, a, b, c, x[14], S22, 0xc33707d6); /* 26 */
  GG (c, d, a, b, x[ 3], S23, 0xf4d50d87); /* 27 */
  GG (b, c, d, a, x[ 8], S24, 0x455a14ed); /* 28 */
  GG (a, b, c, d, x[13], S21, 0xa9e3e905); /* 29 */
  GG (d, a, b, c, x[ 2], S22, 0xfcefa3f8); /* 30 */
  GG (c, d, a, b, x[ 7], S23, 0x676f02d9); /* 31 */
  GG (b, c, d, a, x[12], S24, 0x8d2a4c8a); /* 32 */

  /* Round 3 */
  HH (a, b, c, d, x[ 5], S31, 0xfffa3942); /* 33 */
  HH (d, a, b, c, x[ 8], S32, 0x8771f681); /* 34 */
  HH (c, d, a, b, x[11], S33, 0x6d9d6122); /* 35 */
  HH (b, c, d, a, x[14], S34, 0xfde5380c); /* 36 */
  HH (a, b, c, d, x[ 1], S31, 0xa4beea44); /* 37 */
  HH (d, a, b, c, x[ 4], S32, 0x4bdecfa9); /* 38 */
  HH (c, d, a, b, x[ 7], S33, 0xf6bb4b60); /* 39 */
  HH (b, c, d, a, x[10], S34, 0xbebfbc70); /* 40 */
  HH (a, b, c, d, x[13], S31, 0x289b7ec6); /* 41 */
  HH (d, a, b, c, x[ 0], S32, 0xeaa127fa); /* 42 */
  HH (c, d, a, b, x[ 3], S33, 0xd4ef3085); /* 43 */
  HH (b, c, d, a, x[ 6], S34,  0x4881d05); /* 44 */
  HH (a, b, c, d, x[ 9], S31, 0xd9d4d039); /* 45 */
  HH (d, a, b, c, x[12], S32, 0xe6db99e5); /* 46 */
  HH (c, d, a, b, 0,     S33, 0x1fa27cf8); /* 47 */
  HH (b, c, d, a, x[ 2], S34, 0xc4ac5665); /* 48 */

  /* Round 4 */
  II (a, b, c, d, x[ 0], S41, 0xf4292244); /* 49 */
  II (d, a, b, c, x[ 7], S42, 0x432aff97); /* 50 */
  II (c, d, a, b, x[14], S43, 0xab9423a7); /* 51 */
  II (b, c, d, a, x[ 5], S44, 0xfc93a039); /* 52 */
  II (a, b, c, d, x[12], S41, 0x655b59c3); /* 53 */
  II (d, a, b, c, x[ 3], S42, 0x8f0ccc92); /* 54 */
  II (c, d, a, b, x[10], S43, 0xffeff47d); /* 55 */
  II (b, c, d, a, x[ 1], S44, 0x85845dd1); /* 56 */
  II (a, b, c, d, x[ 8], S41, 0x6fa87e4f); /* 57 */
  II (d, a, b, c, 0,     S42, 0xfe2ce6e0); /* 58 */
  II (c, d, a, b, x[ 6], S43, 0xa3014314); /* 59 */
  II (b, c, d, a, x[13], S44, 0x4e0811a1); /* 60 */
  II (a, b, c, d, x[ 4], S41, 0xf7537e82); /* 61 */
  II (d, a, b, c, x[11], S42, 0xbd3af235); /* 62 */
  II (c, d, a, b, x[ 2], S43, 0x2ad7d2bb); /* 63 */
  II (b, c, d, a, x[ 9], S44, 0xeb86d391); /* 64 */

  state[0] = Ca + a;
  state[1] = Cb + b;
  state[2] = Cc + c;
  state[3] = Cd + d;

  ENCODE();
}

#endif

unsigned char *itoa64 =
  "./0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";

inline void to64(s, v, n)
  char *s;
  UINT4 v;
  int n;
{
  while (--n) {
    *s++ = itoa64[v & 0x3F];
    v >>= 6;
  }
}

struct pattern {
  unsigned char *even, *odd;
  int len;
};

unsigned char odd_p[16], odd_s[8], odd_ps[24], odd_pp[32], odd_psp[40];
unsigned char even_p[44], even_sp[44], even_pp[44], even_spp[44];
int len_p, len_s, len_ps, len_pp, len_psp;

struct pattern patterns[21] = {
  {even_p, odd_psp, 0},
  {even_spp, odd_pp, 0},
  {even_spp, odd_psp, 0},
  {even_pp, odd_ps, 0},
  {even_spp, odd_pp, 0},
  {even_spp, odd_psp, 0},
  {even_pp, odd_psp, 0},
  {even_sp, odd_pp, 0},
  {even_spp, odd_psp, 0},
  {even_pp, odd_psp, 0},
  {even_spp, odd_p, 0},
  {even_spp, odd_psp, 0},
  {even_pp, odd_psp, 0},
  {even_spp, odd_pp, 0},
  {even_sp, odd_psp, 0},
  {even_pp, odd_psp, 0},
  {even_spp, odd_pp, 0},
  {even_spp, odd_ps, 0},
  {even_pp, odd_psp, 0},
  {even_spp, odd_pp, 0},
  {even_spp, odd_psp, 0}
};

unsigned char *magic = "$1$";

char *md5crypt(pw, salt)
  char *pw;
  char *salt;
{
  static char out[40];
  char *sp, *ep, *p;
  unsigned char buffer[64];
  int sl, pl, i, k;
  struct pattern *j;
  UINT4 l;

  if (!strncmp(sp = salt, magic, 3)) sp += 3;
  ep = sp; while (*ep && *ep != '$' && ep < sp + 8) ep++;

  if ((len_p = strlen(pw)) > 15) len_p = 15;
  memcpy(odd_p, pw, len_p);

  memcpy(odd_s, sp, len_s = ep - sp);

  memcpy(odd_ps, odd_p, len_p); memcpy(&odd_ps[len_p], odd_s, len_s);
  len_ps = len_p + len_s;

  memcpy(odd_pp, odd_p, len_p); memcpy(&odd_pp[len_p], odd_p, len_p);
  len_pp = len_p << 1;

  memcpy(odd_psp, odd_ps, len_ps); memcpy(&odd_psp[len_ps], odd_p, len_p);
  len_psp = len_ps + len_p;

  memcpy(even_p, odd_p, len_p);
  memcpy(&even_p[len_p], PADDING, 40 - len_p);
  *(UINT4 *)&even_p[40] = (len_p + 16) << 3;

  memcpy(even_sp, odd_s, len_s); memcpy(&even_sp[len_s], odd_p, len_p);
  memcpy(&even_sp[len_ps], PADDING, 40 - len_ps);
  *(UINT4 *)&even_sp[40] = (len_ps + 16) << 3;

  memcpy(even_pp, odd_pp, len_pp);
  memcpy(&even_pp[len_pp], PADDING, 40 - len_pp);
  *(UINT4 *)&even_pp[40] = (len_pp + 16) << 3;

  memcpy(even_spp, odd_s, len_s); memcpy(&even_spp[len_s], odd_pp, len_pp);
  memcpy(&even_spp[len_psp], PADDING, 40 - len_psp);
  *(UINT4 *)&even_spp[40] = (len_psp + 16) << 3;

  patterns[0].len = len_psp;
  patterns[1].len = len_pp;
  patterns[2].len = len_psp;
  patterns[3].len = len_ps;
  patterns[4].len = len_pp;
  patterns[5].len = len_psp;
  patterns[6].len = len_psp;
  patterns[7].len = len_pp;
  patterns[8].len = len_psp;
  patterns[9].len = len_psp;
  patterns[10].len = len_p;
  patterns[11].len = len_psp;
  patterns[12].len = len_psp;
  patterns[13].len = len_pp;
  patterns[14].len = len_psp;
  patterns[15].len = len_psp;
  patterns[16].len = len_pp;
  patterns[17].len = len_ps;
  patterns[18].len = len_psp;
  patterns[19].len = len_pp;
  patterns[20].len = len_psp;

  memcpy(buffer, odd_psp, len_psp);
  memcpy(&buffer[len_psp], PADDING, 56 - len_psp);
  *(UINT4 *)&buffer[56] = len_psp << 3;
  MD5(DECODE(buffer));

  memcpy(buffer, odd_p, len_p);
  memcpy(&buffer[len_p], magic, 3);
  memcpy(&buffer[len_p + 3], odd_s, len_s);
  memcpy(&buffer[len_ps + 3], final, len_p);
  for (i = len_p, k = len_psp + 3; i; i >>= 1)
    buffer[k++] = (i & 1) ? 0 : odd_p[0];
  memcpy(&buffer[k], PADDING, 56 - k);
  *(UINT4 *)&buffer[56] = k << 3;
  MD5(DECODE(buffer));

  for (i = 0; i < 1000 / 42; i++)
  for (j = patterns; j < patterns + 21; j++) {
    memcpy(buffer, final, 16);
    memcpy(&buffer[16], j->even, 44);
    MD5(DECODE(buffer));
    memcpy(buffer, j->odd, (k = j->len));
    memcpy(&buffer[k], final, 16);
    k += 16;
    memcpy(&buffer[k], PADDING, 56 - k);
    *(UINT4 *)&buffer[56] = k << 3;
    MD5(DECODE(buffer));
  }

  for (j = patterns; j < patterns + 1000 % 42 / 2; j++) {
    memcpy(buffer, final, 16);
    memcpy(&buffer[16], j->even, 44);
    MD5(DECODE(buffer));
    memcpy(buffer, j->odd, (k = j->len));
    memcpy(&buffer[k], final, 16);
    k += 16;
    memcpy(&buffer[k], PADDING, 56 - k);
    *(UINT4 *)&buffer[56] = k << 3;
    MD5(DECODE(buffer));
  }

  strcpy(out, magic); strncat(out, odd_s, len_s); strcat(out, "$");
  p = &out[4] + len_s;

  l = (final[ 0] << 16) | (final[ 6] << 8) | final[12]; to64(p, l, 5); p += 4;
  l = (final[ 1] << 16) | (final[ 7] << 8) | final[13]; to64(p, l, 5); p += 4;
  l = (final[ 2] << 16) | (final[ 8] << 8) | final[14]; to64(p, l, 5); p += 4;
  l = (final[ 3] << 16) | (final[ 9] << 8) | final[15]; to64(p, l, 5); p += 4;
  l = (final[ 4] << 16) | (final[10] << 8) | final[ 5]; to64(p, l, 5); p += 4;
  l =                      final[11]                  ; to64(p, l, 3);
  *(p + 2) = 0;

  return out;
}
