#ifdef UNDERSCORES
#define KS _KS
#define SWALL _SWALL
#define SWCUR _SWCUR
#define SALL _SALL
#define SCUR _SCUR
#define saltvalue _saltvalue
#define BigKS _BigKS
#define crypt_cout _crypt_cout
#define XForm1 _XForm1
#define XForm2 _XForm2
#define xorkey1 _xorkey1
#define xorkey2 _xorkey2
#endif

#ifdef ALIGN_LOG2
#define DO_ALIGN(log2) .align (log2)
#else
#define DO_ALIGN(log2) .align (1 << (log2))
#endif

.globl KS
#ifdef CRYPT_128K
.globl SWALL
.globl SWCUR
#else
.globl SALL
.globl SCUR
#endif
.globl saltvalue
.globl BigKS
.globl crypt_cout

.globl XForm1
.globl XForm2
.globl xorkey1
.globl xorkey2

#define BANKSHIFT 1

.text

#ifdef CRYPT_128K
#define mask 0x3CF03CF0
#else
#define mask 0x78787878
#endif

#define Ll %o0
#define Lh %o1
#define Rl %o2
#define Rh %o3
#define Dl %o4
#define Dh %o5
#ifdef CRYPT_128K
#define S0 %l0
#define S1 %l1
#define S2 %l2
#define S3 %l3
#define kp %l4
#define loopcount %l5
#define salt %l6
#define FFFF %l7
#else
#define S0L %l0
#define S0H %l1
#define S1L %l2
#define S1H %l3
#define S2L %l4
#define S2H %l5
#define S3L %l6
#define S3H %l7
#define S4L %i0
#define S4H %i1
#define S5L %i2
#define S5H %i3
#define S6L %i4
#define S6H %i5
#define S7L %o7
#define S7H %i7
#define kp %g5
#define loopcount %g6
#define salt %g7
#define si7 [%fp-24]
#endif

#ifdef CRYPT_128K

#define lxform1(MYKS) \
 xor Rl,Rh,%g2 ; \
 xor Dl,Rl,Dl ; \
 and %g2,salt,%g2 ; \
 xor Dh,Rh,Dh ; \
 xor Dl,%g2,Dl ; \
 xor Dh,%g2,Dh ; \
 and Dl,FFFF,%g1 ; \
 srl Dl,16,%g4 ; \
 ldd [S0+%g1],%g2 ; \
 ldd [S1+%g4],%g4 ; \
 xor Ll,%g2,Ll ; \
 xor Lh,%g3,Lh ; \
 xor Ll,%g4,Ll ; \
 and Dh,FFFF,%g1 ; \
 xor Lh,%g5,Lh ; \
 srl Dh,16,%g4 ; \
 ldd [S2+%g1],%g2 ; \
 ldd [S3+%g4],%g4 ; \
 xor Ll,%g2,Ll ; \
 xor Lh,%g3,Lh ; \
 xor Ll,%g4,Ll ; \
 xor Lh,%g5,Lh ; \
 ldd [MYKS+8],Dl ; \
 xor Ll,Lh,%g2 ; \
 xor Dl,Ll,Dl ; \
 and %g2,salt,%g2 ; \
 xor Dh,Lh,Dh ; \
 xor Dl,%g2,Dl ; \
 xor Dh,%g2,Dh ; \
 and Dl,FFFF,%g1 ; \
 srl Dl,16,%g4 ; \
 ldd [S0+%g1],%g2 ; \
 ldd [S1+%g4],%g4 ; \
 xor Rl,%g2,Rl ; \
 xor Rh,%g3,Rh ; \
 xor Rl,%g4,Rl ; \
 and Dh,FFFF,%g1 ; \
 xor Rh,%g5,Rh ; \
 srl Dh,16,%g2 ; \
 ldd [S2+%g1],%g4 ; \
 ldd [S3+%g2],%g2 ; \
 xor Rl,%g4,Rl ; \
 xor Rh,%g5,Rh

#else

#define lxform1(MYKS) \
 xor Rl,Rh,%g2 ; \
 xor Dl,Rl,Dl ; \
 and %g2,salt,%g2 ; \
 xor Dh,Rh,Dh ; \
 xor Dl,%g2,Dl ; \
 xor Dh,%g2,Dh ; \
 and Dl,0xFF,%g1 ; \
 srl Dl,8,%g4 ; \
 ld [S0L+%g1],%g2 ; \
 ld [S0H+%g1],%g3 ; \
 and %g4,0xFF,Dl ; \
 xor Ll,%g2,Ll ; \
 xor Lh,%g3,Lh ; \
 srl %g4,8,%g4 ; \
 ld [S1L+Dl],%g2 ; \
 ld [S1H+Dl],%g3 ; \
 and %g4,0xFF,%g1 ; \
 xor Ll,%g2,Ll ; \
 xor Lh,%g3,Lh ; \
 ld [S2L+%g1],%g2 ; \
 ld [S2H+%g1],%g3 ; \
 srl %g4,8,%g4 ; \
 xor Ll,%g2,Ll ; \
 xor Lh,%g3,Lh ; \
 ld [S3L+%g4],%g2 ; \
 ld [S3H+%g4],%g3 ; \
 xor Ll,%g2,Ll ; \
 xor Lh,%g3,Lh ; \
 and Dh,0xFF,%g1 ; \
 srl Dh,8,%g4 ; \
 ld [S4L+%g1],%g2 ; \
 ld [S4H+%g1],%g3 ; \
 and %g4,0xFF,Dh ; \
 xor Ll,%g2,Ll ; \
 xor Lh,%g3,Lh ; \
 srl %g4,8,%g4 ; \
 ld [S5L+Dh],%g2 ; \
 ld [S5H+Dh],%g3 ; \
 and %g4,0xFF,%g1 ; \
 xor Ll,%g2,Ll ; \
 xor Lh,%g3,Lh ; \
 ld [S6L+%g1],%g2 ; \
 ld [S6H+%g1],%g3 ; \
 srl %g4,8,%g4 ; \
 xor Ll,%g2,Ll ; \
 xor Lh,%g3,Lh ; \
 ld [S7L+%g4],%g2 ; \
 ld [S7H+%g4],%g3 ; \
 xor Ll,%g2,Ll ; \
 xor Lh,%g3,Lh ; \
 ldd [MYKS+8],Dl ; \
 xor Ll,Lh,%g2 ; \
 xor Dl,Ll,Dl ; \
 and %g2,salt,%g2 ; \
 xor Dh,Lh,Dh ; \
 xor Dl,%g2,Dl ; \
 xor Dh,%g2,Dh ; \
 and Dl,0xFF,%g1 ; \
 srl Dl,8,%g4 ; \
 ld [S0L+%g1],%g2 ; \
 ld [S0H+%g1],%g3 ; \
 and %g4,0xFF,Dl ; \
 xor Rl,%g2,Rl ; \
 xor Rh,%g3,Rh ; \
 srl %g4,8,%g4 ; \
 ld [S1L+Dl],%g2 ; \
 ld [S1H+Dl],%g3 ; \
 and %g4,0xFF,%g1 ; \
 xor Rl,%g2,Rl ; \
 xor Rh,%g3,Rh ; \
 ld [S2L+%g1],%g2 ; \
 ld [S2H+%g1],%g3 ; \
 srl %g4,8,%g4 ; \
 xor Rl,%g2,Rl ; \
 xor Rh,%g3,Rh ; \
 ld [S3L+%g4],%g2 ; \
 ld [S3H+%g4],%g3 ; \
 xor Rl,%g2,Rl ; \
 xor Rh,%g3,Rh ; \
 and Dh,0xFF,%g1 ; \
 srl Dh,8,%g4 ; \
 ld [S4L+%g1],%g2 ; \
 ld [S4H+%g1],%g3 ; \
 and %g4,0xFF,Dh ; \
 xor Rl,%g2,Rl ; \
 xor Rh,%g3,Rh ; \
 srl %g4,8,%g4 ; \
 ld [S5L+Dh],%g2 ; \
 ld [S5H+Dh],%g3 ; \
 and %g4,0xFF,%g1 ; \
 xor Rl,%g2,Rl ; \
 xor Rh,%g3,Rh ; \
 ld [S6L+%g1],%g2 ; \
 ld [S6H+%g1],%g3 ; \
 srl %g4,8,%g4 ; \
 xor Rl,%g2,Rl ; \
 xor Rh,%g3,Rh ; \
 ld [S7L+%g4],%g2 ; \
 ld [S7H+%g4],%g3

#endif

#define lxform2(MYKS) \
 ldd [MYKS+16],Dl ; \
 xor Rl,%g2,Rl ; \
 xor Rh,%g3,Rh

#define lxform3(MYKS) \
 lxform1(MYKS) ; \
 lxform2(MYKS)

DO_ALIGN(4)
XForm1:
#ifdef CRYPT_128K
 save %sp,-112,%sp
 sethi %hi(SWALL),S0
 sethi %hi(SWALL+0x8000),S1
 sethi %hi(SWALL+0x10000),S2
 sethi %hi(SWALL+0x18000),S3
 set 0xFFFF,FFFF
#else
 save %sp,-120,%sp
 st %i7,si7
 sethi %hi(SALL),S0L
 sethi %hi(SALL+4*64*4),S4L
 add S0L,4*(64*8+BANKSHIFT),S0H
 add S0L,4*64*1,S1L
 add S0L,4*64*2,S2L
 add S0L,4*64*3,S3L
 add S0L,4*64*5,S5L
 add S0L,4*64*6,S6L
 add S0L,4*64*7,S7L
 add S0H,4*64*1,S1H
 add S0H,4*64*2,S2H
 add S0H,4*64*3,S3H
 add S0H,4*64*4,S4H
 add S0H,4*64*5,S5H
 add S0H,4*64*6,S6H
 add S0H,4*64*7,S7H
#endif
 sethi %hi(saltvalue),%g1
 sethi %hi(KS),kp
 ld [%g1+%lo(saltvalue)],salt
 clr Ll
 clr Lh
 ldd [kp],Dl
 clr Rl
 clr Rh
 mov 25,loopcount
loopstart1:
 lxform3(kp)
 lxform3(kp+16)
 lxform3(kp+32)
 lxform3(kp+48)
 lxform3(kp+64)
 lxform3(kp+80)
 lxform3(kp+96)
 lxform1(kp+112)
 xor Rl,%g2,Rl
 xor Rh,%g3,Rh
 deccc loopcount
 xor Ll,Rl,Ll
 xor Lh,Rh,Lh
 xor Rl,Ll,Rl
 xor Rh,Lh,Rh
 xor Ll,Rl,Ll
 xor Lh,Rh,Lh
 bnz,a loopstart1
 ldd [kp],Dl
 set mask,%g1
 sethi %hi(crypt_cout),%g2
 and Ll,%g1,Ll
 and Lh,%g1,Lh
 and Rl,%g1,Rl
 and Rh,%g1,Rh
#ifndef CRYPT_128K
 ld si7,%i7
#endif
 std Ll,[%g2]
 std Rl,[%g2+8]
 ret
 restore

#ifdef CRYPT_128K

#define lxform1c(MYKS) \
 xor Dl,Rl,Dl ; \
 xor Dh,Rh,Dh ; \
 and Dl,FFFF,%g1 ; \
 srl Dl,16,%g4 ; \
 ldd [S0+%g1],%g2 ; \
 ldd [S1+%g4],%g4 ; \
 xor Ll,%g2,Ll ; \
 xor Lh,%g3,Lh ; \
 xor Ll,%g4,Ll ; \
 and Dh,FFFF,%g1 ; \
 xor Lh,%g5,Lh ; \
 srl Dh,16,%g4 ; \
 ldd [S2+%g1],%g2 ; \
 ldd [S3+%g4],%g4 ; \
 xor Ll,%g2,Ll ; \
 xor Lh,%g3,Lh ; \
 ldd [MYKS+8],Dl ; \
 xor Ll,%g4,Ll ; \
 xor Lh,%g5,Lh ; \
 xor Dl,Ll,Dl ; \
 xor Dh,Lh,Dh ; \
 and Dl,FFFF,%g1 ; \
 srl Dl,16,%g4 ; \
 ldd [S0+%g1],%g2 ; \
 ldd [S1+%g4],%g4 ; \
 xor Rl,%g2,Rl ; \
 xor Rh,%g3,Rh ; \
 xor Rl,%g4,Rl ; \
 and Dh,FFFF,%g1 ; \
 xor Rh,%g5,Rh ; \
 srl Dh,16,%g2 ; \
 ldd [S2+%g1],%g4 ; \
 ldd [S3+%g2],%g2 ; \
 xor Rl,%g4,Rl ; \
 xor Rh,%g5,Rh

#else

#undef S7H
#define S7H %g7

#define lxform1c(MYKS) \
 xor Dl,Rl,Dl ; \
 xor Dh,Rh,Dh ; \
 and Dl,0xFF,%g1 ; \
 srl Dl,8,%g4 ; \
 ld [S0L+%g1],%g2 ; \
 ld [S0H+%g1],%g3 ; \
 and %g4,0xFF,Dl ; \
 xor Ll,%g2,Ll ; \
 xor Lh,%g3,Lh ; \
 srl %g4,8,%g4 ; \
 ld [S1L+Dl],%g2 ; \
 ld [S1H+Dl],%g3 ; \
 and %g4,0xFF,%g1 ; \
 xor Ll,%g2,Ll ; \
 xor Lh,%g3,Lh ; \
 ld [S2L+%g1],%g2 ; \
 ld [S2H+%g1],%g3 ; \
 srl %g4,8,%g4 ; \
 xor Ll,%g2,Ll ; \
 xor Lh,%g3,Lh ; \
 ld [S3L+%g4],%g2 ; \
 ld [S3H+%g4],%g3 ; \
 xor Ll,%g2,Ll ; \
 xor Lh,%g3,Lh ; \
 and Dh,0xFF,%g1 ; \
 srl Dh,8,%g4 ; \
 ld [S4L+%g1],%g2 ; \
 ld [S4H+%g1],%g3 ; \
 and %g4,0xFF,Dh ; \
 xor Ll,%g2,Ll ; \
 xor Lh,%g3,Lh ; \
 srl %g4,8,%g4 ; \
 ld [S5L+Dh],%g2 ; \
 ld [S5H+Dh],%g3 ; \
 and %g4,0xFF,%g1 ; \
 xor Ll,%g2,Ll ; \
 xor Lh,%g3,Lh ; \
 ld [S6L+%g1],%g2 ; \
 ld [S6H+%g1],%g3 ; \
 srl %g4,8,%g4 ; \
 xor Ll,%g2,Ll ; \
 xor Lh,%g3,Lh ; \
 ld [S7L+%g4],%g2 ; \
 ld [S7H+%g4],%g3 ; \
 ldd [MYKS+8],Dl ; \
 xor Ll,%g2,Ll ; \
 xor Lh,%g3,Lh ; \
 xor Dl,Ll,Dl ; \
 xor Dh,Lh,Dh ; \
 and Dl,0xFF,%g1 ; \
 srl Dl,8,%g4 ; \
 ld [S0L+%g1],%g2 ; \
 ld [S0H+%g1],%g3 ; \
 and %g4,0xFF,Dl ; \
 xor Rl,%g2,Rl ; \
 xor Rh,%g3,Rh ; \
 srl %g4,8,%g4 ; \
 ld [S1L+Dl],%g2 ; \
 ld [S1H+Dl],%g3 ; \
 and %g4,0xFF,%g1 ; \
 xor Rl,%g2,Rl ; \
 xor Rh,%g3,Rh ; \
 ld [S2L+%g1],%g2 ; \
 ld [S2H+%g1],%g3 ; \
 srl %g4,8,%g4 ; \
 xor Rl,%g2,Rl ; \
 xor Rh,%g3,Rh ; \
 ld [S3L+%g4],%g2 ; \
 ld [S3H+%g4],%g3 ; \
 xor Rl,%g2,Rl ; \
 xor Rh,%g3,Rh ; \
 and Dh,0xFF,%g1 ; \
 srl Dh,8,%g4 ; \
 ld [S4L+%g1],%g2 ; \
 ld [S4H+%g1],%g3 ; \
 and %g4,0xFF,Dh ; \
 xor Rl,%g2,Rl ; \
 xor Rh,%g3,Rh ; \
 srl %g4,8,%g4 ; \
 ld [S5L+Dh],%g2 ; \
 ld [S5H+Dh],%g3 ; \
 and %g4,0xFF,%g1 ; \
 xor Rl,%g2,Rl ; \
 xor Rh,%g3,Rh ; \
 ld [S6L+%g1],%g2 ; \
 ld [S6H+%g1],%g3 ; \
 srl %g4,8,%g4 ; \
 xor Rl,%g2,Rl ; \
 xor Rh,%g3,Rh ; \
 ld [S7L+%g4],%g2 ; \
 ld [S7H+%g4],%g3

#endif

#define lxform3c(MYKS) \
 lxform1c(MYKS)	; \
 lxform2(MYKS)

DO_ALIGN(4)
XForm2:
 save %sp,-112,%sp
#ifdef CRYPT_128K
 sethi %hi(SWCUR),S0
 sethi %hi(SWCUR+0x8000),S1
 sethi %hi(SWCUR+0x10000),S2
 sethi %hi(SWCUR+0x18000),S3
 set 0xFFFF,FFFF
#else
 sethi %hi(SCUR),S0L
 sethi %hi(SCUR+4*64*4),S4L
 add S0L,4*(64*8+BANKSHIFT),S0H
 add S0L,4*64*1,S1L
 add S0L,4*64*2,S2L
 add S0L,4*64*3,S3L
 add S0L,4*64*5,S5L
 add S0L,4*64*6,S6L
 add S0L,4*64*7,S7L
 add S0H,4*64*1,S1H
 add S0H,4*64*2,S2H
 add S0H,4*64*3,S3H
 add S0H,4*64*4,S4H
 add S0H,4*64*5,S5H
 add S0H,4*64*6,S6H
 add S0H,4*64*7,S7H
#endif
 sethi %hi(KS),kp
 clr Ll
 clr Lh
 ldd [kp],Dl
 clr Rl
 clr Rh
 mov 25,loopcount
loopstart2:
 lxform3c(kp)
 lxform3c(kp+16)
 lxform3c(kp+32)
 lxform3c(kp+48)
 lxform3c(kp+64)
 lxform3c(kp+80)
 lxform3c(kp+96)
 lxform1c(kp+112)
 xor Rl,%g2,Rl
 xor Rh,%g3,Rh
 deccc loopcount
 xor Ll,Rl,Ll
 xor Lh,Rh,Lh
 xor Rl,Ll,Rl
 xor Rh,Lh,Rh
 xor Ll,Rl,Ll
 xor Lh,Rh,Lh
 bnz,a loopstart2
 ldd [kp],Dl
 set mask,%g1
 sethi %hi(crypt_cout),%g2
 and Ll,%g1,Ll
 and Lh,%g1,Lh
 and Rl,%g1,Rl
 and Rh,%g1,Rh
 std Ll,[%g2]
 std Rl,[%g2+8]
 ret
 restore

#define xorit1(ofs, cmd) \
 ldd [%o0+ofs],%g2 ; \
 ldd [%o0+ofs+8],%g6 ; \
 ldd [%g1+ofs],%g4 ; \
 ldd [%g1+ofs+8],%o2 ; \
 xor %g2,%g4,%g2 ; \
 xor %g3,%g5,%g3 ; \
 std %g2,[%g1+ofs] ; \
 xor %g6,%o2,%g4 ; \
 xor %g7,%o3,%g5 ; \
 cmd ; \
 std %g4,[%g1+ofs+8]

DO_ALIGN(4)
xorkey1:
 sethi %hi(KS),%g1
 xorit1(0,)
 xorit1(16,)
 xorit1(32,)
 xorit1(48,)
 xorit1(64,)
 xorit1(80,)
 xorit1(96,)
 xorit1(112, retl)

#define xorit2(ofs, cmd) \
 ldd [%o0+ofs],%g2 ; \
 ldd [%o0+ofs+8],%o2 ; \
 ldd [%o1+ofs],%g4 ; \
 ldd [%o1+ofs+8],%o4 ; \
 ldd [%g1+ofs],%g6 ; \
 xor %g2,%g4,%g2 ; \
 xor %g3,%g5,%g3 ; \
 xor %g2,%g6,%g2 ; \
 xor %g3,%g7,%g3 ; \
 ldd [%g1+ofs+8],%g4 ; \
 xor %o2,%o4,%o2 ; \
 xor %o3,%o5,%o3 ; \
 std %g2,[%g1+ofs] ; \
 xor %o2,%g4,%g6 ; \
 xor %o3,%g5,%g7 ; \
 cmd ; \
 std %g6,[%g1+ofs+8]

DO_ALIGN(4)
xorkey2:
 sethi %hi(KS),%g1
 xorit2(0,)
 xorit2(16,)
 xorit2(32,)
 xorit2(48,)
 xorit2(64,)
 xorit2(80,)
 xorit2(96,)
 xorit2(112, retl)

.bss

.common	KS, (32 * 4), 1024
#ifdef CRYPT_128K
.common	SWALL, (4096 * 8 * 4), 1024
.common	SWCUR, (4096 * 8 * 4), 1024
#else
.common SALL, ((2 * 8 * 64 + BANKSHIFT) * 4), 1024
.common SCUR, ((2 * 8 * 64 + BANKSHIFT) * 4), 1024
#endif
.common	saltvalue, 4, 8
.common BigKS, (8 * 128 * 32 * 4), 128
.common crypt_cout, (4 * 4), 1024
