#include <stdio.h>
#include <string.h>

#define sep "\t\n!\"#$%&'()*+,-./:;<=>?@[\\]^_`{|}~"

int xtract(int argc, char **argv) {
  FILE *f;
  char issep[256], s[256];
  char *p, *start;
  int c;

  if (argc > 2 || argc > 1 && argv[1][0] == '-')
  {
    puts(
      "Usage: xtract [source] [> target]\n"
      "   or: command | xtract [> target]");
    return 0;
  }

  f = stdin;
  if (argc > 1 && !(f = fopen(argv[1], "r"))) {
    printf("Unable to open: %s\n", argv[1]); return 1;
  };

  for (c = 0; c < 256; c++) issep[c] = (c <= ' ') || (strchr(sep, c) != NULL);

  while (fgets(s, sizeof(s), f)) {
    while (p = strstr(s, "^A")) memcpy(p, "  ", 2);

    p = s;
    do {
      start = p;
      while (!issep[*p] && *p) p++; *p++ = 0;
      if (strlen(start) > 1 && strlen(start) < 32) puts(start);
      while (issep[*p] && *p) p++;
    } while (*p);
  }

  fclose(f);

  return 0;
}
