;From  Mike Bilow - ISBN validation
; > Anyone know how to validate the ISBN numbers from books?
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx

        page    60,132
        title   ISBN Check Digit Calculator
        subttl  Equates

        ;Standard equates

TRUE    equ    -1
FALSE   equ     0
psp_cnt equ     0080h   ;Offset of 1-byte length count for command tail
psp_com equ     0081h   ;Offset of start of command tail in psp
dos     equ     21h     ;DOS Functions (Int 21h)
d_disp  equ     09h     ;Stdout display string until '$'(at ds:dx)
d_term  equ     4Ch     ;Terminate with return code (in al)

        subttl  Main Procedure
        page
_TEXT   segment para public 'CODE'
        org     100h
        assume  cs:_TEXT, ds:_TEXT

Start:
        cld                     ;increment
        push    si

        ;--------------------------------------------------
        ;Compute weighted sum of first nine numerals

        mov     si,psp_com      ;si points to start of command tail
        mov     bx,si
        add     bl,ds:psp_cnt   ;bx points to end of command tail
        mov     ctend,bx

        mov     cx,9            ;number of numerals to read (9)

Read_loop:
        cmp     si,ctend
        jb      Read_cont       ;This stupidity due to 'jump out of range'

        jmp     Bad_command

Read_cont:
        lodsb                   ;from ds:[si] to al, inc si

        cmp     al,'0'
        jb      Read_loop
        cmp     al,'9'
        ja      Read_loop

        and     ax,0Fh
        inc     cx
        mul     cx              ;dx:ax = ax * cx
        dec     cx

        add     ax,total
        mov     total,ax

        loop    Read_loop

        page
        ;--------------------------------------------------
        ;Compute check digit

        xor     dx,dx
        mov     cx,11
        div     cx              ;ax = (dx:ax)/cx, then dx=remainder

        mov     check,dx

        mov     bx,dx
        mov     dl,rems[bx]     ;Get ASCII of check digit in dl
        mov     msg_dig,dl

        ;--------------------------------------------------
        ;See if user suggests a check digit

Check_loop:
        cmp     si,ctend
        ja      No_suggest

        lodsb                   ;from ds:[si] to al, inc si

        cmp     al,'x'
        jne     Not_lcx

        mov     al,'X'          ;If user enters 'x', make it 'X'

Not_lcx:
        cmp     al,'X'
        je      Check_got

        cmp     al,'0'
        jb      Check_loop
        cmp     al,'9'
        ja      Check_loop

Check_got:
        page
        ;--------------------------------------------------
        ;Display results

        cmp     al,dl
        jne     Wrong

        mov     dx,offset ds:msg_rit    ;Valid ISBN msg
        jmp     short Cont

Wrong:
        mov     dx,offset ds:msg_wrg    ;Invalid ISBN msg

Cont:
        mov     ah,d_disp
        int     dos

No_suggest:
        mov     dx,offset ds:msg_bot    ;Computed Check Digit msg
        mov     ah,d_disp
        int     dos

Exit:
        pop     si

        mov     ax,4C00h                ;Terminate with 00h return code
        int     dos

        ;--------------------------------------------------
        ;Help message if ISBN cannot be scanned

Bad_command:

        mov     dx,offset ds:msg_hlp
        mov     ah,d_disp
        int     dos

        jmp     Exit

versn   db      'v1.00'
ctend   dw      ?
total   dw      0
check   dw      ?
rems    db      '0X987654321'

msg_rit db      0Dh,0Ah,'Valid ISBN. $'
msg_wrg db      0Dh,0Ah,'***** Invalid ISBN! $'
msg_bot db      0Dh,0Ah,'Check Digit computed to be '
msg_dig db      '?.',0Dh,0Ah,'$'

msg_hlp db      'This program computes the Check Digit in an'
        db      0Dh,0Ah,'International Standard Book Number (ISBN). v1.0'

        db      0Dh,0Ah,0Ah,'Usage:',0Dh,0Ah
        db      'ISBN 1-55512-073     --computes check digit',0Dh,0Ah
        db      'ISBN 1-55512-073-3   --verifies check digit',0Dh,0Ah,0Ah
        db      'To check an ISSN, prefix with two leading zeroes:',0Dh,0Ah,0Ah
        db      'ISBN 00-0033-481     --computes check digit',0Dh,0Ah
        db      'ISBN 00-0033-4812    --verifies check digit',0Dh,0Ah,0Ah
        db      'All spaces and punctuation are ignored.'

        db      0Dh,0Ah,0Ah,'This program is in the public domain.'

msg_aut db      0Dh,0Ah,0Ah,'Program author:',0Dh,0Ah,09h,'Michael Bilow'
        db      0Dh,0Ah,09h,'Bilow Computer Science'
        db      0Dh,0Ah,09h,'Forty Plantations'
        db      0Dh,0Ah,09h,'Cranston, RI 02920'
        db      0Dh,0Ah,0Ah,09h,'Date: 07-March-1990'
        db      0Dh,0Ah,'$'

_TEXT   ends
        end     Start

        subttl  Programmer Notes
        page
;--------------------------------------------------------------- ;      
Revision Codes:
;
;       0.01    Initial working version
;       1.00    Messages added


