; Life simulator, 100 bytes  - Tenie Remmel

; If no args, AX = BX = 0 on startup.

Ideal
Model Tiny
P386
NoJumps
Smart
CodeSeg
Org 100h

Start:      mov al,13h              ;Set mode 13h
            int 10h
        
            mov ds,ax
            mov ax,[033ch]          ;Seed RNG with clock
        
            push 09000h             ;DS = last 64K segment
            pop ds
            push 0A000h             ;ES = video memory
            pop es
                                    ;BX is already zero
RandLoop:   add ax,ax               ;Generate random number
            setc [bx]
            jnc RandSkip
            xor al,45
RandSkip:   inc bx
            jnz RandLoop

MainLoop:   mov di,640              ;Set up for LifeLoop
            mov ch,250

LifeLoop:   mov eax,[di-1]          ;Get boundary count
            mov bl,ah               ;Store cell value
            add eax,[di-321]
            add eax,[di+319]
            add ah,al
            shr eax,8
            add al,ah
            and al,0fh

            cmp al,4                ;4 = stay
            jne $+5
            shl bl,4

            cmp al,3                ;3 = birth
            jne $+4
            mov bl,10h

            or [di],bl              ;Set new value
            inc di                  ;Loop back
            loop LifeLoop

            lea si,[di+640]         ;Set up for CleanLoop

CleanLoop:  shr [byte si],4         ;Shift value
            movsb                   ;Display pixel
            loop CleanLoop          ;Loop back
        
            mov ah,1                ;Check for key
            int 16h
            jz MainLoop             ;Loop if no key

            mov ax,3                ;Set text mode
            int 10h
            ret                     ;Return

End Start
