; Life simulator, 93 bytes  - Tenie Remmel

; If no args, AX = BX = 0 on startup.

Ideal
Model Tiny
P386
CodeSeg
Org 100h

Start:      mov al,13h              ;Set mode 13h
            int 10h
        
            mov ds,ax               ;Seed RNG with clock
            mov ax,[033Ch]

            push 09000h             ;DS = last 64K segment
            pop ds
            push 0A000h             ;ES = video memory
            pop es
                                    ;BX is already zero
RandLoop:   add ax,ax               ;Generate random number
            setc [bx]
            jnc RandSkip
            xor al,45
RandSkip:   inc bx
            jnz RandLoop
            dec bx                  ;BX = -1

MainLoop:   mov ch,252              ;Set up for LifeLoop
            mov si,321
            xor di,di

LifeLoop:   mov eax,[si+bx]         ;Get boundary count
            mov dl,ah               ;Store cell value
            add eax,[di]
            add eax,[si+319]
            add ah,al
            shr eax,8
            add al,ah
            and al,0fh

            cmp al,4                ;4 = stay
            jne $+5
            shl dl,4

            cmp al,3                ;3 = birth
            jne $+4
            mov dl,10h

            shr [byte di],4         ;Shift previous value
            movsb                   ;Set pixel
            or [si+bx],dl           ;Set new value
            loop LifeLoop           ;Loop back

            mov ah,1                ;Check for key
            int 16h
            jz MainLoop             ;Loop if no key

            mov ax,3                ;Set text mode
            int 10h
            ret                     ;Return

End Start
