Ideal

TIMEOUT     = 2184                 ;2 minutes

Model Tiny
P186
CodeSeg
Org 100h

Start:      jmp Main

Counter     dw TIMEOUT

Proc        NewInt08               ;Timer interrupt

            cmp [cs:Counter],0     ;Counter already zero?
            je I08_done            ;Jump if yes
            
            dec [cs:Counter]       ;Decrement counter
            jnz I08_done           ;if nonzero, do nothing

            push ax dx             ;Save AX, DX
            mov dx,03C4h           ;Sequencer port
            mov al,1               ;Send command to
            out dx,al              ;turn off screen
            inc dx
            in al,dx
            or al,020h
            out dx,al
            pop dx ax              ;Restore DX, AX

I08_done:   db 0EAh                ;JMP FAR opcode

OldInt08    dw 0,0                 ;Old interrupt address

EndP        NewInt08

Proc        NewInt09               ;Keyboard interrupt

            cmp [cs:Counter],0     ;If Counter is nonzero,
            jne I09_done           ;screen is not blanked

            push ax dx             ;Save AX, DX
            mov dx,03C4h           ;Sequencer port
            mov al,1               ;Send command to
            out dx,al              ;turn on screen
            inc dx
            in al,dx
            and al,0DFh
            out dx,al
            pop dx ax              ;Restore DX, AX

I09_done:   mov [cs:Counter],TIMEOUT   ;Reset counter

            db 0EAh                ;JMP FAR opcode

OldInt09    dw 0,0                 ;Old interrupt address

EndP        NewInt09

Proc        Main

            mov ah,49h             ;Free memory
            mov es,[2Ch]           ;ES = env. segment
            int 21h                ;DOS interrupt
            
            mov ax,3508h           ;Get interrupt vectors
            int 21h                ;and store them for the
            mov [OldInt08],bx      ;JMP instructions
            mov [OldInt08+2],es
            mov al,09h
            int 21h
            mov [OldInt09],bx
            mov [OldInt09+2],es

            mov ax,2508h           ;Set interrupt vectors
            mov dx,offset NewInt08
            int 21h
            mov al,09h
            mov dx,offset NewInt09
            int 21h
            
            mov dx,offset Main     ;DX = last byte to keep
            int 27h                ;DOS TSR service

EndP        Main

End Start
