;----------------------------------------------------------------------------
; File: NAMEEXE.ASM
;
; Purpose       : Displays full path name of current executable
; Author        : Tg (Tommaso Gastaldi)
; Processing    : tasm nameexe
;                 tlink nameexe /t
;;----------------------------------------------------------------------------

        .MODEL TINY
        .CODE
        ORG 100h

;----------------------------------------------------------------------------
; Under DOS 3+, at offset 2Ch in the PSP you can find the segment address of
; the environment block.
; At the end of the environment block there is a string with the
; executable name:
;
; Scheme of ENVIRONMENT BLOCK & following strings:
;  __________________________________________________________________
; | string1|00|string2|00|...|laststring3|00|00|00|02|progname|00|...
;  --------------------------------------------|-----|---------------
;                                              |     |
;                                              |number of strings
;                                              |that follow the
;                                              |environment block
;----------------------------------------------------------------------------

;----------------------------------------------------------------------------
; Here is a procedure to get the program name
;---------------------------------------------------------------------------

; Use service 62h of int 21h to get the segment of the PSP (returned in BX)
; and, then, the environment block segment  (this is *not* necessary in this
; specific program, but you will need it in a function for C):

start:

        mov AH,62h
        int 21h
        mov DS,BX

        mov AX,WORD PTR DS:[2Ch]        ; get segment of environment
        mov DS,AX
        xor SI,SI

search_end:

        cmp BYTE PTR [SI],0
        jz maybe_its_the_end
        inc SI
        jmp search_end

maybe_its_the_end:

        inc SI
        cmp BYTE PTR [SI],0
        jz end_found
        inc SI
        jmp search_end

end_found:

        add SI,3                ; skip the word with the # of strings
                                ; following the environment block

;----------------------------------------------------------------------------
; Now DS:SI is a pointer to the program name
;---------------------------------------------------------------------------

; Let's display program name

        mov AH,2

next_char:

        mov DL,[SI]
        cmp DL,0
        jz end_prg
        int 21h
        inc SI
        jmp next_char

end_prg:

        int 20h

        END start

