#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <conio.h>
#include <string.h>
#include <dos.h>


 /* //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// */

#define ScreenMem                       (byte *)0x000a0000UL

#ifndef BufWidth
#define BufWidth                        320
#endif
#ifndef BufHeight
#define BufHeight                       200
#endif


 /* //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// */

typedef unsigned char                   byte;
typedef unsigned long                   dword;


 /* //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// */

byte                LifeBuffer[2][BufHeight][BufWidth];


 /* //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// */

void                SetGraphMode(void)
{
    union REGPACK       Regs                = { 0 };


    Regs.w.ax = 0x0013;
    intr(0x10, &Regs);
}


 /* ---------------------------------------------------------------------------------------------------------------------------- */

void                SetTextMode(void)
{
    union REGPACK       Regs                = { 0 };


    Regs.w.ax = 0x0003;
    intr(0x10, &Regs);
}


 /* ---------------------------------------------------------------------------------------------------------------------------- */

void                SetPalette(void)
{
    int                 i;


    outp(0x3c8, 0x00);

    outp(0x3c9, 0x00);
    outp(0x3c9, 0x00);
    outp(0x3c9, 0x00);

    outp(0x3c9, 0x30);
    outp(0x3c9, 0x30);
    outp(0x3c9, 0x30);

    for (i = 2; i < 256; i++)
    {
        outp(0x3c9, 0x20);
        outp(0x3c9, 0x20);
        outp(0x3c9, 0x20);
    }
}


 /* ---------------------------------------------------------------------------------------------------------------------------- */

void                RandomiseScreen(void)
{
    byte               *Ptr                 = &LifeBuffer[1][0][0];
    int                 Count               = BufWidth * BufHeight;


    srand(*(dword *)0x0000046c);

    while (Count--)
        *Ptr++ = (rand() >> 14) & 1;
}


 /* ---------------------------------------------------------------------------------------------------------------------------- */

void                LifeASM(byte *Destination, byte *Source, dword Size);
#pragma aux LifeASM "*" parm caller [edi][esi][ecx] modify [eax ecx edx ebx esi edi];


 /* ---------------------------------------------------------------------------------------------------------------------------- */

void                DoLife(int FlipFlop)
{
    LifeASM(&LifeBuffer[FlipFlop][1][1], &LifeBuffer[!FlipFlop][1][1], BufWidth * (BufHeight - 2) - 2);
}


 /* ---------------------------------------------------------------------------------------------------------------------------- */

int                 main(void)
{
    SetGraphMode();
    SetPalette();
    RandomiseScreen();

    while (kbhit() == 0)
    {
#ifdef BProf
        while ((inp(0x3da) & 8) == 0) ;
        while ((inp(0x3da) & 8) != 0) ;
        outp(0x3c8, 0x00);
        outp(0x3c9, 0x00);
        outp(0x3c9, 0x00);
        outp(0x3c9, 0x3f);
#endif
        DoLife(0);
#ifdef BProf
        outp(0x3c8, 0x00);
        outp(0x3c9, 0x3f);
        outp(0x3c9, 0x00);
        outp(0x3c9, 0x00);
#endif
        memcpy(ScreenMem, &LifeBuffer[0][0][0], 320 * 200);
#ifdef BProf
        outp(0x3c8, 0x00);
        outp(0x3c9, 0x00);
        outp(0x3c9, 0x00);
        outp(0x3c9, 0x00);
        while ((inp(0x3da) & 8) == 0) ;
        while ((inp(0x3da) & 8) != 0) ;
        outp(0x3c8, 0x00);
        outp(0x3c9, 0x00);
        outp(0x3c9, 0x00);
        outp(0x3c9, 0x3f);
#endif
        DoLife(1);
#ifdef BProf
        outp(0x3c8, 0x00);
        outp(0x3c9, 0x3f);
        outp(0x3c9, 0x00);
        outp(0x3c9, 0x00);
#endif
        memcpy(ScreenMem, &LifeBuffer[1][0][0], 320 * 200);
#ifdef BProf
        outp(0x3c8, 0x00);
        outp(0x3c9, 0x00);
        outp(0x3c9, 0x00);
        outp(0x3c9, 0x00);
#endif
    }
    SetTextMode();

    while (kbhit() != 0)
        getch();

    return 0;
}

