;****************************************************************************
; Filename: FREE.ASM
;   Author: Peter Andersson
;  Version: 0.0
;  Created: 1994.12.25
;  Updated: -
;****************************************************************************
; Copyright Peter Andersson, 1994-1995.
; All rights reserved.
;****************************************************************************
; Function: VOID @free(PVOID blockptr);
;    Input: Eax, blockptr - pointer to the allocated block which is to be
;           returned to the heap.
;   Output: nothing
;  Comment: PALfree removes an added block from the global allocation heap.
;****************************************************************************

	Include	STDDEF.INC
	Include	"MEMORY.INC"

	Codeseg

Proc	free ,1
		TestZ	Eax							; Do not allow any NULL pointers
		Jz	@@Exit01
		Sub	Eax,Size AllocBlock
		Cmp	[Eax+AllocBlock.Ident],ALLOCID				; Check allocation identifier
		Jne	@@Exit01
		Push	Ebx
		Mov	Ebx,[Eax+AllocBlock.PrevBlock]				; Get previous block pointer
		Add	Eax,[Eax+AllocBlock.BlockSize]				; Get next block pointer
		Cmp	[Ebx+AllocBlock.Ident],ALLOCID				; Test if the block is allocated
		Je	@@Next01						; Yes, jump and check the next block
		Mov	Ecx,[Ebx+FreeBlock.PrevFree]				; Remove the FreeBlock from the free list
		Mov	Edx,[Ebx+FreeBlock.NextFree]
		Cmp	[Eax+AllocBlock.Ident],ALLOCID				; Test if the next block is allocated
		Mov	[Edx+FreeBlock.PrevFree],Ecx
		Mov	[Ecx+FreeBlock.NextFree],Edx
		Je	@@Next03						; Yes, jump and add the block to the free list
		Mov	Ecx,[Eax+FreeBlock.PrevFree]				; Remove the FreeBlock from the free list
		Mov	Edx,[Eax+FreeBlock.NextFree]
		Add	Eax,[Eax+FreeBlock.BlockSize]				; Get the next block (should be allocated)
		Mov	[Edx+FreeBlock.PrevFree],Ecx
		Mov	[Ecx+FreeBlock.NextFree],Edx
		Jmp	@@Next03
	Align	4
@@Next01:	Cmp	[Eax+AllocBlock.Ident],ALLOCID				; Test if the block is allocated
		Mov	Ebx,[Eax+AllocBlock.PrevBlock]				; Get the current AllocBlock
		Je	@@Next03						; Yes, jump and add the block to the free list
		Mov	Ecx,[Eax+FreeBlock.PrevFree]				; Remove the FreeBlock from the free list
		Mov	Edx,[Eax+FreeBlock.NextFree]
		Add	Eax,[Eax+FreeBlock.BlockSize]				; Go to the next block (should be allocate)
		Mov	[Edx+FreeBlock.PrevFree],Ecx
		Mov	[Ecx+FreeBlock.NextFree],Edx
@@Next03:	Mov	[Eax+AllocBlock.PrevBlock],Ebx				; Store pointer to previous block
		Sub	Eax,Ebx							; Get total number of free bytes
		Mov	[Ebx+FreeBlock.BlockSize],Eax				; Store it in the header
		GetSize	Edx,Eax
		Mov	Eax,[Edx+FreeBlock.NextFree]				; Add it to the free list
		Mov	[Edx+FreeBlock.NextFree],Ebx
		Mov	[Eax+FreeBlock.PrevFree],Ebx
		Mov	[Ebx+FreeBlock.NextFree],Eax
		Mov	[Ebx+FreeBlock.PrevFree],Edx
		Pop	Ebx
@@Exit01:	Ret
Endp

	End
