;****************************************************************************
; Filename: C0.ASM
;   Author: Adam Seychell and Peter Anderson
;  Version: 0.0
;  Created: ?
;  Updated: 1995.03.12 - Peter Andersson, general update for DOS32 v3.0
;  Comment: Startup file
;****************************************************************************
; Copyright Adam Seychell, 1994-1995.
; All rights reserved.
;****************************************************************************

	Include	STDDEF.INC

	Stack	16384

	Codeseg



Public AbortStackPos
Public NoLanguage ExitSlow,NoLanguage ExitQuick

PROC   startup NoLanguage
		Mov	[AbortStackPos],Esp	; Save the stack pointer

		Mov	Ax,0EE02h		; Fixup the standard variables
		Int	31h
		Neg	Ebx
		Mov	[_psp],Esi
		Mov	[_environ],Edi
		Mov	[_zero],Ebx
		Mov	[exesize],Edx
		Mov	[exename],Ecx

	Ifndef	NO_DMA
		Mov	Eax,0EE41h		; Allocate 16Kb DMA buffer
		Int	31h
		Jc	@@Exit01
		Mov	[DMA_addr],Edx		; Store near pointer
		Mov	[DMA_phys],Ebx		; Store physical address
	Endif

		Mov	Ax,0EE00h
		Int	31h
		And	Eax,0FFFFh
		Mov	[dos32version],Eax	; Save DOS32 version number
		Mov	[dos32system],Dl	; Save DOS32 system type
		Mov	[_zero_sel],Ebx

		Mov	Ax,0EE42h		; Allocate 4Gb block
		Mov	Edx,0FFFFFFFFh
		Int	31h			; EAX = size, EDX = ptr

		Xchg	Eax,Edx
		Call	@setmem
		TestZ	Eax
		Jz	@@Exit01


    ;
    ; Fixup the environment pointer table and it's varibles
    ;
		Mov	Eax,[_environ]	; Get the environment pointer
		Mov	Edi,Esp
	Align	4
@@Loop01:	Mov	[Esp],Eax       ; Save EAX
		Call	@strlen
		TestZ	Eax
		Jz	@@Next01
		Add	Eax,[Esp]
		Inc	Eax
		Push	Eax
		Jmp	@@Loop01
	Align	4
@@Next01:	Mov	Ecx,[Edi]	; Swap first and last to make the last
		Xchg	[Esp],Ecx	; one a zero length string
		Mov	[Edi],Ecx
		Mov	[environ],Esp	; Save environment pointer table pointer
		Sub	Edi,Esp
		Shr	Edi,2
		Mov	[_envsize],Edi	; Save environment size


 ;
 ; Fixup command line argument table on the stack
 ;
                Clear   Ecx
		Mov	Ebx,[_psp]
		Mov	Cl,[Ebx+80h]
                Lea     Esi,[Ebx+81h]     ; Esi -> first character in cmd tail
                Mov     Ebx,Ecx             ; save Ecx
                Sub     Esp,128             ; Allocate mem for cmd tail
                Mov     Edi,Esp
                Cld
                Rep     Movsb               ; copy cmd tail to buffer
                Mov     Ecx,Ebx             ; restore Ecx
                Lea     Edi,[Esp+Ecx-1]   ; Esi -> last character in cmd tail
                Std
                Mov     Al," "
                Mov     Ebx,1
CmdTailLoop:
                Repe    Scasb                   ; search for a non " " char
                TestZ   Ecx
                Jz      TailExit
                Inc     Ebx
                Inc     Edi
                Mov     [Byte Edi+1],0
                Inc     Ecx
                Repne   Scasb                   ; search for a " " char
                Inc     Edi
                Push    Edi                     ; push argv[] pointer on stack
                Inc     [Dword PTR Esp]
                TestZ   Ecx
                Jz      TailExit
                Inc     Ecx
                jmp     CmdTailLoop
TailExit:       Push    [exename]             ; Store EXE file namepath
                Mov     Eax,Esp

    ;
    ; Call the main!    /*  int main ( int argc, char * argv[], environ); */
    ;
                Push    [_environ]            ; pass environment pointer
                Push    Eax                   ; pass pointer to pointer array
                Push    Ebx                   ; pass arg count
                Call    main                  ; Start up the main()!

ExitSlow:	Mov	Esi,Eax
		Call	_cexit
		Mov	Eax,Esi
ExitQuick:	Mov	Ah,4Ch
		Int	21h
	Align	4
@@Exit01:	Mov     Edx,Offset MemoryError
                Mov     Ah,9
                Int     21h
		Mov	Al,3
		Jmp	ExitQuick
ENDP

	Dataseg

	Ifndef	NO_DMA
DMA_addr	Dd	?			; DMA near pointer address
DMA_size	Dd	8192			; DMA size in bytes
DMA_phys	Dd	?			; DMA physical address
	Endif


_environ	Dd	?		; pointer to environment
_envsize	Dd	?		; environment table entries.
environ	        Dd	?		; Table environment pointer
_psp		Dd	?		; PSP pointer
exesize		Dd	?		; Executable size
exename		Dd	?		; Executable name
_zero		Dd	?		; Relative address to zero
_zero_sel	Dd	?	     	; 4GB ZERO selector (not NULL!)
dos32version	Dd	?		; DOS32 version
dos32system	Db	?		; System extender type

AbortStackPos	Dd	?		; Saved stack position (abort)
ExitStatus	Db	3		; Exit status

MemoryError	Db	"Out of memory...",CRLF,0
	End	startup
