;****************************************************************************
; Filename: ATOI.ASM
;   Author: Adam Seychell
;  Version: 0.0
;  Created: 1995.May.01
;  Updated: -
;****************************************************************************
; Copyright Peter Andersson, 1994-1995.
; All rights reserved.
;****************************************************************************
; Function: int atoi(char * string);
;  Comment: Converts an ascii number into an integer value. The string
;           consists of optional tabs and spaces followed by a optional sign
;           followed by decimal digits followed by optional tabs and spaces.
;    Input: Eax, pointer to string
;   Output: integer of string. If could not read integer then a value of
;           zero is retunred and errno will equal -1
;****************************************************************************
Include  STDDEF.INC

    Codeseg

Proc    atoi  ,1
Local   sign_flag :byte
        
        Push    Esi
        Mov     Esi,Eax
        cld
@@skip_ch:
        lodsb
        cmp     Al,09           ; look for TAB
        je      @@skip_ch
        cmp     Al,10h          ; look for space
        je      @@skip_ch
        Dec     Esi

        mov     [sign_flag],0
        cmp     [byte ptr Esi],'-'
        jne     @@gotsign
        mov     [sign_flag],1
        Inc     Esi
@@gotsign:

        Xor     Edx,Edx

    ; Decode decimal number -------------------
    ;
        lodsb
        Mov     Ah,Al
        Sub     Ah,'0'
        Cmp     Ah,9
        Ja      @@error
@@DEC_loop:
        Sub     Al,'0'
        Cmp     Al,9
        Ja      @@GotNumber
        Movzx   Eax,Al
        Imul    Edx,10
        Add     Edx,Eax
        Lodsb
        Jmp     @@DEC_loop

@@GotNumber:
        cmp    [sign_flag],0
        je     @@j99
        Neg    Edx
@@j99:
        Mov    Eax,Edx
        mov    [errno],0
        Pop     Esi
        Ret

@@error:
        mov    [errno],-1
        Pop     Esi
        Ret
Endp  


End