;****************************************************************************
; Filename: VPRINTF.ASM
;   Author: Peter Andersson
;  Version: 0.0
;  Created: 1995.02.09
;  Updated: -
;****************************************************************************
; Copyright Peter Andersson, 1994-1995.
; All rights reserved.
;****************************************************************************
; Function: ULONG @vprintf(PSZ dest,PSZ fmtstr,PVOID argv);
;    Input: Eax,dest - pointer to the destination string
;           Edx,source - pointer to the format string
;           Ecx,argv - argument value pointer
;   Output: Number of characters converted.
;  Comment: @vprintf is used by most *printf formatter functions.
;****************************************************************************

	Include	STDDEF.INC

	Codeseg

Extrn NullPointer:Byte

Proc	vprintf ,3
		Push	Ebx,Edi,Esi,Eax
		Mov	Edi,Eax
		Mov	Esi,Edx
		Mov	Ebx,Ecx
	Align	4
@@Next01:	Mov	Al,[Esi]
		Inc	Esi
		Cmp	Al,"%"
		Je	@@Next02
		Cmp	Al,10
		Je	@@Next12
		TestZ	Al
		Je	@@Exit2             ; <- was bug bug bug bug
@@Next06:	Mov	[Edi],Al
		Inc	Edi
		Jmp	@@Next01
	Align	4
@@Next12:	Mov	[Word Edi],0A0Dh	; CR + LF
		Add	Edi,2
		Jmp	@@Next01
	Align	4
@@Exit2:	Mov	[Edi],Al
@@Exit:		Mov	Eax,Edi
		Sub	Eax,[Esp]
		Pop	+4,Esi,Edi,Ebx
		Ret
	Align	4
@@Next02:	Mov	Al,[Esi]
		Inc	Esi
		TestZ	Al
		Jz	@@Exit2
		Cmp	Al,"%"
		Je	@@Next06
		Cmp	Al,"d"
		Je	@@SDEC
		Cmp	Al,"i"
		Je	@@SDEC
		Cmp	Al,"u"
		Je	@@UDEC
		Cmp	Al,"c"
		Je	@@CHAR
		Cmp	Al,"s"
		Je	@@STR
		Cmp	Al,"x"
		Je	@@HEX
		Cmp	Al,"o"
		Je	@@OCT
		Cmp	Al,"b"
		Je	@@BIN
		Cmp	Al,"p"
		Je	@@PTR
		Cmp	Al,"n"
		Jne	@@Next06
		Mov	Eax,[Ebx]
		Add	Ebx,4
		Mov	Eax,[Eax]
		Mov	Edx,Edi
		Mov	Ecx,10
		Call	@ltoa
		Mov	Edi,Edx
		Jmp	@@Next01
	Align	4
@@SDEC:		Mov	Eax,[Ebx]
		Add	Ebx,4
		Mov	Edx,Edi
		Mov	Ecx,10
		Call	@ltoa
		Mov	Edi,Edx
		Jmp	@@Next01
	Align	4
@@UDEC:		Mov	Eax,[Ebx]
		Add	Ebx,4
		Mov	Edx,Edi
		Mov	Ecx,10
		Call	@ultoa
		Mov	Edi,Edx
		Jmp	@@Next01
	Align	4
@@CHAR:		Mov	Al,[Ebx]
		Add	Ebx,4
		Mov	[Edi],Al
		Inc	Edi
		Jmp	@@Next01
	Align	4
@@STR:		Mov	Edx,[Ebx]
		Add	Ebx,4
		TestZ	Edx
		Mov	Eax,Edi
		Jz	@@Next08
		Call	@stpcpy
		Mov	Edi,Eax
		Jmp	@@Next01
	Align	4
@@Next08:	Mov	Edx,Offset NullPointer
		Call	@stpcpy
		Mov	Edi,Eax
		Jmp	@@Next01
	Align	4
@@PTR:		Mov	[Dword Edi]," x0<"
		Mov	Eax,[Ebx]
		Add	Ebx,4
		Lea	Edx,[Edi+3]
		Call	@xtoa
		Lea	Edi,[Edx+1]
		Mov	[Byte Edx],">"
		Jmp	@@Next01
	Align	4
@@HEX:		Mov	Eax,[Ebx]
		Add	Ebx,4
		Mov	Edx,Edi
		Call	@xtoa
		Mov	Edi,Edx
		Jmp	@@Next01
	Align	4
@@OCT:		Mov	Eax,[Ebx]
		Add	Ebx,4
		Mov	Edx,Edi
		Call	@otoa
		Mov	Edi,Edx
		Jmp	@@Next01
	Align	4
@@BIN:		Mov	Eax,[Ebx]
		Add	Ebx,4
		Mov	Edx,Edi
		Call	@btoa
		Mov	Edi,Edx
		Jmp	@@Next01
Endp

	End
