;****************************************************************************
; Filename: GETVECT.ASM
;   Author: Peter Andersson
;  Version: 0.0
;  Created: 1995.03.13
;  Updated: -
;****************************************************************************
; Copyright Peter Andersson, 1994-1995.
; All rights reserved.
;****************************************************************************
; Function: VOID @getvect(ULONG i,PIRQVECT v);
;  Comment: Gets a interrupt vector
;    Input: Eax, i - interrupt number (0-255)
;           Edx, v - pointer to 6 bytes holding the interrupt vector
;                    with a 32bit offset followed by the 16bit selector.
;   Output: nothing
;****************************************************************************
; Function: void * @_getfarptr(void * near_address, char mode);
;  Comment: Gets a far pointer of a procedure or data varible.
;    Input: Eax, pointer to procedure or data varible.
;           Dl,  Type of far pointer returned. If zero then the selector
;		  will be set to the code segment. If non-zero then it's
;		  to the programs data segment.
;   Output: a temperary pointer to a 6 byte array containing the 32bit
;           far pointer.
;****************************************************************************

	Include STDDEF.INC

	Codeseg

Proc	getvect ,2
		Push	Edx
		Mov	Bl,Al
		Mov	Ax,204h
		Int	31h
		Pop	Eax
		Mov	[Eax],Edx
		Mov	[Eax+4],Cx
		Ret
Endp

Proc    @_getfarptr
                Mov     Cx,CS
                TestZ   Dl
                Jz @@code
       		Mov	Cx,DS
@@code:         Mov     [TempFarPointer+4],Ecx
                Mov     [TempFarPointer],Eax
                Mov     Eax,Offset TempFarPointer
                Ret
Align 4
TempFarPointer  DD ?,?

Endp    

	End
