;*****************************************************************************
; Filename: MEMMOVE.ASM
;   Author: Peter Andersson
;  Version: 0.0
;  Created: 1995.April.28
;  Updated: -
;*****************************************************************************
; Copyright Peter Andersson, 1994-1995.
; All rights reserved.
;*****************************************************************************
; Function: VOID @memmove(PVOID *src,PVOID *dest,ULONG length);
;  Comment: Moves a memory block and will always correctly copy even if
;           source and destination overlap.
;    Input: Eax - pointer to destination
;           Edx - pointer to source
;           Ecx - length to copy
;  Returns: pointer of detination (Edx)
;*****************************************************************************

	Include	STDDEF.INC

	Codeseg			; Change memory model in the STDDEF.INC

Proc	memmove  ,3
                Push    Edi Esi Eax
		TestZ	Ecx
		jz	@@End
                Cmp	Eax,Edx
                je      @@End
                Cld
                Mov	Edi,Eax
                Mov	Esi,Edx            
                Cmp	Edi,Esi
                Jb      @@forward
                Std
                Lea     Edi,[Edi+Ecx-1]
                Lea     Esi,[Esi+Ecx-1]
@@forward:
;                Mov     Dl,Cl
;                Shr     Ecx,2
;                Jz      @@Next01
;                Rep     Movsd
;@@Next01:       And     Dl,03h
;                jz      @@End
;                Mov     Cl,Dl
                Rep     Movsb
@@End: 		
                Pop Eax Esi Edi
                Ret
Endp

	End
