;*****************************************************************************
; Filename: MEMSET.ASM
;   Author: Peter Andersson
;  Version: 0.2
;  Created: 1995.03.11
;  Updated: -
;*****************************************************************************
; Copyright Peter Andersson, 1994-1995.
; All rights reserved.
;*****************************************************************************
; Function: VOID @memset(PVOID buf,BYTE char,ULONG length);
;  Comment: Sets a block of memory to a byte value.
;    Input: Eax - memory buffer to clear
;           Dl - character value to fill the buffer with
;           Ecx - buffer length
;  Returns: Nothing
;*****************************************************************************

	Include	STDDEF.INC

	Codeseg			; Change memory model in the STDDEF.INC

Proc	memset  ,3
                Push    Edi
		Jecxz	@@End
                Push    Eax
                Mov     Al,Dl
                mov     Ah,al
                mov     di,ax
                shl     eax,16
                mov     ax,di
                Pop     Edi
                Mov     Dl,Cl
                And     Dl,03h
                Shr     Ecx,2
                Cld
                Rep     Stosd
                Mov     Cl,Dl
                Rep     Stosb
@@End:		Pop     Edi
                Ret
Endp

	End
