comment ~
***************************************************************************
 BIN2ASM        A utility for converting data into .ASM hex format.

 Written by Adam Seychell.


 To compile type;

 tasm bin2asm
    or
 ml /c bin2asm

 dlink bin2asm

************************************************************************** ~
.386
.model flat, C
.stack 200h

.data

IN_ARRAY_SIZE = 16*1024

OutArray        db (IN_ARRAY_SIZE/16 + 1) * 84 DUP (?)

InArray         db IN_ARRAY_SIZE DUP (?)


.CODE
; ----------- print text to screen ---------------
;
; Expects ESI -> nul terminating string
;
; ------------------------------------------------
Print PROC Uses eax ebx ecx
@@Loop:
           lodsb
           And   al,al
           jz @@Exit
           mov   bx,0007
           mov   ah,0Eh
           int   10h
           jmp  @@Loop
@@Exit:    ret
Print ENDP

;-------------------------------------------------------------------------
; Display decimal value of EDI
;-------------------------------------------------------------------------
Display_EDI PROC Uses ebx ecx eax
        mov     ecx,1000000000
        mov     bx,000Ah
Num_loop:
        mov     eax,edi                 ; Print reqested size
        xor     edx,edx
        div     ecx                     ; al = digit
        mov     edi,edx                 ; store remander
        and     al,al
        jz lv_flg
        or  bh,1
lv_flg: test    bh,1
        jz skip_dig
        add     al,'0'
        push   ebx
        mov    bx,0007                   ; Plot al
        mov    ah,0Eh
        int    10h
        pop    ebx
skip_dig:
        mov     eax,ecx
        mov     ecx,10
        Xor     edx,edx
	div     ecx                     ; ecx := ecx/10
        mov     ecx,eax
        dec     bl
        jnz Num_loop
        ret
Display_EDI ENDP


;
; Number table for ultra fast Hexidecimal decoding.
;
align 4
HexTable Label Dword
Db '000h001h002h003h004h005h006h007h008h009h00Ah00Bh00Ch00Dh00Eh00Fh'
Db '010h011h012h013h014h015h016h017h018h019h01Ah01Bh01Ch01Dh01Eh01Fh'
Db '020h021h022h023h024h025h026h027h028h029h02Ah02Bh02Ch02Dh02Eh02Fh'
Db '030h031h032h033h034h035h036h037h038h039h03Ah03Bh03Ch03Dh03Eh03Fh'
Db '040h041h042h043h044h045h046h047h048h049h04Ah04Bh04Ch04Dh04Eh04Fh'
Db '050h051h052h053h054h055h056h057h058h059h05Ah05Bh05Ch05Dh05Eh05Fh'
Db '060h061h062h063h064h065h066h067h068h069h06Ah06Bh06Ch06Dh06Eh06Fh'
Db '070h071h072h073h074h075h076h077h078h079h07Ah07Bh07Ch07Dh07Eh07Fh'
Db '080h081h082h083h084h085h086h087h088h089h08Ah08Bh08Ch08Dh08Eh08Fh'
Db '090h091h092h093h094h095h096h097h098h099h09Ah09Bh09Ch09Dh09Eh09Fh'
Db '0A0h0A1h0A2h0A3h0A4h0A5h0A6h0A7h0A8h0A9h0AAh0ABh0ACh0ADh0AEh0AFh'
Db '0B0h0B1h0B2h0B3h0B4h0B5h0B6h0B7h0B8h0B9h0BAh0BBh0BCh0BDh0BEh0BFh'
Db '0C0h0C1h0C2h0C3h0C4h0C5h0C6h0C7h0C8h0C9h0CAh0CBh0CCh0CDh0CEh0CFh'
Db '0D0h0D1h0D2h0D3h0D4h0D5h0D6h0D7h0D8h0D9h0DAh0DBh0DCh0DDh0DEh0DFh'
Db '0E0h0E1h0E2h0E3h0E4h0E5h0E6h0E7h0E8h0E9h0EAh0EBh0ECh0EDh0EEh0EFh'
Db '0F0h0F1h0F2h0F3h0F4h0F5h0F6h0F7h0F8h0F9h0FAh0FBh0FCh0FDh0FEh0FFh'

read_counter dd 0
bytes_outputed dd 0

start:

        mov     Ah,0bh                  ; check character from STDIN
        Int     21h
        Cmp     AL,00
        je  Usage                       ; show help if char not avalible


        mov     esi,Offset logo_mesg    ; show logo message
        call    print

        mov     edx,offset FILE_TITLE   ; print heading to output
        mov     ah,9
        int     21h

UpdateBuffer:

        Mov     AH,3Fh                  ; Read block from STDIN
        Xor     Ebx,Ebx
        Mov     Edx,Offset InArray
        Mov     Ecx,IN_ARRAY_SIZE
        Int     21h
        Jc      Error
        Test    Eax,Eax                 ; exit if EOF
        jz      Finished
        Lea     Ebx,[Eax+Offset InArray] ; Ebx -> last byte of InArray

      add     read_counter,eax
      mov     edi,read_counter
      call    Display_EDI
      mov     esi,Offset update_mesg
      call    print

      Mov       Edi,Offset OutArray
      Mov       Esi,Offset InArray
      Xor       Edx,Edx


convertLoop:
      Mov       Dword ptr [Edi],'  BD'
      Add       Edi,3

      Mov       Cl,2
Align 4

Inlkoop:
Rept 8
      Mov       Dl,[Esi]
      Inc       Esi
      Cmp       Esi,Ebx
      Jg        ExitLoop
      Mov       Eax,HexTable[Edx*4]
      Mov       [Edi],Eax
      Mov       Byte Ptr [Edi+4],','
      Add       Edi,5
ENDM
        Dec     Cl
        jnz     Inlkoop

ExitLoop:
      Mov       Word Ptr [Edi-1],0a0dh
      Inc       Edi
      Cmp       Esi,Ebx
      Jl      convertLoop


      ; Dump Output Buffer to STDOUT

        Mov     AH,40h                  ; Write to STDOUT
        Mov     Ebx,1
        Mov     Edx,Offset OutArray
        Mov     Ecx,Edi
        Sub     Ecx,Offset OutArray
        Int     21h
        Jc      Error
        Test    Eax,Eax                 ; exit of EOF
        Jz      Error
        add     bytes_outputed,eax
        Jmp       UpdateBuffer


Finished:
        mov     esi,offset cglf
        call    print
        mov     edi,bytes_outputed
        call    Display_EDI
        mov     esi,Offset end_mesg
        call    print


Exit:
        mov     esi,offset cglf
        call    print
        Mov     AX,4c00h
        Int     21h

Error:
        mov     esi, Offset  comError
        call    Print
        jmp     Exit



Usage:
                Mov     Edx,Offset Usage_mesg
                Mov     Ah,9
                Int     21h
                Mov     AX,4c00h
                Int     21h

Usage_mesg      label byte
                db 'BIN2ASM  Version 1.00  by Adam Seychell.  6-June-1995',13,10,13,10
                db 'This program will read binary data from standard input and convert',13,10
                db 'it into formatted hexidecimal numbers for assembly language.',13,10,13,10
                db 'Example.',13,10
                db '               bin2asm  < infile    >  outfile',13,10
                db '$'

FILE_TITLE      db ';  BIN2ASM v1.00 file hex dumper',13,10,13,10,36
comError        db 'An error has occured',0
logo_mesg       db 'bin2asm:',13,10,0
update_mesg     db ' bytes converted',13,0
end_mesg        db ' bytes sent to output.',0
cglf            db 13,10,0


end start
