/*   v1.00

         BINOBJ     Binary to OBJ file converter by Adam Seychell, May 1995.

  How to compile with Borland C v4.0+;

You will need BCC32.EXE, DLINK.EXE, PAL.LIB, and PAL.H 

    BCC32 -c -B binobj.c
    DLINK -c binobj ,,, pal.lib


*/

#include <pal.h>

int source_handle, dest_handle,i,t,data_length,wr_ptr,p,data_offset;
unsigned char c;
char * source_name;
char * dest_name;
char * public_symbol;

int LEDATA_buffersize;

unsigned char * LEDATA_buffer;
unsigned char * LEDATA_buffer_old;

unsigned char LNAMES_SEGDEF_record[28]={
/* names record */
0x96,0x0D,0x00,
0x00,0x05,0x5F,0x54,0x45,0x58,0x54,0x04,0x43,0x4F,0x44,0x45,0x95,
/* segment definistion record */
0x99,0x09,0x00,
0xA9,0xA0,0x86,0x01,0x00,0x02,0x03,0x01,0x88
};

unsigned char MODEND_record[12]={
0x88,0x04,0x00,0x00,0xA2,0x01,0xD1,
0x8A,0x02,0x00,0x00,0x74
};


void exit_wr_error(void)
{
 printf("Error creating output file '%s' \n",dest_name);
 exit(1);
}


char getkey(void)
{
int i;
asm {
    mov ah,0
    int 16h
    movzx eax,al
    mov i,eax
 }
return i;
}


unsigned char calc_Checksum(unsigned char * string, int length )
{
unsigned char i;
asm     mov edx,string
asm     mov ecx,length
asm     mov al,0
loooper:
asm     sub ecx,1
asm     jl exitt
asm     add al,[edx+ecx]
asm     sub ecx,1
asm     jl exitt
asm     add al,[edx+ecx]
asm     sub ecx,1
asm     jl exitt
asm     add al,[edx+ecx]
asm     sub ecx,1
asm     jl exitt
asm     add al,[edx+ecx]
asm     sub ecx,1
asm     jl exitt
asm     add al,[edx+ecx]
asm     jmp loooper
exitt:
asm     mov   i,al

	return (i);
}


void write_byte(unsigned char value)
{
	if( write(dest_handle,&value,1) != 1)
			exit_wr_error();
}
void write_word(unsigned short value)
{
	if( write(dest_handle,&value,2) != 2)
			exit_wr_error();
}
void write_dword(unsigned value)
{
	if( write(dest_handle,&value,4) != 4)
			exit_wr_error();
}
void write_it(void * value, int count)
{
	if( write(dest_handle,value,count) != count)
			exit_wr_error();
}

char * Add_ext(char * string, char * exten)
{
int i,t;
char c;

	 i = strlen(string);
	 for (t=0; t < i ; t++) {
		c = *(string+i-t-1);
		if ( (c == '.') || (c == '\\')  )
			break;
	 }
	 if (c != '.') {
		  string=memcpy(malloc(i+5),string,i);
		  strcpy(string+i,exten);
		 }
	 return(string);
}



int main( int argc, char *argv[] )
{
	  printf("BIN to OBJ Converter Version 1.0 by Adam Seychell\n\n");

	if ( argc != 4 )
	 {
         printf(
"BINOBJ is a utility for creating an object module (OBJ file) containing the\n"
"binaray data from a specified file. A public symbol is defined in the object\n"
"module which will point to the beginning of the data. This program allows\n"
"large amounts of data to be easily linked into the executable.\n");
printf(
"\n"
"Usage:    BINOBJ   <source[.BIN]>  <destination[.OBJ]>  <public name>\n"
"\n"
"Examples: BINOBJ   GOTH.CHR        GOTH                 GothicFont\n"
"          BINOBJ   CGA.BGI         CGADRV               CGAdriver\n"
"          BINOBJ   XFILE           XFILE                Xdata\n\n");

  	 return EXIT_FAILURE;
	 }

	source_name= Add_ext(argv[1],".BIN");
	dest_name= Add_ext(argv[2],".OBJ");
	public_symbol=argv[3];

	LEDATA_buffersize = maxavail();
	if (LEDATA_buffersize > 0x70000) LEDATA_buffersize = 0x70000;
	if (LEDATA_buffersize < 4096) {
	 printf("not enough memory\n");
	 exit(1);
	}
	LEDATA_buffer=malloc(LEDATA_buffersize+4);

	 if (  (source_handle=open(source_name,O_RDONLY)) == -1 ||
		   (dest_handle=open(dest_name,O_WRONLY | O_CREAT | O_TRUNC)) == -1 )
		  {
		  printf("error!");
		  return EXIT_FAILURE;
	}


	data_length=filelength(source_handle);

		 /*******THEADER--Translator Header Record******************/
		  write_byte(0x80);				/* record type */
		  i=strlen(source_name);
		  write_word(i+2);				/* record length */
		  write_byte(i);
		  write_it(source_name,i);
				/* Checksum */
		  write_byte(-(0x80+2+i+i+calc_Checksum(source_name,i)));

	  /******LNAMES--List of Names Record************/
	  /*******SEGDEF--Segment Definition Record (32bit)**********/

	(unsigned int)*(unsigned int *)&LNAMES_SEGDEF_record[20] = data_length;

	c = LNAMES_SEGDEF_record[20] + LNAMES_SEGDEF_record[21];
	c += LNAMES_SEGDEF_record[22] + LNAMES_SEGDEF_record[23];
	LNAMES_SEGDEF_record[27]=-(c+0x99+0x09+0xA9+0x02+0x03+0x01);
	write_it(&LNAMES_SEGDEF_record,sizeof(LNAMES_SEGDEF_record));


	/****** PUBDEF--Public Names Definition Record (32bit)**********/
		  i = strlen(public_symbol);
		  write_byte(0x90);				/* record type */
		  write_word(7+i);				/* record length */
		  write_byte(0x00);				/* group index */
		  write_byte(0x01);				/* segment index */
		  write_byte(i);				/* string length */
		  write_it(public_symbol,i);    /* public symbol */
		  write_word(0x0000);			/* public offset */
		  write_byte(0x00);				/* type index */
				/* Checksum */
		  write_byte(-(0x90+7+i+0x01+i+calc_Checksum(public_symbol,i)));


/******  A1H LEDATA--LOGICAL ENUMERATED DATA RECORD **********/

			data_offset=0;
			LEDATA_buffer_old = LEDATA_buffer;
			for (;;)
			{
			LEDATA_buffer = LEDATA_buffer_old;

			  for (; (LEDATA_buffer-LEDATA_buffer_old) < (LEDATA_buffersize-1040) ;)
			  {
				  i=read(source_handle, LEDATA_buffer+8 ,1024);
				  if ( i == 0 ) break;
				  if ( i == -1 ) {
					printf("Error reading source file '%s'\n",source_name);
					exit(1);
				  }

				   /** fixup  the LEDATA  length & data offset & checksum **/
    	        		*(LEDATA_buffer+0)=0xA1;
        			*(LEDATA_buffer+3)=0x01;
				  (short)*(short *)(LEDATA_buffer+1) = i + 6;
				  (long)*(long *)(LEDATA_buffer+4) =data_offset;
				  *(LEDATA_buffer+i+8)= -calc_Checksum(LEDATA_buffer,i+8);
				  data_offset+=i;
				  LEDATA_buffer += i+9;
			 }
				 write_it(LEDATA_buffer_old, LEDATA_buffer-LEDATA_buffer_old );
		 if (i == 0) break;
		}

		/******* 8AH MODEND--MODULE END RECORD *******/
		  write_it(&MODEND_record,sizeof(MODEND_record));

				printf("%d bytes converted.\n",data_offset);



return EXIT_SUCCESS;
}