	page 60,132
	title	Exit - STDERRF's Abnormal Exit Procedure
	name	Exit
	
comment 
	Exit							V1.00
----------------------------------------------------------------------------
NAME
	Exit				STDERRF's Abnormal Exit Procedure

SYNOPSIS
	mov	bx, ax			; BX = DOS Error Code
	mov	ax, eqERR_EQUATE	; AX = Error Type
	call	Exit

DESCRIPTION
	Exit procedure is STDERRF's abnormal exit procedure.  This procedure
	is called if an error condition is detected.  Since most error
	conditions are the result of failed DOS interrupts, Exit will
	convert the DOS error code to hex and display it along with an error
	message.

	Lastly, DupStdErr is checked to see if it was cleared which means
	that STDERR has been restored.	If not, STDERR is retored here.

PROGRAMMING NOTES
	An index to the error messae is passed in AX register.
	The DOS Error Code is passed in BX register.
	If no DOS Error, -1 is passed in BX.

	Procedures called:
		None
	DOS Interrupts
		Int 21h 40h - Write to file or device
		Int 21h 46h - Force duplication of filehandle
		Int 21h 4ch - Terminate program with return code

RETURNS
	The Exit Procedure does not return but terminates the program by
	exiting to DOS.

CAUTIONS
	This file assembles with one warning:
		EXIT.ASM(197) : warning A6001: no return from procedure

	Since this procedure ALWAYS terminates the program and NEVER
	returns, this warning can be ignored.

MEMORY REQUIREMENTS
	Stack:	  8 bytes
	Data:	 41 bytes
	Const:	558 bytes
	Code:	114 bytes

AUTHOR
	Raymond Moon - 5 Mar 95
	Copyright (c) 1995, MoonWare
	ALL RIGHTS RESERVED

HISTORY
	Version	- Date		- Remarks
	1.00	-  5 Mar 95	- Orginal
	
	 End of Comment

	include procesor.inc
%	.MODEL	small,FORTRAN
	assume	es:DGROUP

;-----------------------------
;	Include files

	include stderrf.inc

;=========================================================================
;	DATA
;=========================================================================

	.CONST
USAGE		db	LF, "Usage:", CR, LF, TAB, "STDERRF target ",
			"execfile [command line]", CR, LF, TAB, TAB,
			"target is file to which STDERR will be ",
			"redirected", CR, LF, TAB, TAB, "execfile is ",
			"the [drive:full path\]filename.ext of program ",
			"to execute", CR, LF, TAB, TAB, "command line is ",
			"optional command line for execfile", CR, LF, LF
USAGE_LEN	equ	$ - USAGE
USERTERM	db	CR, LF, LF, "STDERRF terminated at user's request.",
			BELL
USERTERM_LEN	equ	$ - USERTERM
WRONGDOS	db	CR, LF, LF, "DOS must be version 3.0 or later.",
			BELL
WRONGDOS_LEN	equ	$ - WRONGDOS
DUPERR		db	"Unable to duplicate STDERR filehandle."
DUPERR_LEN	equ	$ - DUPERR
CREATEERR	db	"Unable to create redirection file."
CREATEERR_LEN	equ	$ - CREATEERR
FORCEDUPERR	db	"Unable to force STDERR to redirection filehandle."
FORCEDUPERR_LEN equ	$ - FORCEDUPERR
EXECERR 	db	"Unable to load and execute program."
EXECERR_LEN	equ	$ - EXECERR
RESTOREERR	db	"Unable to restore STDERR."
RESTOREERR_LEN	equ	$ - RESTOREERR
CLOSEERR	db	"Unable to close redirection file."
CLOSEERR_LEN	equ	$ - CLOSEERR

ERROR		db	CR, LF, "Error: "
ERRORCODE	db	CR, LF, "DOS Error: 0"
XLATABLE	db	"0123456789abc"

	.DATA
CLOSE		db	?, "h", CR, LF, BELL

;----------------------------
;	The order of the messages in MSGTEXT and MSGLEN must be in the
;	same order as the Error Equates in STDERRF.INC

MSGTEXT 	dw	USAGE,	   USERTERM,	WRONGDOS, DUPERR,
			CREATEERR, FORCEDUPERR, EXECERR,  RESTOREERR,
			CLOSEERR

MSGLEN		dw	USAGE_LEN,   USERTERM_LEN,   WRONGDOS_LEN,
			DUPERR_LEN,  CREATEERR_LEN,  FORCEDUPERR_LEN,
			EXECERR_LEN, RESTOREERR_LEN, CLOSEERR_LEN

;=========================================================================
;	CODE
;=========================================================================

	.CODE

Exit	proc
local	PASSED_ERR:word, DOS_ERR:word	; Local storage for passed reg args

;----------------------------
;	Save passed args

	mov	PASSED_ERR, ax		; Save Passed Error Equate
	mov	DOS_ERR, bx		; Save DOS Error Code

;----------------------------
;	If DOS_ERR is not -1, convert DOS Error Code into hex and save
;	in CLOSE message.  Use XLAT to convert binary to hex

	cmp	ax, eqMINDOSERR		; DOS Error?
	jae	EX1			; No, skip conversion and error msg
	mov	ax, bx			; AX = error code
	mov	bx, offset XLATABLE	; BX => XLAT table
	xlat				; Translate (convert bin to hex)
	mov	CLOSE, al		; Save it in error message

;----------------------------
;	Display the first error message

	@WRITE	ERROR, STDOUT

;----------------------------
;	Display message using passed error type as index

EX1:	mov	bx, PASSED_ERR		; BX = index
	shl	bx, 1			; BX = word offset
	mov	dx, MSGTEXT[bx] 	; DX => appropriate message
	mov	cx, MSGLEN[bx]		; CX = message length
	mov	bx, STDOUT		; Send to STDOUT
	mov	ah, 40h 		; Request DOS write to device or file
	int	21h			; Call DOS

;------------------------------
;	Print DOS ERROR header, if appropriate

	cmp	PASSED_ERR, eqMINDOSERR	; Is DOS Error?
	jae	EX2			; No, skip message
	@WRITE	ERRORCODE, STDOUT	; Yes, display message

;----------------------------
;	Print the error ending.  This is skipped if DOS Error = -1.

	@WRITE	CLOSE, STDOUT

;----------------------------
;	See if STDERR needs to be redirected.

EX2:	or	DupStdErr, 0		; Is STDERR still redirected?
	jz	EX3			; No, continue

	mov	cx, DupStdErr		; CX = new handle for STDERR
	mov	bx, STDERR		; BX = handle to change
	mov	ah, 46h 		; Request force dup filehandle
	int	21h			; Call DOS

;----------------------------
;	Terminate program with error

EX3:	mov	ax, 4cffh		; Terminate with -1 as return code
	int	21h			; Call DOS

Exit	endp
	end
