        ;---------------------------------------------------------------------
        ; Dot tunnel
        ; -FT/SF
        .model small
code segment para public
        assume cs:code,ds:code
        .386p
        ;
        ; This will compile as a .COM too
        ;
        org 100h
start:  jmp start1
        ;
        ;
        ; Uncomment this for 400 line mode
VGA400  equ 1
        ; Uncomment this for line-algo correction
LINEADJ equ 1
        ;
        ; Define the rotational centers
        ;
ifdef VGA400
Y_CENTER equ 90
X_CENTER equ 100
else
Y_CENTER equ 45
X_CENTER equ 100
endif

sin_inc equ 11          ;23
cos_inc equ  9          ;19

include sc256.dat
include w1.asm
include circles.asm

;democount       dd      0
draw_page_offs  dw      0A000h
disp_page_offs  dw      0000h

;dpx             dw      180,170,160,150,140,130,120
dotpos_x        dw      numtunnels dup(920)
                dw      920
dotpos_y        dw      numtunnels dup(0)
                dw      0
split_scan      dw      12Ch

dotcolor label word
        dw       1, 2, 3, 4, 5, 6, 7, 8, 9,10
        dw      11,12,13,14,15,16,17,18,19,20
        dw      21,22,23,24,25,26,27,28,29,30
        dw      31,32,33,34,35,36,37,38,39,40
        dw      41,42,43,44,45,46,47,48,49,50
        dw      51


dot_frac_x      db      numtunnels dup(0)
                db      0
dot_frac_y      db      numtunnels dup(0)
                db      0

dot_inc_x       dw      numtunnels dup(0)
                db      0
dot_inc_y       dw      numtunnels dup(0)
                db      0

dothome_x       dw      0
dothome_y       dw      0

currtun dw      0
curr_x  dw      0
curr_y  dw      0
curr_color dw   0
        ;
@swap_pages macro
        mov ax,[draw_page_offs]
        mov [disp_page_offs],ax
        mov bx,0C000h
        sub bx,ax
        mov [draw_page_offs],bx
endm @swap_pages

wait_vrt:                               ;
        mov     dx,3dah                 ;
wvr02:  in      al,dx                   ;
        test    al,8                    ;
        jz      wvr02                   ;
wvr01:  in      al,dx                   ;
        test    al,8                    ;
        jnz     wvr01                   ;
        ret                             ;

        ; Plot a point, Mode X
        ; CX = page number
        ; DI = planar address in page
        ; AL = color to plot
@plot_one macro
        mov ah,1
        shl ah,cl
        mov al,02
        mov dx,03C4h
        out dx,ax
        add di,[draw_page_offs]
        mov byte ptr es:[di],bl
endm @plot_one

        ;
        ;
        ;
plotatunnel proc
        push cx
        push bx
        mov ax,cs:[currtun]
        add ax,ax
        mov si,offset dotoffs
        add si,ax
        mov si,word ptr ds:[si]
        mov bp,dots_per_tunnel
        mov dx,03C4h
pt_05:  ;push cx
        mov bx,word ptr ds:[si]
        mov ax,word ptr ds:[si+2]
        add si,4
ifndef VGA400
        sar ax,1
endif
        add bx,[curr_x]
        add ax,[curr_y]
        ; compare bx to see if its onscreen
        cmp bx,0
        jl pt_nopoint
        cmp bx,315
        jg pt_nopoint
        cmp ax,0
        jl pt_nopoint
ifdef VGA400
        cmp ax,299
else
        cmp ax,149
endif
        jg pt_nopoint
        mov di,ax
        sal di,4
        sal ax,6
        add di,ax
        mov cl,bl
        and cl,3
        sar bx,2
        add di,bx
        mov ah,1
        shl ah,cl
        mov al,02
        out dx,ax
        add di,[draw_page_offs]
        mov bx,[curr_color]
        mov byte ptr es:[di],bl
pt_nopoint:
        dec bp
        jnz pt_05
        pop bx
        pop cx
        ret
plotatunnel endp

turn_em_on proc
        mov cx,numtunnels
        mov bx,cx
        add bx,cx
        sub bx,2
ton01:  mov ax,word ptr ds:dotpos_x[bx]
        mov [curr_x],ax
        mov ax,word ptr ds:dotpos_y[bx]
        mov [curr_y],ax
        mov ax,word ptr ds:dotcolor[bx]
        mov [curr_color],ax
        mov ax,cx
        dec ax
        mov [currtun],ax
        call plotatunnel
        sub bx,2
        loop ton01
        ret
turn_em_on endp

turn_em_off proc
        mov dx,03C4h
        mov ax,0F02h
        out dx,ax
ifdef VGA400
        mov cx,1800h;1A68h
else
        mov cx,0C00h
endif
        xor eax,eax
        mov di,[draw_page_offs]
        rep stosd
        ret
turn_em_off endp

move_the_tunnel proc
        mov cx,numtunnels
        dec cx
        mov bx,cx
        add bx,bx
mt01:   mov ax,word ptr dotpos_x[bx-2]          ; More inward dot (x)
        sub ax,word ptr dotstep[bx]             ; Add the dot step
        ;----
ifdef LINEADJ
        movsx edx,word ptr dot_inc_x[bx]
        movsx eax,ax
        sal eax,8
        push bx
        sar bx,1
        mov al,byte ptr dot_frac_x[bx-1]
        add eax,edx
        mov byte ptr dot_frac_x[bx],al
        pop bx
        sar eax,8
endif
        ;----
        mov word ptr dotpos_x[bx],ax            ; store outward

        mov ax,word ptr dotpos_y[bx-2]          ; More inward dot (y)
        mov dx,word ptr dotstep[bx]             ; add dot step /2
ifndef VGA400
        sar dx,1                                ;
endif
        sub ax,dx                               ;
        ;----
ifdef LINEADJ
        movsx eax,ax
        sal eax,8
        push bx
        sar bx,1
        mov al,byte ptr dot_frac_y[bx-1]
        pop bx
        movsx edx,word ptr dot_inc_y[bx]
        add eax,edx
        push bx
        sar bx,1
        mov byte ptr dot_frac_y[bx],al
        pop bx
        sar eax,8
endif
        ;----
        mov word ptr dotpos_y[bx],ax            ; store outward

        mov ax,word ptr dot_inc_x[bx-2]
        mov word ptr dot_inc_x[bx],ax
        mov ax,word ptr dot_inc_y[bx-2]
        mov word ptr dot_inc_y[bx],ax

        sub bx,2                                ;
        dec cx
        je mtrd
        jmp mt01
        ;-------
mtrd:   mov bx,[dothome_x]
        add bx,sin_inc
        cmp bx,1024
        jl mt02
        sub bx,1024
mt02:   mov [dothome_x],bx
        movsx ax,byte ptr sin256[bx]
        add ax,X_CENTER
        mov [dotpos_x],ax
        ;--
ifdef LINEADJ
        mov bx,X_CENTER
        sub bx,ax
        movsx eax,bx
        sal eax,8
        or eax,eax
        jl @@01
        xor edx,edx
        jmp short @@02
@@01:   mov edx,-1
@@02:   mov ecx,numtunnels
        idiv ecx
        mov [dot_inc_x],ax
endif
        ;-------
        mov bx,[dothome_y]
        add bx,cos_inc
        cmp bx,1024
        jl mt03
        sub bx,1024
mt03:   mov [dothome_y],bx
        movsx ax,byte ptr cos256[bx]
ifndef VGA400
        sar ax,1
endif
        add ax,Y_CENTER
        mov [dotpos_y],ax
        ;--
ifdef LINEADJ
        mov bx,Y_CENTER
        sub bx,ax
        movsx eax,bx
        sal eax,8
        or eax,eax
        jl @@03
        xor edx,edx
        jmp short @@04
@@03:   mov edx,-1
@@04:   mov ecx,numtunnels
        idiv ecx
        mov [dot_inc_y],ax
endif
        ;--------
        mov cx,numtunnels
mt04:   mov bx,numtunnels
        sub bx,cx
        inc bx
        mov eax,[democount]
        and eax,7
        mov dx,bx
        sub dx,ax
        xor ax,ax
        and dx,4
        je mt04b
        ;-----
        mov dx,03C8h
        mov al,bl
        out dx,al
        inc dx
        sal ax,2
        cmp ax,64
        jl mt05a
        mov al,63
mt05a:  out dx,al
        out dx,al
        out dx,al
        jmp short mt04c
mt04b:  mov dx,03C8h
        mov al,bl
        out dx,al
        inc dx
        sal ax,1
        cmp ax,32
        jl mt05b
        mov ax,31
mt05b:  out dx,al
        out dx,al
        out dx,al
mt04c:  loop mt04
        mov [dot_frac_x],0
        mov [dot_frac_y],0
        ret
move_the_tunnel endp

start1:
        mov ax,cs
        mov ds,ax
        mov ax,0013h
        int 10h
        mov ax,0A000h
        mov es,ax
        ;-----
        ; unchain the video mode
        mov dx,03C4h
        mov ax,0604h
        out dx,ax
        mov ax,0E317h
        mov dx,03D4h
        out dx,ax
        mov ax,0014h
        out dx,ax
        ;---------
        mov al,09h
        out dx,al
        inc dx
        in al,dx
        and al,010100001b
ifdef VGA400
        and al,0FEh     ; for 400-line mode
endif
        mov ah,al
        mov al,09h
        dec dx
        out dx,ax

        mov dx,03D4h
        mov al,07h
        out dx,al
        inc dx
        in al,dx
        mov ah,al
        mov bx,[split_scan]
        and bx,100h
        jz @@06
        or ah,10h
        jmp short @@07
@@06:   and ah,0EFh
@@07:   mov al,07h
        dec dx
        out dx,ax
        mov al,18h
        mov ah,byte ptr ds:[split_scan]
        out dx,ax

        mov dx,03C4h
        mov ax,0F02h
        out dx,ax
        mov cx,04000h
        xor eax,eax
        xor di,di
        rep stosd

        mov [draw_page_offs],0h
        mov [disp_page_offs],0h

        call writer_init
        mov [disp_page_offs],02000h
        mov [draw_page_offs],0A000h

cont:
        ; Set the video page
        mov dx,03D4h
        mov bx,[disp_page_offs]
        mov ah,bh
        mov al,0Ch
        out dx,ax
        mov ah,bl
        mov al,0Dh
        out dx,ax

        call wait_vrt
        call move_the_tunnel
        call turn_em_off
        call turn_em_on
        call do_writing

        @swap_pages
        inc [democount]
        mov ah,01
        int 16h
        jz cont

exit:
        mov ax,0003h
        int 10h
        mov ax,4C00h
        int 21h

code ends
        end start

