1000 'REAL-TIME 3D GRAPHICS  (PC Plus issue 99, January 1995)
1010 '( Uploaded by TST for DarkCorner )
1020 '(acknowledgments to Paul Grosse)
1030 '
1040 ' WCO - "World" Coordinates (three dimensions)
1050 DIM WCO!(200, 3)
1060 DIM OWCO!(200, 3)
1070 ' SCO - Screen Coordinates (only two dimensions)
1080 DIM SCO!(200, 2)
1090 DIM OSCO!(200, 2)
1100 DIM EDGES%(2, 200)
1110 '
1120 ' Set Globals
1130 '
1140 A$ = "X"
1150 SCREEN 9
1160 'Process loop (not executed first time around!)
1170 WHILE A$ <> CHR$(27)
1180    'get an image (choice)
1190  GOSUB 5380
1200  PRIME = 1
1210  MAX = 0
1220  READ TITLE$
1230  ANGLEX = 0
1240  ANGLEY = 0
1250  NUMVERTS = 0
1260  'read until 999, counting number of vertices
1270  BRAKE = 1
1280  WHILE BRAKE
1290   NUMVERTS = NUMVERTS + 1
1300   READ S
1310   BRAKE = S
1320   WHILE BRAKE <> 999
1330    READ T, U
1340    OWCO!(NUMVERTS, 1) = S
1350    OWCO!(NUMVERTS, 2) = T
1360    OWCO!(NUMVERTS, 3) = U
1370    BRAKE = 999
1380   WEND
1390   'compute maximum coordinate seen
1400   V1 = ABS(S): V2 = ABS(T): V3 = ABS(U)
1410   IF MAX < V1 AND V1 < 999 THEN MAX = V1
1420   IF MAX < V2 THEN MAX = V2
1430   IF MAX < V3 THEN MAX = V3
1440   IF S = 999 THEN BRAKE = 0: NUMVERTS = NUMVERTS - 1
1450  WEND
1460  NUMEDGES = 0
1470  'read until 999, counting number of edges
1480  BRAKE = 1
1490  WHILE BRAKE
1500   NUMEDGES = NUMEDGES + 1
1510   READ S%
1520   BRAKE = S%
1530   WHILE BRAKE <> 999
1540    READ T%
1550    EDGES%(1, NUMEDGES) = S%
1560    EDGES%(2, NUMEDGES) = T%
1570    BRAKE = 999
1580   WEND
1590   IF S% = 999 THEN BRAKE = 0: NUMEDGES = NUMEDGES - 1
1600  WEND
1610  'enlarge the image to fit the screen better
1620  IF MAX > 0 THEN X = 10 / MAX ELSE X = 1
1630  IF X < 1 THEN X = 1
1640  FOR I% = 1 TO NUMVERTS
1650   OWCO!(I%, 1) = OWCO!(I%, 1) * X
1660   OWCO!(I%, 2) = OWCO!(I%, 2) * X
1670   OWCO!(I%, 3) = OWCO!(I%, 3) * X
1680  NEXT
1690  DIST = 10 * X
1700  MAGN = 10
1710  GOSUB 4330
1720 ' Process the picture until ESC or ENTER pressed
1730  GOSUB 3960
1740 ' ESC leaves the loop
1750 WEND
1760 STOP
1770 '***********************
1780 'CUBE framework
1790 '
1800   DATA "CUBE"
1810 'vertices:
1820 'cube itself
1830   DATA -1,-1,-1,  1,-1,-1,  1,1,-1,  -1,1,-1
1840   DATA -1,-1,1,  1,-1,1,  1,1,1,  -1,1,1
1850 'bar
1860   DATA 0,0,0, 0,0,-1, 0,1,-1
1870   DATA 999
1880 'edges:
1890 'cube itself
1900   DATA 1,2, 2,3, 3,4, 4,1
1910   DATA 1,5, 2,6, 3,7, 4,8
1920   DATA 5,6, 6,7, 7,8, 8,5
1930 'bar
1940   DATA 9,10, 10,11
1950   DATA 999
1960 '***********************
1970 'DIE
1980 '
1990   DATA "DIE"
2000 'vertices:
2010   DATA -1,-1,-1,  1,-1,-1,  1,1,-1,  -1,1,-1
2020   DATA -1,-1,1,  1,-1,1,  1,1,1,  -1,1,1
2030 'one
2040   DATA 0,.05,1,  .05,0,1,  0,-.05,1,  -.05,0,1
2050 'two
2060   DATA .55,1,-.5,  .5,1,-.45,  .45,1,-.5,  .5,1,-.55
2070   DATA -.45,1,.5,  -.5,1,.55,  -.55,1,.5,  -.5,1,.45
2080 'three
2090   DATA 1,.55,-.5,  1,.5,-.45,  1,.45,-.5,  1,.5,-.55
2100   DATA 1,.05,0,  1,0,.05,  1,-.05,0,  1,0,-.05
2110   DATA 1,-.45,.5,  1,-.5,.55,  1,-.55,.5,  1,-.5,.45
2120 'four
2130   DATA -1,.55,-.5,  -1,.5,-.45,  -1,.45,-.5,  -1,.5,-.55
2140   DATA -1,-.45,-.5,  -1,-.5,-.45,  -1,-.55,-.5,  -1,-.5,-.55
2150   DATA -1,.55,.5,  -1,.5,.55,  -1,.45,.5,  -1,.5,.45
2160   DATA -1,-.45,.5,  -1,-.5,.55,  -1,-.55,.5,  -1,-.5,.45
2170 'five
2180   DATA .55,-1,-.5,  .5,-1,-.45,  .45,-1,-.5,  .5,-1,-.55
2190   DATA -.45,-1,-.5,  -.5,-1,-.45,  -.55,-1,-.5,  -.5,-1,-.55
2200   DATA .55,-1,.5,  .5,-1,.55,  .45,-1,.5,  .5,-1,.45
2210   DATA -.45,-1,.5,  -.5,-1,.55,  -.55,-1,.5,  -.5,-1,.45
2220   DATA .05,-1,0,  0,-1,.05,  -.05,-1,0,  0,-1,-.05
2230 'six
2240   DATA -.5,-.55,-1,  -.55,-.5,-1,  -.5,-.45,-1,  -.45,-.5,-1
2250   DATA 0,-.55,-1,  -.05,-.5,-1,  0,-.45,-1,  .05,-.5,-1
2260   DATA .5,-.55,-1,  .45,-.5,-1,  .5,-.45,-1,  .55,-.5,-1
2270   DATA -.5,.45,-1,  -.55,.5,-1,  -.5,.55,-1,  -.45,.5,-1
2280   DATA 0,.45,-1,  -.05,.5,-1,  0,.55,-1,  .05,.5,-1
2290   DATA .5,.45,-1,  .45,.5,-1,  .5,.55,-1,  .55,.5,-1
2300   DATA 999
2310 'edges:
2320   DATA 1,2, 2,3, 3,4, 4,1
2330   DATA 1,5, 2,6, 3,7, 4,8
2340   DATA 5,6, 6,7, 7,8, 8,5
2350 'one
2360   DATA 9,10,  10,11,  11,12,  12,9
2370 'two
2380   DATA 13,14,  14,15,  15,16,  16,13
2390   DATA 17,18,  18,19,  19,20,  20,17
2400 'three
2410   DATA 21,22,  22,23,  23,24,  24,21
2420   DATA 25,26,  26,27,  27,28,  28,25
2430   DATA 29,30,  30,31,  31,32,  32,29
2440 'four
2450   DATA 33,34,  34,35,  35,36,  36,33
2460   DATA 37,38,  38,39,  39,40,  40,37
2470   DATA 41,42,  42,43,  43,44,  44,41
2480   DATA 45,46,  46,47,  47,48,  48,45
2490 'five
2500   DATA 49,50,  50,51,  51,52,  52,49
2510   DATA 53,54,  54,55,  55,56,  56,53
2520   DATA 57,58,  58,59,  59,60,  60,57
2530   DATA 61,62,  62,63,  63,64,  64,61
2540   DATA 65,66,  66,67,  67,68,  68,65
2550 'six
2560   DATA 69,70,  70,71,  71,72,  72,69
2570   DATA 73,74,  74,75,  75,76,  76,73
2580   DATA 77,78,  78,79,  79,80,  80,77
2590   DATA 81,82,  82,83,  83,84,  84,81
2600   DATA 85,86,  86,87,  87,88,  88,85
2610   DATA 89,90,  90,91,  91,92,  92,89
2620   DATA 999
2630 '***********************
2640 ' "Hello"
2650 '
2660   DATA "HELLO"
2670 'vertices:
2680 'H
2690   DATA -5,2,-1,  -5,0,-1,  -5,-2,-1, -3.5,2,-1, -3.5,0,-1, -3.5,-2,-1
2700 'e
2710   DATA -2.5,-.5,-1, -2.5,-1,-1, -2.5,-1.5,-1, -2,-2,-1, -1.5,-2,-1
2720   DATA -1.25,-1.75,-1, -1,-1,-1, -1,-.5,-1, -1.5,0,-1, -2,0,-1
2730 'l
2740   DATA 0,1.5,-1, 0,-1.5,-1, .5,-2,-1
2750 'l
2760   DATA 1.5,1.5,-1, 1.5,-1.5,-1, 2,-2,-1
2770 'o
2780   DATA 3,-.5,-1, 3,-1.5,-1, 3.5,-2,-1, 4,-2,-1
2790   DATA 4.5,-1.5,-1, 4.5,-.5,-1, 4,0,-1, 3.5,0,-1
2800 'H
2810   DATA -5,2,0,  -5,0,0,  -5,-2,0, -3.5,2,0, -3.5,0,0, -3.5,-2,0
2820 'e
2830   DATA -2.5,-.5,0, -2.5,-1,0, -2.5,-1.5,0, -2,-2,0, -1.5,-2,0
2840   DATA -1.25,-1.75,0, -1,-1,0, -1,-.5,0, -1.5,0,0, -2,0,0
2850 'l
2860   DATA 0,1.5,0, 0,-1.5,0, .5,-2,0
2870 'l
2880   DATA 1.5,1.5,0, 1.5,-1.5,0, 2,-2,0
2890 'o
2900   DATA 3,-.5,0, 3,-1.5,0, 3.5,-2,0, 4,-2,0
2910   DATA 4.5,-1.5,0, 4.5,-.5,0, 4,0,0, 3.5,0,0
2920   DATA 999
2930 'edges:
2940 'H
2950   DATA 1,3, 4,6, 2,5
2960   DATA 31,33, 34,36, 32,35
2970 'e
2980   DATA 7,9, 9,10, 10,11, 11,12, 13,14, 14,15, 15,16, 16,7, 8,13
2990   DATA 37,39, 39,40, 40,41, 41,42, 43,44, 44,45, 45,46, 46,37, 38,43
3000 'l
3010   DATA 17,18, 18,19
3020   DATA 47,48, 48,49
3030 'l
3040   DATA 20,21, 21,22
3050   DATA 50,51, 51,52
3060 '0
3070   DATA 23,24, 24,25, 25,26, 26,27, 27,28, 28,29, 29,30, 30,23
3080   DATA 53,54, 54,55, 55,56, 56,57, 57,58, 58,59, 59,60, 60,53
3090 'H depth
3100   DATA 1,31, 3,33, 4,34, 6,36
3110 'e depth
3120   DATA 7,37, 9,39, 10,40, 11,41, 12,42, 13,43, 14,44, 15,45, 16,46
3130 'l depth
3140   DATA 17,47, 18,48, 19,49
3150 'l depth
3160   DATA 20,50, 21,51, 22,52
3170 'o depth
3180   DATA 23,53, 24,54, 25,55, 26,56, 27,57, 28,58, 29,59, 30,60
3190   DATA 999
3200 '***********************
3210 ' TESSERACT (shadow of a hypercube)
3220 '
3230   DATA "TESSERACT"
3240 'vertices:
3250 'innermost cube
3260   DATA -1,-1,-1,  -1,1,-1,  1,1,-1,  1,-1,-1
3270   DATA -1,-1,1,   -1,1,1,   1,1,1,   1,-1,1
3280 'outermost cube
3290   DATA -2.3,-2.3,-2.3,  -2.3,2.3,-2.3,  2.3,2.3,-2.3,  2.3,-2.3,-2.3
3300   DATA -2.3,-2.3,2.3,   -2.3,2.3,2.3,   2.3,2.3,2.3,   2.3,-2.3,2.3
3310   DATA 999
3320 'edges:
3330 'connect innermost cube
3340   DATA 1,2, 2,3, 3,4, 4,1, 5,6, 6,7, 7,8, 8,5
3350   DATA 1,5, 2,6, 3,7, 4,8
3360 'connect outermost cube
3370   DATA 9,10, 10,11, 11,12, 12,9, 13,14, 14,15, 15,16, 16,13
3380   DATA 9,13, 10,14, 11,15, 12,16
3390 'connect innermost to outermost
3400   DATA 1,9, 2,10, 3,11, 4,12, 5,13, 6,14, 7,15, 8,16
3410   DATA 999
3420 '***********************
3430 ' TETRAHEDRON
3440 '
3450   DATA "TETRAHEDRON"
3460 'vertices:
3470   DATA -1,-.5774,.5443,  1,-.5774,.5443
3480   DATA 0,1.155,.5443,  0,0,-1.0887
3490   DATA 999
3500 'edges:
3510   DATA 1,2,  2,3,  3,1,  1,4,  2,4,  3,4
3520   DATA 999
3530 '***********************
3540 ' UMBRELLA
3550 '
3560   DATA "UMBRELLA"
3570 'vertices:
3580   DATA -1.414,0,0,  -1,0,-1,  0,0,-1.414,  1,0,-1
3590   DATA 1.414,0,0,  1,0,1,  0,0,1.414,  -1,0,1
3600   DATA 0,2,0,  0,-2,0, .2,-2.2,0, .4,-2,0
3610   DATA 999
3620 'edges:
3630   DATA 1,2,  2,3,  3,4,  4,5,  5,6,  6,7,  7,8,  8,1
3640   DATA 1,9,  2,9,  3,9,  4,9,  5,9,  6,9,  7,9,  8,9
3650   DATA 9,10, 10,11,  11,12
3660   DATA 999
3670 '***********************
3680 ' OCTAHEDRON
3690 '
3700   DATA "OCTAHEDRON"
3710 'vertices:
3720   DATA -1,0,0,  0,0,-1,  1,0,0,  0,0,1,  0,1,0,  0,-1,0
3730   DATA 999
3740 'edges:
3750   DATA 1,2,  2,3,  3,4,  4,1
3760   DATA 1,5,  2,5,  3,5,  4,5
3770   DATA 1,6,  2,6,  3,6,  4,6
3780   DATA 999
3790 '***********************
3800 ' POLYHEDRON
3810 '
3820   DATA "POLYHEDRON"
3830 'vertices:
3840   DATA -1.732,0,0,  0,0,-1.732,  1.732,0,0,  0,0,1.732
3850   DATA 0,1.732,0,  0,-1.732,0
3860   DATA -1,-1,-1,  1,-1,-1,  1,1,-1,  -1,1,-1
3870   DATA -1,-1,1,  1,-1,1,  1,1,1,  -1,1,1
3880   DATA 999
3890 'edges:
3900   DATA 1,7,  1,10,  1,14,  1,11,  6,7,  6,8,  6,12,  6,11
3910   DATA 3,8,  3,9,  3,13,  3,12,  5,9,  5,10,  5,14,  5,13
3920   DATA 2,7,  2,8,  2,9,  2,10,  4,11,  4,12,  4,13,  4,14
3930   DATA 7,8,  8,9,  9,10,  10,7,  11,12,  12,13,  13,14,  14,11
3940   DATA 7,11,  8,12,  9,13,  10,14
3950   DATA 999
3960 '***********************
3970 ' Subroutine to Process Keystrokes
3980 '
3990 ' first time (PRIME=1) simulate left-rotate
4000 WHILE 1
4010  A$ = ""
4020  IF PRIME = 1 THEN PRIME = 0: A$ = "XK"
4030  WHILE LEN(A$) = 0
4040   GOSUB 4330
4050   A$ = INKEY$
4060  WEND
4070  IF A$ = CHR$(13) THEN RETURN
4080  IF A$ = CHR$(27) THEN RETURN
4090  'convert numpad to direction keys
4100  IF LEN(A$) = 1 THEN A$ = "X" + MID$("XOPQKXMGHI", VAL(A$) + 1, 1)
4110  R$ = RIGHT$(A$, 1)
4120  OK = 0
4130  ANGLEX = 0
4140  ANGLEY = 0
4150 'distortion
4160  IF R$ = "G" THEN OK = -1: DIST = DIST * 1.05
4170  IF R$ = "O" THEN OK = -1: DIST = DIST / 1.05
4180  IF DIST < 5 THEN DIST = 5
4190  IF DIST > 50 THEN DIST = 50
4200 'magnification
4210  IF R$ = "I" THEN OK = -1: MAGN = MAGN * 1.05
4220  IF R$ = "Q" THEN OK = -1: MAGN = MAGN / 1.05
4230  IF MAGN < .5 THEN MAGN = .5
4240  IF MAGN > 999 THEN MAGN = 999
4250 'angleX (left/right rotation)
4260  IF R$ = "K" THEN OK = -1: ANGLEX = ANGLEX + .1
4270  IF R$ = "M" THEN OK = -1: ANGLEX = ANGLEX - .1
4280 'angleY (up/down rotation)
4290  IF R$ = "H" THEN OK = -1: ANGLEY = ANGLEY + .1
4300  IF R$ = "P" THEN OK = -1: ANGLEY = ANGLEY - .1
4310  IF OK THEN WHILE LEN(INKEY$): WEND: GOSUB 4330
4320 WEND
4330 '***********************
4340 ' Subroutine to Display
4350 '
4360 'calc world coords
4370 SX = SIN(ANGLEX)
4380 SY = SIN(ANGLEY)
4390 CX = COS(ANGLEX)
4400 CY = COS(ANGLEY)
4410 FOR I% = 1 TO NUMVERTS
4420  'rotate around y axis first
4430  INTERX = OWCO!(I%, 1) * CX + OWCO!(I%, 3) * SX
4440  INTERY = OWCO!(I%, 2)
4450  INTERZ = -OWCO!(I%, 1) * SX + OWCO!(I%, 3) * CX
4460  'NOW rotate around X axis
4470  WCO!(I%, 1) = INTERX
4480  WCO!(I%, 2) = INTERY * CY - INTERZ * SY
4490  WCO!(I%, 3) = INTERY * SY + INTERZ * CY
4500 '
4510  'write the world vertices back to the object vertices
4520  OWCO!(I%, 1) = WCO!(I%, 1)
4530  OWCO!(I%, 2) = WCO!(I%, 2)
4540  OWCO!(I%, 3) = WCO!(I%, 3)
4550 NEXT
4560 '
4570 'calculate screen coordinates
4580 '
4590 FOR I% = 1 TO NUMVERTS
4600  DIP = WCO!(I%, 3) + DIST
4610  IF DIP = 0 THEN DIP = .5
4620  DIP = DIST / DIP * MAGN
4630  SCO!(I%, 1) = 300 + WCO!(I%, 1) * DIP
4640  SCO!(I%, 2) = 200 - WCO!(I%, 2) * DIP * .73
4650  FOR J% = 1 TO 2
4660   IF SCO!(I%, J%) > 10000 THEN SCO!(I%, J%) = 10000
4670   IF SCO!(I%, J%) < -10000 THEN SCO!(I%, J%) = -10000
4680  NEXT
4690 NEXT
4700 '
4710 ' Now show the Display
4720 '
4730 FOR I% = 1 TO NUMEDGES
4740  'get scrx/y data for the first point
4750  P1% = EDGES%(1, I%)
4760  X1% = OSCO!(P1%, 1)
4770  Y1% = OSCO!(P1%, 2)
4780  'get scrx/y data for the second point
4790  P2% = EDGES%(2, I%)
4800  X2% = OSCO!(P2%, 1)
4810  Y2% = OSCO!(P2%, 2)
4820  'draw it
4830  LINE (X1%, Y1%)-(X2%, Y2%), 0
4840 NEXT
4850 '
4860 FOR I% = 1 TO NUMEDGES
4870  'get x/y data for the first point
4880  P1% = EDGES%(1, I%)
4890  X1% = SCO!(P1%, 1)
4900  Y1% = SCO!(P1%, 2)
4910  'get x/y data for the second point
4920  P2% = EDGES%(2, I%)
4930  X2% = SCO!(P2%, 1)
4940  Y2% = SCO!(P2%, 2)
4950  'draw it
4960  LINE (X1%, Y1%)-(X2%, Y2%), 20
4970  'copy vertex to `old'
4980  OSCO!(P1%, 1) = SCO!(P1%, 1)
4990  OSCO!(P1%, 2) = SCO!(P1%, 2)
5000  OSCO!(P2%, 1) = SCO!(P2%, 1)
5010  OSCO!(P2%, 2) = SCO!(P2%, 2)
5020 NEXT
5030 'print statistics
5040 LOCATE 1, 50: COLOR 10: PRINT TITLE$;
5050 LOCATE 1, 1
5060 COLOR 15: PRINT "Magnification:";
5070 COLOR 12: PRINT USING "###.##"; MAGN;
5080 COLOR 14: PRINT " PgUp[9]  PgDn[3]"
5090 COLOR 15: PRINT "Distortion   :";
5100 COLOR 12: PRINT USING "###.##"; DIST;
5110 COLOR 14: PRINT " Home[7]  End [1]"
5120 COLOR 15: PRINT "X-rotation   :";
5130 COLOR 12: PRINT USING "###.##"; ANGLEX;
5140 COLOR 14: PRINT "  "; CHR$(27); "[4]     "; CHR$(26); "[6]"
5150 COLOR 15: PRINT "Y-rotation   :";
5160 COLOR 12: PRINT USING "###.##"; ANGLEY;
5170 COLOR 14: PRINT "  "; CHR$(24); "[8]     "; CHR$(25); "[2]"
5180 PRINT "ENTER "; : COLOR 15: PRINT "to reset   ";
5190 COLOR 14: PRINT "ESC "; : COLOR 15: PRINT "to finish"
5200 PRINT "Any other key to pause"
5210 RETURN
5220 '***********************
5230 ' Subroutine to read a choice and centralise its display
5240 '
5250 GOSUB 5760
5260 VALID = CHOICE
5270 WHILE VALID
5280  READ X$
5290  A% = 1
5300  FOR I% = 1 TO LEN(X$)
5310   IF MID$(X$, I%, 1) <> " " THEN A% = I%
5320  NEXT
5330  LOCATE CHOICE + 8, 30: PRINT SPACE$(20);
5340  LOCATE , 30: PRINT SPACE$((20 - A%) \ 2); X$;
5350  VALID = 0
5360 WEND
5370 RETURN
5380 '***********************
5390 ' Subroutine to select an image
5400 '
5410 ' Find out how many choices there are
5420 CHOICE = 1
5430 CHOICES = 0
5440 WHILE CHOICE
5450  CHOICES = CHOICES + 1
5460  CHOICE = CHOICES
5470  GOSUB 5760
5480 WEND
5490 CHOICES = CHOICES - 1
5500 COLOR , 1: LOCATE 7, 32: PRINT "Choose an Image";
5510 COLOR 7
5520 LINE (217, 99)-(407, 140 + 14 * CHOICES), 14, BF
5530 LINE (225, 106)-(399, 133 + 14 * CHOICES), 0, BF
5540 FOR X% = 0 TO CHOICES
5550  CHOICE = X%
5560  GOSUB 5220
5570 NEXT
5580 CHOICE = 1
5590 BRAKE = 1
5600 WHILE BRAKE
5610  K$ = ""
5620  COLOR 14: GOSUB 5220
5630  WHILE LEN(K$) = 0
5640   K$ = INKEY$
5650  WEND
5660  COLOR 7: GOSUB 5220
5670  WHILE LEN(K$) = 2
5680   K$ = CHR$(48 + INSTR("xPxxxxxH", RIGHT$(K$, 1)))
5690  WEND
5700  IF K$ = "8" THEN CHOICE = (CHOICE + CHOICES) MOD (CHOICES + 1)
5710  IF K$ = "2" THEN CHOICE = (CHOICE + 1) MOD (CHOICES + 1)
5720  IF K$ = CHR$(13) THEN BRAKE = 0
5730 WEND
5740 CLS
5750 IF CHOICE = 0 THEN STOP
5760 '***********************
5770 ' Subroutine providing actual choices
5780 '
5790 A% = CHOICE
5800 WHILE A% = 0
5810  LOCATE CHOICES + 9, 30
5820  PRINT SPACE$(8); "QUIT"; SPACE$(8);
5830  A% = 999
5840 WEND
5850 WHILE A% = 1
5860  RESTORE 1770
5870  A% = 0
5880 WEND
5890 WHILE A% = 2
5900  RESTORE 1960
5910  A% = 0
5920 WEND
5930 WHILE A% = 3
5940  RESTORE 2630
5950  A% = 0
5960 WEND
5970 WHILE A% = 4
5980  RESTORE 3200
5990  A% = 0
6000 WEND
6010 WHILE A% = 5
6020  RESTORE 3420
6030  A% = 0
6040 WEND
6050 WHILE A% = 6
6060  RESTORE 3530
6070  A% = 0
6080 WEND
6090 WHILE A% = 7
6100  RESTORE 3670
6110  A% = 0
6120 WEND
6130 WHILE A% = 8
6140  RESTORE 3790
6150  A% = 0
6160 WEND
6170 IF A% THEN CHOICE = 0
6180 RETURN

