Attribute VB_Name = "JPEGBASIC"
Type BITMAPINFOHEADER '40 bytes
        biSize As Long
        biwidth As Long
        biheight As Long
        biPlanes As Integer
        biBitCount As Integer
        biCompression As Long
        biSizeImage As Long
        biXPelsPerMeter As Long
        biYPelsPerMeter As Long
        biClrUsed As Long
        biClrImportant As Long
End Type

Type BITMAPINFO   'Varies
        bmiHeader As BITMAPINFOHEADER
        bmiColors As String * 256 ' Array length is arbitrary; may be changed
End Type

Declare Function rfile Lib "c:\windows\system\imglib16.dll" Alias "ReadFileIntoDIB" (ByVal st As String) As Long
Declare Function BITMHead Lib "c:\windows\system\Dibinfo.dll" (ByVal ldib As Long, lpinfo As BITMAPINFO) As Long
Declare Sub DIBFree Lib "c:\windows\system\imglib16.dll" (ByVal ldib As Long)
Declare Function CreateDIBitmap Lib "GDI" (ByVal hDC As Integer, lpInfoHeader As BITMAPINFOHEADER, ByVal dwUsage As Long, ByVal lpInitBits As Long, lpInitInfo As BITMAPINFO, ByVal wUsage As Integer) As Integer
Declare Function DeleteObject Lib "GDI" (ByVal hDC As Integer) As Integer
Declare Function CreateCompatibleDC Lib "GDI" (ByVal hDC As Integer) As Integer
Declare Function DeleteDC Lib "GDI" (ByVal hDC As Integer) As Integer
Declare Function StretchBlt% Lib "GDI" (ByVal hDC%, ByVal x%, ByVal y%, ByVal nWidth%, ByVal nHeight%, ByVal hSrcDC%, ByVal XSrc%, ByVal YSrc%, ByVal nSrcWidth%, ByVal nSrcHeight%, ByVal dwrop&)
Declare Function SelectObject% Lib "GDI" (ByVal hDC%, ByVal x%)


Global Const CBM_INIT = &H4&
Global bih As BITMAPINFOHEADER
Global bi As BITMAPINFO
Global ldib As Long
Global lbits As Long
Global nam$
Global jpegnum




Public Sub displayjpeg()
nam$ = "c:\vb\kimdog.jpg"
'nam$ is name of 24 bit jpeg file to display

'main DLL, imglib.dll takes JPEG file nam$, decodes it and stores it as
'a Device Independent Bitmap ie a DIB
    ldib = rfile(nam$)

'second DLL,dibinfo.dll extracts the BITMAPINFO from the DIB
'that is the size of the image x and y number of colours etc
    lbits = BITMHead(ldib, bi)

'print on screen DIB diagnostic information
    Form1.Picture1.CurrentX = 0
    Form1.Picture1.CurrentY = 0
    Form1.Picture1.Print "dib "; ldib
    Form1.Picture1.Print "return "; lbits

'extract a subset of image info, the BITMAPHEADERINFO
'from the BITMAPINFO
    LSet bih = bi.bmiHeader

'print on screen the JPEG image information
    Form1.Picture2.CurrentX = 0
    Form1.Picture2.CurrentY = 0
    Form1.Picture2.Print "size  "; bih.biSize
    Form1.Picture2.Print "width  "; bih.biwidth
    Form1.Picture2.Print "height  "; bih.biheight
    Form1.Picture2.Print "number planes"; bih.biPlanes
    Form1.Picture2.Print "bits/colour  "; bih.biBitCount
    Form1.Picture2.Print "compression  "; bih.biCompression
    Form1.Picture2.Print "bit size image  "; bih.biSizeImage
    Form1.Picture2.Print "x pixels/metre  "; bih.biXPelsPerMeter
    Form1.Picture2.Print "y pixels/metre  "; bih.biYPelsPerMeter
    Form1.Picture2.Print "colours used  "; bih.biClrUsed
    Form1.Picture2.Print "colour important  "; bih.biClrImportant

'go through process of displaying image on Form1
    du% = CreateDIBitmap(Form1.hDC, bih, CBM_INIT, lbits, bi, 0)
    DIBFree (ldib) 'free up DIB memory ready for next JPEG image
    hm% = CreateCompatibleDC(Form1.hDC)
    holdmap% = SelectObject(hm%, du%)
    src& = &HCC0020 ' constant needed for Stretchblit
    'main display Windows API function
    m% = StretchBlt%(Form1.hDC, 90, 30, 400, 300, hm%, 0, 0, bih.biwidth, bih.biheight, src&)
    dummy% = SelectObject(hm%, holdmap%)
    dummy% = DeleteObject(du%)
    dummy% = DeleteDC(hm%)
    
    Form1.Picture3.Print du% 'diagnostics
    Form1.Picture3.Print holdmap% 'diagnostics
    Form1.Picture3.Print m% 'diagnostics

End Sub
