1000 ' MINES - Exploding Mines Game
1010 ' -written for PC Plus 103 - Wilf's Programming Workshop
1020 ' Uploaded by TST for DarkCorner BBS
1030 ' process stack
1040 DIM MYSTACK%(200, 2)
1050 ' current palette
1060 DIM COLOURS%(15)
1070 ' icons (once read and displayed)
1080 DIM RECESSED%(92)
1090 DIM ONE%(92), TWO%(92), THREE%(92), FOUR%(92)
1100 DIM FIVE%(92), SIX%(92), SEVEN%(92), EIGHT%(92)
1110 DIM MINE%(92), BADMINE%(92)
1120 DIM QUERY%(92), FLAG%(92), TURF%(92)
1130 ' NUMBERS% is used for selecting random integers
1140 DIM NUMBERS%(256)
1150 ' BOARD% values:
1160 '  initially:
1170 '   0 = unoccupied cell
1180 '   1 = mine
1190 '  thereafter:
1200 '   0 = unopened cell
1210 '   1 = opened cell
1220 '   (note: first coordinate is ROW, second is COLUMN)
1230 DIM BOARD%(17, 17)
1240 ' FLAGS% values:
1250 '   0 = not marked
1260 '   1 = flag
1270 '   2 = query
1280 ' Borders exist (rows and columns 0 and 17)
1290 '   (note: first coordinate is ROW, second is COLUMN)
1300 DIM FLAGS%(16, 16)
1310 ' SUM% values
1320 ' 0-8 = surrounding squares with mines
1330 '   9 = mine
1340 '   (note: first coordinate is ROW, second is COLUMN)
1350 DIM SUM%(16, 16)
1360 '*************************************************************
1370 '**                                                         **
1380 '**    ACTUAL START OF EXECUTABLE CODE                      **
1390 '**                                                         **
1400 '*************************************************************
1410 KEY OFF: SCREEN 9: CLS : RANDOMIZE TIMER
1420 WHILE 1
1430  MINE%(0) = 0
1440  COLOR 14, 0
1450  LOCATE 1, 31: PRINT "ͻ  ͻ  ";
1460  LOCATE 2, 31: PRINT "         ͻ";
1470  LOCATE 3, 31: PRINT "         ͼ";
1480  EXPLODED% = 0
1490  OPENED% = 0
1500  WRONG% = 0
1510 ' prime the NUMBERS% array with figures to use
1520  FOR I% = 1 TO 256
1530   NUMBERS%(I%) = I%
1540  NEXT
1550 ' clear the board itself
1560  FOR I% = 0 TO 17
1570   FOR J% = 0 TO 17
1580    BOARD%(I%, J%) = 0
1590   NEXT
1600  NEXT
1610 ' fetch 40 random numbers and use them to place mines in cells
1620  FOR I% = 256 TO 217 STEP -1
1630   J% = INT(RND * I%) + 1
1640   K% = NUMBERS%(J%)
1650   I2% = INT((K% - 1) / 16) + 1
1660   J2% = (K% - 1) MOD 16 + 1
1670   BOARD%(I2%, J2%) = 1
1680   NUMBERS%(J%) = NUMBERS%(I%)
1690  NEXT
1700 ' determine how far each cell is from a mine - via SUM()
1710  FOR I% = 1 TO 16
1720   FOR J% = 1 TO 16
1730    SUM%(I%, J%) = 0
1740    FOR I2% = I% - 1 TO I% + 1
1750     FOR J2% = J% - 1 TO J% + 1
1760      SUM%(I%, J%) = SUM%(I%, J%) + BOARD%(I2%, J2%)
1770     NEXT
1780    NEXT
1790    IF BOARD%(I%, J%) = 1 THEN SUM%(I%, J%) = 9
1800   NEXT
1810  NEXT
1820 ' clear the board, recording all cells as unopened
1830 ' also clear record of flag locations
1840  FOR I% = 1 TO 16
1850   FOR J% = 1 TO 16
1860    BOARD%(I%, J%) = 0
1870    FLAGS%(I%, J%) = 0
1880   NEXT
1890  NEXT
1900 ' create the border of the board array
1910  FOR I% = 0 TO 17
1920   BOARD%(0, I%) = 1
1930   BOARD%(17, I%) = 1
1940   BOARD%(I%, 0) = 1
1950   BOARD%(I%, 17) = 1
1960  NEXT
1970 ' fetch the number of EMPTY cells (not next to any mine) as NULCT%;
1980 ' in case none exist, fetch number of cells next to only ONE mine
1990  NULCT% = 0
2000  ONECT% = 0
2010  FOR I% = 1 TO 16
2020   FOR J% = 1 TO 16
2030    IF SUM%(I%, J%) = 0 THEN NULCT% = NULCT% + 1
2040    IF SUM%(I%, J%) = 1 THEN ONECT% = ONECT% + 1
2050   NEXT
2060  NEXT
2070 ' establish whether we are looking for '1' cells or EMPTY cells
2080  LOOKFOR% = 0
2090  IF NULCT% = 0 THEN LOOKFOR% = 1: NULCT% = ONECT%
2100 ' create a nice surround for the board
2110  LINE (140, 55)-(500, 325), 15, BF
2120  LINE (143, 57)-(497, 323), 7, BF
2130  LINE (140, 55)-(500, 56), 15, BF
2140  LINE (140, 55)-(142, 325), 15, BF
2150  LINE (498, 57)-(500, 325), 8, BF
2160  LINE (142, 324)-(500, 325), 8, BF
2170  PSET (140, 55), 8
2180  PSET (141, 56), 8
2190  PSET (142, 57), 8
2200  PSET (500, 55), 8
2210  PSET (499, 56), 8
2220  PSET (500, 56), 8
2230  PSET (142, 324), 8
2240  PSET (141, 325), 8
2250  PSET (142, 325), 8
2260  PSET (498, 325), 0
2270  PSET (499, 326), 0
2280 ' put up the legend
2290 ' (first, clear the old legend from the screen)
2300  GOSUB 4700
2310  LOCATE 10, 1
2320  PRINT CHR$(24); " "; ; CHR$(25); " "; CHR$(26); " "; CHR$(27);
2330  LOCATE 11, 1: PRINT "spc: open cell";
2340  LOCATE 12, 1: PRINT "F  : flag toggle";
2350  LOCATE 13, 1: PRINT "?  : query toggle";
2360  LOCATE 14, 1: PRINT "Esc: quit game";
2370 ' put the TURF icon all over the board
2380  NBRICON% = 13
2390  FOR X% = 160 TO 460 STEP 20
2400   FOR Y% = 70 TO 295 STEP 15
2410 ' (fetch and display the turf icon)
2420    GOSUB 5210
2430   NEXT
2440  NEXT
2450 ' get a random number not more than NULCT% and use it
2460 ' to find an appropriate open cell to start
2470  CHOICE% = INT(RND * NULCT%) + 1
2480  I% = 0: J% = 16
2490  FOR K% = 1 TO CHOICE%
2500   L% = 1
2510   WHILE L%
2520    J% = J% + 1
2530    IF J% = 17 THEN I% = I% + 1: J% = 1
2540    IF SUM%(I%, J%) = LOOKFOR% THEN L% = 0
2550   WEND
2560  NEXT
2570 ' display the number of flags
2580  NBRICON% = 12
2590  X% = 140: Y% = 28
2600 ' (fetch and display the flag icon)
2610  GOSUB 5210
2620  NBRFLAGS% = 40
2630  LOCATE 3, 22: PRINT USING "##"; NBRFLAGS%;
2640 ' display the startoff area
2650  BOARD%(I%, J%) = 1
2660  ROW% = I%
2670  COL% = J%
2680 ' (establish the correct icon for the cell)
2690  GOSUB 5100
2700 ' (mark the cell with yellow - it's the cursor cell now)
2710  GOSUB 4940
2720 ' put this first cell into the stack
2730  MYSTACK%(1, 1) = I%
2740  MYSTACK%(1, 2) = J%
2750  STACKAT% = 1
2760 ' repeat until 'exploded': mine found or game ended
2770  WHILE EXPLODED% = 0
2780 ' keep going until the stack is exhausted
2790 ' (there may be several cells to be opened simultaneously)
2800   WHILE STACKAT%
2810    NOWX% = MYSTACK%(STACKAT%, 1)
2820    NOWY% = MYSTACK%(STACKAT%, 2)
2830    STACKAT% = STACKAT% - 1
2840 ' mark the cell as open
2850    BOARD%(NOWX%, NOWY%) = 1
2860    OPENED% = OPENED% + 1
2870 ' if all free areas are opened, automatically flag all mines
2880    BRAKESR1% = OPENED%
2890    WHILE BRAKESR1% = 216
2900     EXPLODED% = 1
2910     FOR ISR1% = 1 TO 16
2920      FOR JSR1% = 1 TO 16
2930       IF SUM%(ISR1%, JSR1%) = 9 THEN FLAGS%(ISR1%, JSR1%) = 1
2940      NEXT
2950     NEXT
2960     NBRFLAGS% = 0
2970     LOCATE 3, 22: PRINT USING "##"; 0;
2980     BRAKESR1% = 0
2990    WEND
3000 ' if the current cell is not near a mine, put all its eligible
3010 ' neighbours into the stack for analysis
3020    BRAKESR1% = SUM%(NOWX%, NOWY%)
3030    WHILE BRAKESR1% = 0
3040     BRAKESR1% = 1
3050     FOR ISR1% = NOWX% - 1 TO NOWX% + 1
3060      FOR JSR1% = NOWY% - 1 TO NOWY% + 1
3070       WHILE BOARD%(ISR1%, JSR1%) = 0
3080        BOARD%(ISR1%, JSR1%) = 1
3090        STACKAT% = STACKAT% + 1
3100        MYSTACK%(STACKAT%, 1) = ISR1%
3110        MYSTACK%(STACKAT%, 2) = JSR1%
3120        NBRICON% = SUM%(ISR1%, JSR1%)
3130        X% = 140 + 20 * JSR1%
3140        Y% = 55 + 15 * ISR1%
3150 ' (fetch and display the correct icon)
3160        GOSUB 5210
3170       WEND
3180      NEXT
3190     NEXT
3200    WEND
3210   WEND
3220 ' get a keystroke
3230   X$ = "HH"
3240 ' (read a keystroke only if not fully populated)
3250   IF NBRFLAGS% + WRONG% = 0 THEN OPENED% = 216: EXPLODED% = 1
3260   IF OPENED% <> 216 THEN GOSUB 4800
3270 ' Esc was keyed: force premature end
3280   IF ASC(X$) = 27 THEN EXPLODED% = 1
3290 ' a movement key was pressed: alter cursor position
3300   WHILE LEN(X$) = 2
3310    X$ = MID$(X$, 2)
3320 ' reset the icon in the cell
3330 ' (fetch and display the appropriate icon)
3340    GOSUB 5100
3350    IF X$ = "H" THEN ROW% = ROW% - 1
3360    IF X$ = "P" THEN ROW% = ROW% + 1
3370    IF X$ = "K" THEN COL% = COL% - 1
3380    IF X$ = "M" THEN COL% = COL% + 1
3390    IF ROW% = 0 THEN ROW% = 1
3400    IF ROW% = 17 THEN ROW% = 16
3410    IF COL% = 0 THEN COL% = 1
3420    IF COL% = 17 THEN COL% = 16
3430 ' (change the "new" current cell to yellow)
3440    GOSUB 4940
3450    X$ = "X"
3460   WEND
3470 ' a space was keyed: open the cell (if unopened)
3480   IF ASC(X$) = 13 THEN X$ = " "
3490   WHILE X$ = " "
3500    BRAKE% = BOARD%(ROW%, COL%)
3510    WHILE BRAKE% = 0 AND FLAGS%(ROW%, COL%) = 0
3520     BOARD%(ROW%, COL%) = 1
3530 ' (display the correct icon - and mark it with yellow)
3540     GOSUB 5100
3550     GOSUB 4940
3560 ' put the current cell into the stack for analysis
3570     STACKAT% = STACKAT% + 1
3580     MYSTACK%(STACKAT%, 1) = ROW%
3590     MYSTACK%(STACKAT%, 2) = COL%
3600     BRAKE% = 1
3610    WEND
3620    X$ = "X"
3630   WEND
3640 ' a question mark was keyed: mark the cell (if unopened)
3650   IF INSTR("/Q", X$) THEN X$ = "?"
3660   WHILE X$ = "?"
3670    BRAKE% = BOARD%(ROW%, COL%)
3680    WHILE BRAKE% = 0
3690     BRAKE% = 1
3700 ' Note: QUERY overrides as following:
3710 '          UNMARKED cells (0)   become   QUERY    (2)
3720 '          FLAGGED cells  (1)   become   QUERY    (2)
3730 '          QUERY cells    (2)   become   UNMARKED (0)
3740     X$ = MID$("220", FLAGS%(ROW%, COL%) + 1, 1)
3750 ' reclaim a withdrawn flag: was it wrongly placed?
3760     WHILE FLAGS%(ROW%, COL%) = 1
3770      FLAGS%(ROW%, COL%) = 2
3780      NBRFLAGS% = NBRFLAGS% + 1
3790      IF SUM%(ROW%, COL%) <> 9 THEN WRONG% = WRONG% - 1
3800     WEND
3810     FLAGS%(ROW%, COL%) = ASC(X$) - 48
3820 ' (display the correct icon - and mark it with yellow)
3830     GOSUB 5100
3840     GOSUB 4940
3850    WEND
3860    X$ = "X"
3870    LOCATE 3, 22: PRINT USING "##"; NBRFLAGS%;
3880   WEND
3890 ' an "F" was keyed: toggle the flag (if unopened)
3900   WHILE X$ = "F"
3910    BRAKE% = BOARD%(ROW%, COL%)
3920    WHILE BRAKE% = 0
3930     BRAKE% = 1
3940 ' Note: FLAG overrides as following:
3950 '          UNMARKED cells (0)   become   FLAGGED  (1)
3960 '          FLAGGED cells  (1)   become   UNMARKED (0)
3970 '          QUERY cells    (2)   become   FLAGGED  (1)
3980     X$ = MID$("404", FLAGS%(ROW%, COL%) + 1, 1)
3990 ' place a flag: is it wrongly placed?
4000 ' (deal with case when all flags have gone)
4010     WHILE X$ = "4"
4020      X$ = "3"
4030      IF NBRFLAGS% = 0 THEN X$ = CHR$(48 + FLAGS%(ROW%, COL%))
4040     WEND
4050     WHILE X$ = "3"
4060      X$ = "1"
4070      NBRFLAGS% = NBRFLAGS% - 1
4080      IF SUM%(ROW%, COL%) <> 9 THEN WRONG% = WRONG% + 1
4090     WEND
4100 ' ..or remove a flag: was it wrongly placed?
4110     WHILE FLAGS%(ROW%, COL%) = 1
4120      FLAGS%(ROW%, COL%) = 4
4130      NBRFLAGS% = NBRFLAGS% + 1
4140      IF SUM%(ROW%, COL%) <> 9 THEN WRONG% = WRONG% - 1
4150     WEND
4160     FLAGS%(ROW%, COL%) = ASC(X$) - 48
4170 ' (display the correct icon - and mark it with yellow)
4180     GOSUB 5100
4190     GOSUB 4940
4200    WEND
4210    X$ = "X"
4220    LOCATE 3, 22: PRINT USING "##"; NBRFLAGS%;
4230   WEND
4240  WEND
4250 '*************************************************************
4260 '**                                                         **
4270 '**    HERE IS WHERE IT ALL ENDS                            **
4280 '**                                                         **
4290 '*************************************************************
4300 ' display all the mines
4310 ' (we can destroy the values, because the game is ended!)
4320  NBRICON% = 9
4330  FOR I% = 1 TO 16
4340   FOR J% = 1 TO 16
4350    X% = 140 + 20 * I%
4360    Y% = 55 + 15 * J%
4370    BRAKE% = FLAGS%(J%, I%)
4380    WHILE BRAKE% = 1
4390     NBRICON% = 10
4400 ' (if appropriate, display a 'bad mine' icon)
4410     IF SUM%(J%, I%) <> 9 THEN GOSUB 5210
4420     BRAKE% = 0
4430    WEND
4440    WHILE SUM%(J%, I%) = 9
4450     IF FLAGS%(J%, I%) = 1 THEN NBRICON% = 12 ELSE NBRICON% = 9
4460 ' (display either flag or mine icon)
4470     GOSUB 5210
4480     SUM%(J%, I%) = 0
4490    WEND
4500   NEXT
4510  NEXT
4520 ' (mark the current cell with yellow)
4530  GOSUB 4940
4540 ' (clear the legend - prepare for a new one)
4550  GOSUB 4700
4560  LOCATE 10, 1: PRINT "ENTER: new puzzle";
4570  LOCATE 11, 1: PRINT "ESC  : quit";
4580  BEEP
4590  IF MINE%(0) = 0 THEN LOCATE 5, 32: PRINT " CONGRATULATIONS! ";
4600  IF MINE%(0) THEN LOCATE 5, 29: PRINT " BOOM!  SORRY, YOU LOSE ";
4610 ' get a final keystroke to finish
4620 ' ESC retires, ENTER starts new puzzle
4630  X$ = "X"
4640  WHILE ASC(X$) <> 13
4650 ' (read a keystroke)
4660   GOSUB 4800
4670   IF ASC(X$) = 27 THEN SYSTEM
4680  WEND
4690 WEND
4700 '*************************************************************
4710 '**                                                         **
4720 '**    S/R to clear the legend on the side of the screen    **
4730 '**                                                         **
4740 '*************************************************************
4750 FOR I% = 10 TO 14
4760  LOCATE I%, 1
4770  PRINT SPACE$(17);
4780 NEXT
4790 RETURN
4800 '*************************************************************
4810 '**                                                         **
4820 '**    S/R to read a keystroke                              **
4830 '**                                                         **
4840 '*************************************************************
4850 X$ = "X"
4860 WHILE LEN(X$)
4870  X$ = INKEY$
4880 WEND
4890 WHILE LEN(X$) = 0
4900  X$ = INKEY$
4910 WEND
4920 IF ASC(X$) > 96 THEN X$ = CHR$(ASC(X$) - 32)
4930 RETURN
4940 '*************************************************************
4950 '**                                                         **
4960 '**    S/R to change the white in a cell to bright yellow   **
4970 '**                                                         **
4980 '*************************************************************
4990 X% = 140 + 20 * COL%
5000 Y% = 55 + 15 * ROW%
5010 FOR ISR1% = 1 TO 20
5020  FOR JSR1% = 1 TO 15
5030   NSR1% = X% + ISR1% - 1
5040   OSR1% = Y% + JSR1% - 1
5050   PSR1% = POINT(NSR1%, OSR1%)
5060   IF PSR1% = 7 THEN PSET (NSR1%, OSR1%), 14
5070  NEXT
5080 NEXT
5090 RETURN
5100 '*************************************************************
5110 '**                                                         **
5120 '**    S/R to display the correct icon for a cell           **
5130 '**                                                         **
5140 '*************************************************************
5150 NBRICON% = SUM%(ROW%, COL%)
5160 IF BOARD%(ROW%, COL%) = 0 THEN NBRICON% = 13 - FLAGS%(ROW%, COL%)
5170 X% = 140 + 20 * COL%
5180 Y% = 55 + 15 * ROW%
5190 '******                                                 ******
5200 '******   FALL THROUGH into the following subroutine    ******
5210 '*************************************************************
5220 '**                                                         **
5230 '**    S/R to fetch and display a particular icon           **
5240 '**                                                         **
5250 '*************************************************************
5260 ' input NBRICON%
5270 '        0 = recessed blank
5280 '        1 = recessed 1
5290 '        : = :::::::: :
5300 '        : = :::::::: :
5310 '        8 = recessed 8
5320 '        9 = mine
5330 '       10 = false mine
5340 '       11 = query
5350 '       12 = flag
5360 '       13 = turf
5370 '
5380 ' (note: uses X% and Y% coordinates
5390 '
5400 IF NBRICON% = 0 THEN BRAKESR2% = RECESSED%(0)
5410 IF NBRICON% = 1 THEN BRAKESR2% = ONE%(0)
5420 IF NBRICON% = 2 THEN BRAKESR2% = TWO%(0)
5430 IF NBRICON% = 3 THEN BRAKESR2% = THREE%(0)
5440 IF NBRICON% = 4 THEN BRAKESR2% = FOUR%(0)
5450 IF NBRICON% = 5 THEN BRAKESR2% = FIVE%(0)
5460 IF NBRICON% = 6 THEN BRAKESR2% = SIX%(0)
5470 IF NBRICON% = 7 THEN BRAKESR2% = SEVEN%(0)
5480 IF NBRICON% = 8 THEN BRAKESR2% = EIGHT%(0)
5490 IF NBRICON% = 9 THEN BRAKESR2% = MINE%(0)
5500 IF NBRICON% = 10 THEN BRAKESR2% = BADMINE%(0)
5510 IF NBRICON% = 11 THEN BRAKESR2% = QUERY%(0)
5520 IF NBRICON% = 12 THEN BRAKESR2% = FLAG%(0)
5530 IF NBRICON% = 13 THEN BRAKESR2% = TURF%(0)
5540 WHILE BRAKESR2% = 0
5550  BRAKESR2% = 1
5560  IF NBRICON% = 0 THEN RESTORE 6260
5570  IF NBRICON% = 1 THEN RESTORE 6520
5580  IF NBRICON% = 2 THEN RESTORE 6780
5590  IF NBRICON% = 3 THEN RESTORE 7040
5600  IF NBRICON% = 4 THEN RESTORE 7300
5610  IF NBRICON% = 5 THEN RESTORE 7560
5620  IF NBRICON% = 6 THEN RESTORE 7820
5630  IF NBRICON% = 7 THEN RESTORE 8080
5640  IF NBRICON% = 8 THEN RESTORE 8340
5650  IF NBRICON% = 9 THEN RESTORE 8600
5660  IF NBRICON% = 10 THEN RESTORE 8860
5670  IF NBRICON% = 11 THEN RESTORE 9120
5680  IF NBRICON% = 12 THEN RESTORE 9380
5690  IF NBRICON% = 13 THEN RESTORE 9640
5700  READ ISR2%
5710  FOR JSR2% = 1 TO ISR2%
5720   READ KSR2%
5730   COLOURS%(JSR2% - 1) = KSR2%
5740  NEXT
5750  FOR ISR2% = 1 TO 15
5760   FOR JSR2% = 1 TO 20
5770    READ KSR2%
5780    KSR2% = COLOURS%(KSR2%)
5790    NSR2% = X% + JSR2% - 1
5800    OSR2% = Y% + ISR2% - 1
5810    PSET (NSR2%, OSR2%), KSR2%
5820   NEXT
5830  NEXT
5840  XX% = X% + 19
5850  YY% = Y% + 14
5860  IF NBRICON% = 0 THEN GET (X%, Y%)-(XX%, YY%), RECESSED%
5870  IF NBRICON% = 1 THEN GET (X%, Y%)-(XX%, YY%), ONE%
5880  IF NBRICON% = 2 THEN GET (X%, Y%)-(XX%, YY%), TWO%
5890  IF NBRICON% = 3 THEN GET (X%, Y%)-(XX%, YY%), THREE%
5900  IF NBRICON% = 4 THEN GET (X%, Y%)-(XX%, YY%), FOUR%
5910  IF NBRICON% = 5 THEN GET (X%, Y%)-(XX%, YY%), FIVE%
5920  IF NBRICON% = 6 THEN GET (X%, Y%)-(XX%, YY%), SIX%
5930  IF NBRICON% = 7 THEN GET (X%, Y%)-(XX%, YY%), SEVEN%
5940  IF NBRICON% = 8 THEN GET (X%, Y%)-(XX%, YY%), EIGHT%
5950  IF NBRICON% = 9 THEN GET (X%, Y%)-(XX%, YY%), MINE%
5960  IF NBRICON% = 10 THEN GET (X%, Y%)-(XX%, YY%), BADMINE%
5970  IF NBRICON% = 11 THEN GET (X%, Y%)-(XX%, YY%), QUERY%
5980  IF NBRICON% = 12 THEN GET (X%, Y%)-(XX%, YY%), FLAG%
5990  IF NBRICON% = 13 THEN GET (X%, Y%)-(XX%, YY%), TURF%
6000 WEND
6010 IF NBRICON% = 0 THEN PUT (X%, Y%), RECESSED%, PSET
6020 IF NBRICON% = 1 THEN PUT (X%, Y%), ONE%, PSET
6030 IF NBRICON% = 2 THEN PUT (X%, Y%), TWO%, PSET
6040 IF NBRICON% = 3 THEN PUT (X%, Y%), THREE%, PSET
6050 IF NBRICON% = 4 THEN PUT (X%, Y%), FOUR%, PSET
6060 IF NBRICON% = 5 THEN PUT (X%, Y%), FIVE%, PSET
6070 IF NBRICON% = 6 THEN PUT (X%, Y%), SIX%, PSET
6080 IF NBRICON% = 7 THEN PUT (X%, Y%), SEVEN%, PSET
6090 IF NBRICON% = 8 THEN PUT (X%, Y%), EIGHT%, PSET
6100 IF NBRICON% = 9 THEN PUT (X%, Y%), MINE%, PSET
6110 IF NBRICON% = 10 THEN PUT (X%, Y%), BADMINE%, PSET
6120 IF NBRICON% = 11 THEN PUT (X%, Y%), QUERY%, PSET
6130 IF NBRICON% = 12 THEN PUT (X%, Y%), FLAG%, PSET
6140 IF NBRICON% = 13 THEN PUT (X%, Y%), TURF%, PSET
6150 ' if a mine is shown, game is finished!
6160 WHILE NBRICON% = 9
6170  EXPLODED% = 1
6180  NBRICON% = 0
6190 WEND
6200 RETURN
6210 '*************************************************************
6220 '**                                                         **
6230 '**    ICON IMAGES (in DATA form) for initial display       **
6240 '**                                                         **
6250 '*************************************************************
6260 '******************
6270 '**              **
6280 '**   RECESSED   **
6290 '**              **
6300 '******************
6310 ' number of colours:
6320  DATA  3
6330 ' colour palette:
6340  DATA  7, 8, 15
6350 ' image:
6360  DATA  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1
6370  DATA  1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2
6380  DATA  1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2
6390  DATA  1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2
6400  DATA  1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2
6410  DATA  1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2
6420  DATA  1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2
6430  DATA  1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2
6440  DATA  1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2
6450  DATA  1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2
6460  DATA  1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2
6470  DATA  1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2
6480  DATA  1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2
6490  DATA  1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2
6500  DATA  1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2
6510 '***************
6520 '******************
6530 '**              **
6540 '**  RECESSED 1  **
6550 '**              **
6560 '******************
6570 ' number of colours:
6580  DATA  6
6590 ' colour palette:
6600  DATA  7, 8, 0, 15, 5, 13
6610 ' image:
6620  DATA  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1
6630  DATA  1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3
6640  DATA  1, 1, 0, 0, 0, 0, 0, 0, 4, 4, 4, 0, 0, 0, 0, 0, 0, 0, 0, 3
6650  DATA  1, 1, 0, 0, 0, 0, 0, 4, 4, 4, 4, 5, 0, 0, 0, 0, 0, 0, 0, 3
6660  DATA  1, 1, 0, 0, 0, 0, 4, 4, 4, 4, 4, 5, 0, 0, 0, 0, 0, 0, 0, 3
6670  DATA  1, 1, 0, 0, 0, 0, 0, 5, 5, 4, 4, 5, 0, 0, 0, 0, 0, 0, 0, 3
6680  DATA  1, 1, 0, 0, 0, 0, 0, 0, 0, 4, 4, 5, 0, 0, 0, 0, 0, 0, 0, 3
6690  DATA  1, 1, 0, 0, 0, 0, 0, 0, 0, 4, 4, 5, 0, 0, 0, 0, 0, 0, 0, 3
6700  DATA  1, 1, 0, 0, 0, 0, 0, 0, 0, 4, 4, 5, 0, 0, 0, 0, 0, 0, 0, 3
6710  DATA  1, 1, 0, 0, 0, 0, 0, 0, 0, 4, 4, 5, 0, 0, 0, 0, 0, 0, 0, 3
6720  DATA  1, 1, 0, 0, 0, 0, 0, 0, 0, 4, 4, 5, 0, 0, 0, 0, 0, 0, 0, 3
6730  DATA  1, 1, 0, 0, 0, 0, 0, 4, 4, 4, 4, 4, 4, 0, 0, 0, 0, 0, 0, 3
6740  DATA  1, 1, 0, 0, 0, 0, 0, 4, 4, 4, 4, 4, 4, 5, 0, 0, 0, 0, 0, 3
6750  DATA  1, 1, 0, 0, 0, 0, 0, 0, 5, 5, 5, 5, 5, 5, 0, 0, 0, 0, 0, 3
6760  DATA  1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3
6770 '***************
6780 '******************
6790 '**              **
6800 '**  RECESSED 2  **
6810 '**              **
6820 '******************
6830 ' number of colours:
6840  DATA  5
6850 ' colour palette:
6860  DATA  7, 1, 8, 9, 15
6870 ' image:
6880  DATA  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2
6890  DATA  2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4
6900  DATA  2, 2, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 4
6910  DATA  2, 2, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 4
6920  DATA  2, 2, 0, 0, 0, 1, 1, 3, 3, 3, 3, 3, 3, 1, 1, 3, 0, 0, 0, 4
6930  DATA  2, 2, 0, 0, 0, 0, 3, 3, 0, 0, 0, 0, 0, 1, 1, 3, 0, 0, 0, 4
6940  DATA  2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 3, 0, 0, 0, 4
6950  DATA  2, 2, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 3, 3, 3, 0, 0, 0, 4
6960  DATA  2, 2, 0, 0, 0, 0, 0, 1, 1, 1, 3, 3, 3, 3, 0, 0, 0, 0, 0, 4
6970  DATA  2, 2, 0, 0, 0, 0, 1, 1, 1, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 4
6980  DATA  2, 2, 0, 0, 0, 1, 1, 1, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4
6990  DATA  2, 2, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 4
7000  DATA  2, 2, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 0, 0, 0, 4
7010  DATA  2, 2, 0, 0, 0, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0, 0, 4
7020  DATA  2, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4
7030 '***************
7040 '******************
7050 '**              **
7060 '**  RECESSED 3  **
7070 '**              **
7080 '******************
7090 ' number of colours:
7100  DATA  4
7110 ' colour palette:
7120  DATA  7, 8, 15, 2
7130 ' image:
7140  DATA  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1
7150  DATA  1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2
7160  DATA  1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 2
7170  DATA  1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 2
7180  DATA  1, 1, 0, 0, 1, 1, 3, 3, 3, 3, 3, 3, 1, 1, 1, 0, 0, 0, 0, 2
7190  DATA  1, 1, 0, 0, 0, 3, 3, 0, 0, 0, 0, 0, 1, 1, 1, 3, 0, 0, 0, 2
7200  DATA  1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 3, 3, 0, 0, 0, 2
7210  DATA  1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 3, 3, 0, 0, 0, 0, 2
7220  DATA  1, 1, 0, 0, 0, 0, 0, 0, 0, 3, 3, 3, 1, 1, 0, 0, 0, 0, 0, 2
7230  DATA  1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2
7240  DATA  1, 1, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 3, 0, 0, 0, 2
7250  DATA  1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 0, 0, 0, 2
7260  DATA  1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 3, 3, 0, 0, 0, 0, 2
7270  DATA  1, 1, 0, 0, 0, 0, 0, 3, 3, 3, 3, 3, 3, 3, 0, 0, 0, 0, 0, 2
7280  DATA  1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2
7290 '***************
7300 '******************
7310 '**              **
7320 '**  RECESSED 4  **
7330 '**              **
7340 '******************
7350 ' number of colours:
7360  DATA  5
7370 ' colour palette:
7380  DATA  7, 4, 8, 15, 12
7390 ' image:
7400  DATA  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2
7410  DATA  2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3
7420  DATA  2, 2, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 3
7430  DATA  2, 2, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 4, 0, 0, 0, 0, 0, 3
7440  DATA  2, 2, 0, 0, 0, 0, 1, 1, 1, 4, 1, 1, 1, 4, 0, 0, 0, 0, 0, 3
7450  DATA  2, 2, 0, 0, 0, 1, 1, 1, 4, 4, 1, 1, 1, 4, 0, 0, 0, 0, 0, 3
7460  DATA  2, 2, 0, 0, 1, 1, 1, 4, 4, 0, 1, 1, 1, 4, 0, 0, 0, 0, 0, 3
7470  DATA  2, 2, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 3
7480  DATA  2, 2, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 0, 0, 0, 3
7490  DATA  2, 2, 0, 0, 0, 4, 4, 4, 4, 4, 1, 1, 1, 4, 4, 4, 0, 0, 0, 3
7500  DATA  2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 4, 0, 0, 0, 0, 0, 3
7510  DATA  2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 4, 0, 0, 0, 0, 0, 3
7520  DATA  2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 4, 0, 0, 0, 0, 0, 3
7530  DATA  2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 4, 4, 0, 0, 0, 0, 0, 3
7540  DATA  2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3
7550 '***************
7560 '******************
7570 '**              **
7580 '**  RECESSED 5  **
7590 '**              **
7600 '******************
7610 ' number of colours:
7620  DATA  5
7630 ' colour palette:
7640  DATA  7, 5, 8, 13, 15
7650 ' image:
7660  DATA  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2
7670  DATA  2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4
7680  DATA  2, 2, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 4
7690  DATA  2, 2, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 0, 0, 0, 4
7700  DATA  2, 2, 0, 0, 0, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0, 0, 4
7710  DATA  2, 2, 0, 0, 0, 1, 1, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4
7720  DATA  2, 2, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 4
7730  DATA  2, 2, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 4
7740  DATA  2, 2, 0, 0, 0, 0, 3, 3, 3, 3, 3, 3, 3, 1, 1, 3, 0, 0, 0, 4
7750  DATA  2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 3, 0, 0, 0, 4
7760  DATA  2, 2, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 3, 0, 0, 0, 4
7770  DATA  2, 2, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 0, 0, 0, 4
7780  DATA  2, 2, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 0, 0, 0, 4
7790  DATA  2, 2, 0, 0, 0, 0, 0, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0, 0, 0, 4
7800  DATA  2, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4
7810 '***************
7820 '******************
7830 '**              **
7840 '**  RECESSED 6  **
7850 '**              **
7860 '******************
7870 ' number of colours:
7880  DATA  5
7890 ' colour palette:
7900  DATA  7, 6, 8, 15, 14
7910 ' image:
7920  DATA  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2
7930  DATA  2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3
7940  DATA  2, 2, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 3
7950  DATA  2, 2, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 3
7960  DATA  2, 2, 0, 0, 0, 1, 1, 4, 4, 4, 4, 4, 1, 1, 4, 0, 0, 0, 0, 3
7970  DATA  2, 2, 0, 0, 0, 1, 1, 4, 0, 0, 0, 0, 0, 4, 4, 0, 0, 0, 0, 3
7980  DATA  2, 2, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 3
7990  DATA  2, 2, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 3
8000  DATA  2, 2, 0, 0, 0, 1, 1, 4, 4, 4, 4, 4, 1, 1, 4, 0, 0, 0, 0, 3
8010  DATA  2, 2, 0, 0, 0, 1, 1, 4, 0, 0, 0, 0, 1, 1, 4, 0, 0, 0, 0, 3
8020  DATA  2, 2, 0, 0, 0, 1, 1, 4, 0, 0, 0, 0, 1, 1, 4, 0, 0, 0, 0, 3
8030  DATA  2, 2, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 0, 0, 0, 0, 3
8040  DATA  2, 2, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 4, 4, 0, 0, 0, 0, 3
8050  DATA  2, 2, 0, 0, 0, 0, 0, 4, 4, 4, 4, 4, 4, 4, 0, 0, 0, 0, 0, 3
8060  DATA  2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3
8070 '***************
8080 '******************
8090 '**              **
8100 '**  RECESSED 7  **
8110 '**              **
8120 '******************
8130 ' number of colours:
8140  DATA  5
8150 ' colour palette:
8160  DATA  7, 8, 1, 15, 9
8170 ' image:
8180  DATA  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1
8190  DATA  1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3
8200  DATA  1, 1, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 0, 0, 0, 3
8210  DATA  1, 1, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4, 0, 0, 0, 3
8220  DATA  1, 1, 0, 0, 0, 0, 0, 4, 4, 4, 4, 4, 4, 2, 2, 4, 0, 0, 0, 3
8230  DATA  1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 4, 0, 0, 0, 3
8240  DATA  1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 4, 4, 0, 0, 0, 3
8250  DATA  1, 1, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 4, 4, 0, 0, 0, 0, 3
8260  DATA  1, 1, 0, 0, 0, 0, 0, 0, 0, 2, 2, 4, 4, 4, 0, 0, 0, 0, 0, 3
8270  DATA  1, 1, 0, 0, 0, 0, 0, 0, 0, 2, 2, 4, 0, 0, 0, 0, 0, 0, 0, 3
8280  DATA  1, 1, 0, 0, 0, 0, 0, 0, 0, 2, 2, 4, 0, 0, 0, 0, 0, 0, 0, 3
8290  DATA  1, 1, 0, 0, 0, 0, 0, 0, 0, 2, 2, 4, 0, 0, 0, 0, 0, 0, 0, 3
8300  DATA  1, 1, 0, 0, 0, 0, 0, 0, 0, 2, 2, 4, 0, 0, 0, 0, 0, 0, 0, 3
8310  DATA  1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 4, 4, 0, 0, 0, 0, 0, 0, 0, 3
8320  DATA  1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3
8330 '***************
8340 '******************
8350 '**              **
8360 '**  RECESSED 8  **
8370 '**              **
8380 '******************
8390 ' number of colours:
8400  DATA  4
8410 ' colour palette:
8420  DATA  7, 8, 0, 15
8430 ' image:
8440  DATA  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1
8450  DATA  1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3
8460  DATA  1, 1, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 3
8470  DATA  1, 1, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 3
8480  DATA  1, 1, 0, 0, 0, 0, 2, 2, 1, 1, 1, 1, 2, 2, 1, 0, 0, 0, 0, 3
8490  DATA  1, 1, 0, 0, 0, 0, 2, 2, 1, 0, 0, 0, 2, 2, 1, 0, 0, 0, 0, 3
8500  DATA  1, 1, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 1, 1, 0, 0, 0, 0, 3
8510  DATA  1, 1, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 3
8520  DATA  1, 1, 0, 0, 0, 2, 2, 2, 1, 1, 1, 1, 2, 2, 2, 0, 0, 0, 0, 3
8530  DATA  1, 1, 0, 0, 0, 2, 2, 1, 1, 0, 0, 0, 0, 2, 2, 1, 0, 0, 0, 3
8540  DATA  1, 1, 0, 0, 0, 2, 2, 2, 0, 0, 0, 0, 2, 2, 2, 1, 0, 0, 0, 3
8550  DATA  1, 1, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 0, 0, 0, 3
8560  DATA  1, 1, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 1, 1, 0, 0, 0, 0, 3
8570  DATA  1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 3
8580  DATA  1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3
8590 '***************
8600 '******************
8610 '**              **
8620 '**     MINE     **
8630 '**              **
8640 '******************
8650 ' number of colours:
8660  DATA  4
8670 ' colour palette:
8680  DATA  7, 0, 8, 15
8690 ' image:
8700  DATA  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2
8710  DATA  2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3
8720  DATA  2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3
8730  DATA  2, 2, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 3
8740  DATA  2, 2, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 3
8750  DATA  2, 2, 0, 0, 1, 1, 1, 3, 3, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 3
8760  DATA  2, 2, 0, 1, 1, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 3
8770  DATA  2, 2, 0, 1, 1, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 3
8780  DATA  2, 2, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 3
8790  DATA  2, 2, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 3
8800  DATA  2, 2, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 3
8810  DATA  2, 2, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 3
8820  DATA  2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3
8830  DATA  2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3
8840  DATA  2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3
8850 '***************
8860 '******************
8870 '**              **
8880 '** CROSSED MINE **
8890 '**              **
8900 '******************
8910 ' number of colours:
8920  DATA  6
8930 ' colour palette:
8940  DATA  4, 15, 8, 7, 12, 0
8950 ' image:
8960  DATA  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2
8970  DATA  2, 2, 0, 0, 0, 0, 0, 3, 3, 3, 3, 3, 3, 0, 0, 0, 0, 0, 3, 1
8980  DATA  2, 2, 3, 0, 4, 4, 4, 0, 5, 5, 5, 5, 0, 4, 4, 4, 0, 3, 3, 1
8990  DATA  2, 2, 3, 3, 0, 4, 4, 4, 0, 5, 5, 0, 4, 4, 4, 0, 3, 3, 3, 1
9000  DATA  2, 2, 3, 3, 0, 4, 4, 4, 0, 5, 5, 0, 4, 4, 4, 0, 3, 3, 3, 1
9010  DATA  2, 2, 3, 5, 5, 0, 4, 4, 4, 0, 0, 4, 4, 4, 0, 5, 5, 3, 3, 1
9020  DATA  2, 2, 5, 5, 5, 1, 0, 4, 4, 0, 0, 4, 4, 0, 5, 5, 5, 5, 3, 1
9030  DATA  2, 2, 5, 5, 5, 1, 1, 0, 4, 4, 4, 4, 0, 5, 5, 5, 5, 5, 3, 1
9040  DATA  2, 2, 5, 5, 5, 5, 0, 4, 4, 0, 0, 4, 4, 0, 5, 5, 5, 5, 3, 1
9050  DATA  2, 2, 3, 5, 5, 0, 4, 4, 4, 0, 0, 4, 4, 4, 0, 5, 5, 3, 3, 1
9060  DATA  2, 2, 3, 3, 0, 4, 4, 4, 0, 5, 5, 0, 4, 4, 4, 0, 3, 3, 3, 1
9070  DATA  2, 2, 3, 3, 0, 4, 4, 4, 0, 5, 5, 0, 4, 4, 4, 0, 3, 3, 3, 1
9080  DATA  2, 2, 3, 0, 4, 4, 4, 0, 5, 5, 5, 5, 0, 4, 4, 4, 0, 3, 3, 1
9090  DATA  2, 2, 0, 0, 0, 0, 0, 3, 3, 3, 3, 3, 3, 0, 0, 0, 0, 0, 3, 1
9100  DATA  2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1
9110 '***************
9120 '******************
9130 '**              **
9140 '**    QUERY     **
9150 '**              **
9160 '******************
9170 ' number of colours:
9180  DATA  5
9190 ' colour palette:
9200  DATA  7, 15, 4, 8, 12
9210 ' image:
9220  DATA  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1
9230  DATA  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3
9240  DATA  1, 1, 1, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 3, 3
9250  DATA  1, 1, 1, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 2, 0, 0, 0, 0, 3, 3
9260  DATA  1, 1, 1, 0, 0, 2, 2, 2, 4, 4, 4, 4, 2, 2, 4, 0, 0, 0, 3, 3
9270  DATA  1, 1, 1, 0, 0, 0, 4, 4, 4, 0, 0, 0, 2, 2, 4, 0, 0, 0, 3, 3
9280  DATA  1, 1, 1, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 4, 0, 0, 0, 3, 3
9290  DATA  1, 1, 1, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 4, 4, 0, 0, 0, 3, 3
9300  DATA  1, 1, 1, 0, 0, 0, 0, 0, 2, 2, 2, 4, 4, 4, 0, 0, 0, 0, 3, 3
9310  DATA  1, 1, 1, 0, 0, 0, 0, 0, 2, 2, 2, 4, 0, 0, 0, 0, 0, 0, 3, 3
9320  DATA  1, 1, 1, 0, 0, 0, 0, 0, 0, 4, 4, 4, 0, 0, 0, 0, 0, 0, 3, 3
9330  DATA  1, 1, 1, 0, 0, 0, 0, 0, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 3, 3
9340  DATA  1, 1, 1, 0, 0, 0, 0, 0, 2, 2, 2, 4, 0, 0, 0, 0, 0, 0, 3, 3
9350  DATA  1, 1, 1, 0, 0, 0, 0, 0, 0, 4, 4, 4, 0, 0, 0, 0, 0, 0, 3, 3
9360  DATA  1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3
9370 '***************
9380 '******************
9390 '**              **
9400 '**     FLAG     **
9410 '**              **
9420 '******************
9430 ' number of colours:
9440  DATA  6
9450 ' colour palette:
9460  DATA  7, 12, 0, 8, 15, 4
9470 ' image:
9480  DATA  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4
9490  DATA  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 3
9500  DATA  4, 4, 4, 5, 5, 0, 0, 0, 5, 5, 5, 5, 5, 5, 5, 2, 2, 0, 3, 3
9510  DATA  4, 4, 4, 5, 1, 5, 5, 5, 1, 1, 1, 1, 1, 1, 1, 2, 2, 0, 3, 3
9520  DATA  4, 4, 4, 0, 5, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 0, 3, 3
9530  DATA  4, 4, 4, 0, 0, 5, 1, 1, 1, 1, 1, 1, 1, 1, 0, 2, 2, 0, 3, 3
9540  DATA  4, 4, 4, 0, 5, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 0, 3, 3
9550  DATA  4, 4, 4, 5, 5, 1, 1, 1, 1, 1, 1, 1, 5, 5, 5, 2, 2, 0, 3, 3
9560  DATA  4, 4, 4, 0, 0, 5, 5, 5, 5, 5, 5, 5, 0, 0, 0, 2, 2, 0, 3, 3
9570  DATA  4, 4, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 0, 3, 3
9580  DATA  4, 4, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 0, 3, 3
9590  DATA  4, 4, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 0, 3, 3
9600  DATA  4, 4, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 0, 3, 3
9610  DATA  4, 4, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 3
9620  DATA  4, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3
9630 '***************
9640 '******************
9650 '**              **
9660 '**     TURF     **
9670 '**              **
9680 '******************
9690 ' number of colours:
9700  DATA  3
9710 ' colour palette:
9720  DATA  7, 15, 8
9730 ' image:
9740  DATA  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1
9750  DATA  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2
9760  DATA  1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2
9770  DATA  1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2
9780  DATA  1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2
9790  DATA  1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2
9800  DATA  1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2
9810  DATA  1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2
9820  DATA  1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2
9830  DATA  1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2
9840  DATA  1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2
9850  DATA  1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2
9860  DATA  1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2
9870  DATA  1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2
9880  DATA  1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2
9890 '***************

