/*
** PLAYER.H                   Declarations for player data
*/



#ifndef PLAYER_H
#define PLAYER_H



/*
** GrIP Header File
*/
#include "grip.h"



/*
** BUTTON                     Button state structure
*/
typedef struct BUTTON_t
  {
  GRIP_INDEX index;            // Button index
  GRIP_BITFIELD mask;          // Mask: always = 1 << index
  GRIP_VALUE value;            // Current button state
  char name[16];              // Button name
  unsigned short state;       // Structure state
  } BUTTON;



/*
** AXIS                       Axis state structure
*/
typedef struct AXIS_t
  {
  GRIP_INDEX index;            // Axis index
  GRIP_VALUE value;            // Current axis position
  GRIP_VALUE max;              // Maximum axis position
  char name[16];              // Axis name
  unsigned short state;       // Structure state
  } AXIS;



/*
** Structure state for BUTTON and AXIS
*/
#define STATE_INVALID         0
#define STATE_NORMAL          1
#define STATE_SELECT          2



/*
** PLAYER                     Player state + preferences
*/
typedef struct PLAYER_t
  {
  GRIP_SLOT slot;              // Controller slot
  char vendor[16];            // Vendor name for slot
  char product[16];           // Product name for slot

  BUTTON left;                // Left button
  BUTTON right;               // Right button
  AXIS axis;                  // Axis
  GRIP_VALUE pos;              // Slider position

  unsigned short state;       // NORMAL or SELECT only
  } PLAYER;



/*
** Range limits for slider position
*/
#define SLIDER_MIN            0
#define SLIDER_MAX            39
#define SLIDER_MIDDLE         (SLIDER_MAX / 2)



/*
** The players
*/
#define PLAYER_MAX            2
extern PLAYER player[PLAYER_MAX];



/*
** InitPlayer(play, slot)     Load a player's initial conditions
*/
void InitPlayer(int play, GRIP_SLOT slot);



/*
** UpdatePlayer(play)         Update a player according to the controllers
*/
void UpdatePlayer(int play);



#endif /* PLAYER_H */
