/*
** VIDEO.C                    Video routines for vertical blanking, etc
**
** The vertical blank signal is used to indicate when it is safe to redraw
** the screen.  It also provides a constantly paced loop, so that we can
** perform GrIP refreshes at regular intervals.
*/



#ifndef __WATCOMC__



#include "video.h"



/*
** WaitVertBlank()            Wait for the video vertical blanker
*/
void WaitVertBlank(void)
  {
  asm mov dx, 3DAh
  idle:
  asm in al, dx
  asm and al, 08h
  asm jz idle
  }



/*
** CursorOff()                Hide the cursor
*/
void CursorOff(void)
  {
  asm {
    pushf
    cli
    mov dx, 3D4h
    mov al, 0Ah
    out dx, al
    mov dx, 3D5h
    in al, dx
    or al, 20h
    out dx, al
    popf
    }
  }



/*
** CursorOn()                 Show the cursor
*/
void CursorOn(void)
  {
  asm {
    pushf
    cli
    mov dx, 3D4h
    mov al, 0Ah
    out dx, al
    mov dx, 3D5h
    in al, dx
    and al, 0DFh
    out dx, al
    popf
    }
  }



#endif /* __WATCOMC__ */
