/*
** VIDEO.H                    Video routines for vertical blanking, etc
**
** The vertical blank signal is used to indicate when it is safe to redraw
** the screen.  It also provides a constantly paced loop, so that we can
** perform GrIP refreshes at regular intervals.
*/



#ifndef VIDEO_H
#define VIDEO_H



/*
** WaitVertBlank()            Wait for the video vertical blanker
*/
void WaitVertBlank(void);



/*
** CursorOff()                Hide the cursor
*/
void CursorOff(void);



/*
** CursorOn()                 Show the cursor
*/
void CursorOn(void);



#ifdef __WATCOMC__

#pragma aux WaitVertBlank =   \
  "mov dx, 3DAh"              \
  "idle: in al, dx"           \
  "and al, 08h"               \
  "jz idle"                   \
  modify [dx ax];

#pragma aux CursorOff =       \
  "pushf"                     \
  "cli"                       \
  "mov dx, 3D4h"              \
  "mov al, 0Ah"               \
  "out dx, al"                \
  "mov dx, 3D5h"              \
  "in al, dx"                 \
  "or al, 20h"                \
  "out dx, al"                \
  "popf"                      \
  modify [dx ax];

#pragma aux CursorOn =        \
  "pushf"                     \
  "cli"                       \
  "mov dx, 3D4h"              \
  "mov al, 0Ah"               \
  "out dx, al"                \
  "mov dx, 3D5h"              \
  "in al, dx"                 \
  "and al, 0DFh"              \
  "out dx, al"                \
  "popf"                      \
  modify [dx ax];

#endif



#endif /* VIDEO_H */
