// -------------------------------- LANDMAIN.C -----------------------------
// (C) Copyright 1993 bye Jare and JCAB (Javier & Juan Carlos Arevalo Baeza)
// of Iguana/VangeliSTeam

#include <modex.h>
#include <llkey.h>
#include <stdio.h>
#include <string.h>
#include <hex.h>
#include <sincos.h>
#include <vbl.h>
#include <ctype.h>
#include <jclib.h>
#include <lzss3.h>

#include "main2.h"

#define VIEWANGLE 8192 //4096 //8192
#define RAYSPEED  (1<<22)  //22
#define VSCALE 128
#define ZK     1024

#define LANDSIZE 1024

#define RAYLIM1 32
#define RAYLIM2 64
#define RAYLIM3 96
#define RAYLIM4 128
#define RAYLIM5 160

#define RAYLIM RAYLIM5


byte (*YZTable)[256];
byte (*LandHeight)[LANDSIZE];

extern dword XPos, YPos, XInc, YInc;
extern byte  *YZLimit, *YAddr;

extern byte LineStart, LineLimit;

extern void _ShowVLine(void);

dword MyXPos = 0,
      MyYPos = 0;
int MySpeed = 30,
    MyHeight = 0;
int MyAngle = 16384;
int MySpin = 0, MyOldSpin = 0,
    MyBank = 0, MyOldBank = 0;

int Detail = 1;

int LandMinH,
    LandMaxH;

dword VGAPage = 0;

extern volatile byte *L3D_keyup,
                     *L3D_keydn,
                     *L3D_keylt,
                     *L3D_keyrt,
                     *L3D_keyff,
                     *L3D_keybk;

extern void L3D_Init(void);

void ControlKeyboard() {
    while (*L3D_keylt) {
        MyOldSpin = 0;
        if (MySpin > -2000)
            MySpin -= 25;
        // MyAngle -= 20;
        (*L3D_keylt)--;
    }
    while (*L3D_keyrt) {
        MyOldSpin = 0;
        if (MySpin < 2000)
            MySpin += 25;
        //MyAngle += 20;
        (*L3D_keyrt)--;
    }
    while (*L3D_keybk) {
        MyOldBank = 0;
        if (MyBank < 3000)
            MyBank += 20;
        MySpeed -= 1;
        (*L3D_keybk)--;
    }
    while (*L3D_keyff) {
        MyOldBank = 0;
        if (MyBank > -3000)
            MyBank -= 20;
        MySpeed += 1;
        (*L3D_keyff)--;
    }
    while (*L3D_keyup) {
        if (MyHeight > 0)
            MyHeight--;
        (*L3D_keyup)--;
    }
    while (*L3D_keydn) {
        if (MyHeight < (255-LandMaxH))
            MyHeight++;
        (*L3D_keydn)--;
    }
}


void DoLine(int i) {
    XPos = MyXPos+XInc;
    YPos = MyYPos+YInc;

    YZLimit = YZTable[RAYLIM]; //192*256; //64*256;
    YAddr   = VGAPage + ((byte*)_VGAScr)+80*199+i;
    _ShowVLine();
}

void Showl(void) {
    int i;
    int y0, y1;

    FillPage(VGAPage, 200*80, 6);

    y0 = 28-FPMult(160, Sin(MySpin)) - FPMult(100, Sin(MyBank));
    y1 = 28+FPMult(160, Sin(MySpin)) - FPMult(100, Sin(MyBank));
    if (y0 < 0)
        y0 = 0;
    else if (y0 > 55)
        y0 = 55;
    if (y1 < 0)
        y1 = 0;
    else if (y1 > 55)
        y1 = 55;

    if (Detail == 1) {
        outw(0x3C4, 0xC02);
        for (i = 0; i < 80; i++) {
            LineStart = y0+(i*2+1)*(y1-y0)/160; LineLimit = LineStart+200;
            XInc = FPMult(RAYSPEED, Sin(MyAngle-VIEWANGLE+VIEWANGLE*(2*i+1)/80));
            YInc = FPMult(RAYSPEED, Cos(MyAngle-VIEWANGLE+VIEWANGLE*(2*i+1)/80));
            DoLine(i);
        }
        outw(0x3C4, 0x302);
    }

    for (i = 0; i < 80; i++) {
        LineStart = y0+(i*2)*(y1-y0)/160; LineLimit = LineStart+200;
        XInc = FPMult(RAYSPEED, Sin(MyAngle-VIEWANGLE+VIEWANGLE*i/40));
        YInc = FPMult(RAYSPEED, Cos(MyAngle-VIEWANGLE+VIEWANGLE*i/40));
        DoLine(i);
    }
}

/* ***********
 * OK, the C algorithm for _ShowVLine() is this, for archeologism's sake.
 **** THIS IS ABSOLUTELY OUTDATED, but may show the general idea ****

 It doesn't use the depth-step resolution things explained below in the
 YZTable creation, so it simply won't work now.

        byte c;
        int h, j, k;
        h = 0;
        for (k = 0; k < 128; k++) {     // Z coord.
            XPos += XInc;               // Walk through the map.
            YPos += YInc;
                // j is the projected height of the voxel in the map.
                // and c is the color of that voxel.
            j = YZTable[k][LandHeight[(byte)(YPos >> 8)][(byte)(XPos >> 8)]] - h;
            c = LandColors[(byte)(YPos >> 8)][(byte)(XPos >> 8)];
            //j = YZTable[k][((byte*)LandHeight)[(YPos & 0xFF00) + (XPos >> 8)]] - h;
            //c = ((byte*)LandColors)[(YPos & 0xFF00) + (byte)(XPos >> 8)];
            if (j > 199)
                Abort("Error de rango.\r\n");
            while (j > 0) {     // Draw a vertical span with that color
                if (h < 0 || h > 199)
                    Abort("Error vertical.\r\n");
                VGA800x80[199 - h][i] = c;
                h++;
                j--;
            }
        }
        while (h < 200) {
            VGA800x80[199 - h][i] = 0;
            h++;
        }
 ************** */


byte pal[768];
char buf[100];



void LAND_Do() {
    THeapState s;
    int i, j, k, l;
    char key;
    void *v;
    int dvalid = 0;
    dword nframes, nloops;

    VBL_End();

    MARK(s);

/*
    if ((LandHeight = malloc(2*LANDSIZE*LANDSIZE)) == 0) {
        Abort("Error 2 de memoria.\r\n");
    }
    JCLIB_Load("landgnd.dat", LandHeight,          LANDSIZE*LANDSIZE);
    JCLIB_Load("landtop.dat", LandHeight+LANDSIZE, LANDSIZE*LANDSIZE);
*/

    if ((LandHeight = malloc(2*LANDSIZE*LANDSIZE + 100)) == 0) {
        Abort("Error 2 de memoria.\r\n");
    }
    l = JCLIB_Load("landgnd.lz3", (byte*)LandHeight+2*LANDSIZE*LANDSIZE+100-254943, 254943);
    LZSS3_Decompress(LandHeight, (byte*)LandHeight+2*LANDSIZE*LANDSIZE+100-254943, l);
    l = JCLIB_Load("landtop.lz3", (byte*)LandHeight+2*LANDSIZE*LANDSIZE+100-417393, 417393);
    LZSS3_Decompress(LandHeight+LANDSIZE, (byte*)LandHeight+2*LANDSIZE*LANDSIZE+100-417393, l);

    if ((YZTable = malloc(256*256)) == 0)  // Used also as scrap buffer.
        Abort("Error 1 de memoria.\r\n");

        // Create a Z projection table.

    /*************************************
        Basically this table is a projection table:
                YZTable[Z][coord] = 128 + coord/(Z+ZK);
        where ZK is the camera focus distance. Projected values are
        clipped to fit in a single byte. coord can be either X or Y.

        The table is divided in 5 parts, and in each part the Z advances
        in bigger steps than the previous. This allows me to have this table
        reach up to a Z depth of
            1*RAYLIM1 + 2*(RAYLIM2-RAYLIM1) + 3*(RAYLIM3-RAYLIM1)
          + 4*(RAYLIM4-RAYLIM3) + 6*(RAYLIM5-RAYLIM4)
          == a lot far away in the distance.
        As you advance farther, the precision is worse, but as far things
        are smaller, nobody notices.

        The drawing routine fetches a value in the map for each value in
        this table, so it must take this step changes into account. It does,
        by simply advancing the world coordinates by the same proportion.
    */

    l = 0;
    for (i = 0; i < RAYLIM1; i++) {
        for (j = 0; j < 256; j++) {
            k = 128 + (((j-128)*VSCALE*256)/(199*l+ZK));
            YZTable[i][j] = (k < 256)? ((k >= 0)? k:0) : 256;
        }
        l += 1;
    }
    for (; i < RAYLIM2; i++) {
        for (j = 0; j < 256; j++) {
            k = 128 + (((j-128)*VSCALE*256)/(199*l+ZK));
            YZTable[i][j] = (k < 256)? ((k >= 0)? k:0) : 256;
        }
        l += 2;
    }
    for (; i < RAYLIM3; i++) {
        for (j = 0; j < 256; j++) {
            k = 128 + (((j-128)*VSCALE*256)/(199*l+ZK));
            YZTable[i][j] = (k < 256)? ((k >= 0)? k:0) : 256;
        }
        l += 3;
    }
    for (; i < RAYLIM4; i++) {
        for (j = 0; j < 256; j++) {
            k = 128 + (((j-128)*VSCALE*256)/(199*l+ZK));
            YZTable[i][j] = (k < 256)? ((k >= 0)? k:0) : 256;
        }
        l += 4;
    }
    for (; i < RAYLIM5; i++) {
        for (j = 0; j < 256; j++) {
            k = 128 + (((j-128)*VSCALE*256)/(199*l+ZK));
            YZTable[i][j] = (k < 256)? ((k >= 0)? k:0) : 256;
        }
        l += 6;
    }

        // Find out min and max height of map.
    {
        byte *p = (byte*)LandHeight;

        j = k = *p++;
        for (i = 1; i < LANDSIZE*LANDSIZE; i++, p++) {
            if (j < *p)
                j = *p;
            if (k > *p)
                k = *p;
        }
        LandMinH = k;
        LandMaxH = j;
    }

    JCLIB_Load("land.pal", pal, 768);

    key = 0;
    nloops = nframes = 0;
    FillPage(0, 65536, 69);   // Color del agua.
    VBL_Initialize(0);
    v = VBL_FullHandler;
    L3D_Init();

    SetDisplayPage(3*80*200);
    VBL_VSync(0);
    VGAPage = 0;
    DumpPalette(pal, 0, 256);
    memcpy(GlobalScrapPal, pal, 768);
    dvalid = 0;

    do {
        int finc;

        MyXPos += FPMult(finc*(MySpeed<<16), Sin(MyAngle));
        MyYPos += FPMult(finc*(MySpeed<<16), Cos(MyAngle));

        if (MyOldBank == MyBank)
            MyBank -= (MyBank/16);
        MyOldBank = MyBank;
        if (MyOldSpin == MySpin)
            MySpin -= (MySpin/16);
        MyOldSpin = MySpin;
        MyAngle += MySpin;

        Trace(0,0,0);
        finc = VBL_VSync(1);
        nframes += finc;
        nloops++;
        //Trace(0,0,63);
        SetDisplayPage(VGAPage);
        VGAPage += 80*200;
        if (VGAPage >= 3*80*200)
            VGAPage = 0;

        ControlKeyboard();

        Showl();

        if (LLK_Keys[kD]) {
            if (dvalid <= 0)
                Detail ^= 1;
            dvalid  = 1;
        } else if (dvalid > 0)
             dvalid--;

    } while (!LLK_SpacePressed);

    VBL_FullHandler = v;
    RELEASE(s);
}

