/*
			Keys : A demomstration program using my KEYBOARD.C lib.
			Copyright (c) 1995 by Mark C. Williston.
			EMAIL: mwillist@fox.nstn.ca
			Released to the PUBLIC DOMAIN which can be used in any way
			or place you see fit.
			I hope it help anyone! Mail me if it does.
*/

#include <dos.h>
#include <stdio.h>
#include <conio.h>
#include "keyboard.h"

#define TRUE 1
#define FALSE 0


unsigned char ScanCode;         // Scan code of the last key pressed
unsigned char KeyTable[128];    // Table for holding key presses
unsigned char KeyboardStatus=0; // Hold LED status


void	main(void)
{

	int done=FALSE, n;
	unsigned char OldKey=0;    // Used to compare old and new keys

	_setcursortype(_NOCURSOR); // Turn off the cursor
	clrscr();
	BuildTemplate();
	InstallKeyboardInt();

	while(!done)
	{
		if(OldKey != ScanCode)
		{
			OldKey=ScanCode;
			DoKeys();
			if(ScanCode==1)
			{
				done=1;
				while(ScanCode==1);
			}
			if(ScanCode==58)  // Was the CAPS LOCK Pressed?
			{
				KeyboardStatus^=4;  // Toggle CAPS bit
				KeyboardCommand(0xed, KeyboardStatus); // Send STATUS WRITE command
				FlipLites(1);
			}
			if(ScanCode==69)  // Was the NUM LOCK Pressed?
			{
				KeyboardStatus^=2;  // Toggle NUM LOCK bit
				KeyboardCommand(0xed, KeyboardStatus); // Send STATUS WRITE command
				FlipLites(0);
			}
			if(ScanCode==70)  // Was the SCROLL LOCK Pressed?
			{
				KeyboardStatus^=1;  // Toggle SCROLL LOCK bit
				KeyboardCommand(0xed, KeyboardStatus); // Send STATUS WRITE command
				FlipLites(2);
			}
		}
	}

	KeyboardStatus=4; // Start off at Bit 2
	for(n=0; n<30; n++)  // Rotate LEDs just for the heck of it.
	{
		KeyboardCommand(0xed, KeyboardStatus); // Send STATUS WRITE command
		KeyboardStatus>>=1;  // Shift LED bit
		if(KeyboardStatus==0) KeyboardStatus=4; // Back to Bit 2
		delay(100);
	}

	RestoreKeyboardInt();  // Give old Keyboard ISR back to MessyDos
	_setcursortype(_NORMALCURSOR); /* Switch back to the normal cursor */
	clrscr(); // Clear our garbage off screen

}