/*************************************************************************
             TINY CLOCK -- DISPOSABLE DATA
        Copyright (c) 1992-94 by Omega Point, Inc.
--------------------------------------------------------------------------
   This module contains ALL disposable data only.  The marker at the end
   called init_end_data is just a marker to the end of disposable data

   NO CODE CAN BE PUT INTO THIS MODULE, DATA ONLY 
**************************************************************************/


#include "cr.h"


/* Video attributes for signon screen. The last one is for the Clock */

char attrc[]={0x17,0x1E,0x13,0x1F,0x1B,0xA}; /* Color screen attributes */
char attrm[]={0x07,0x0F,0x07,0x07,0x07,0xF}; /* Mono screen attributes  */

/* This is the signon message */

char sms[]= "`0"
	    "`m"
	    "`1     CLOCK  1.24      `0`m"
	    "`2           `0`m"
        "`3  (c) Copyright 1992  `0`m"
	    "`3   Omega Point, Inc.  `0`m"
	    "`2           `0`m"
	    "`4     Written by:      `0`m"
	    "`4      RGL & RVT       `0`m"
	    "`2           `0`m"
	    "`1   Unload: `3CLOCK -r   `0`m"
	    "`n`5";


char already[]="Error - CLOCK already present.`n"
               "Enter CLOCK -R to unload.";

char unloaddone[]="CLOCK has been removed from memory.";
char unloadnot[]="CLOCK could not be removed from memory.";

char _tsr_name[]="CLOCK (C) 1992 OP";


struct cfg_rec config_block = {	/* This record stays in only one module */
	sizeof(config_block),	/* Configuration block size */
	'O','P','C','L',	/* Program ID string */
	100,			/* Version 1.00 */
	};

/***********************************************************
 STORE THIS IMMEDIATELY AFTER THE LAST DISPOSABLE DATA ITEM
************************************************************/

/****  1. Store all install_?? type function pointers into install_list ****/


fp install_list[]={install_tsc};  /* Only tiny scheduler used */


/****  2. Put Marker for the end-of-init-data (must be = NONZERO) ****/

word init_data_end=1;

/************************************************************************/

