/*
 * PROJECT:             FLI/FLC animation player
 *
 * AUTHOR:              Ivo Bosticky
 *
 * COMPILE NOTES:       Use wmake.
 *
 * UPDATES:
 *	20-3-1995 Modified for use in 32-bit flat memory compiler
 *
 */


#include <iostream.h>
#include <dos.h>
#include <conio.h>
#include "wflilib.h"


void main(int argc,char *argv[]) {
	fli * fliptr;
	int     i;
	char    ch = 0;
	union REGS regs;

// load the file
	if (argc < 2) {
		cout << "usage : fliplay name.fl?";
		return;
	}
	if ((fliptr = load_fli(argv[1], AUTO)) == NULL) {
		cout << "error loading file";
		return;
	}

// check the size
    if (fliptr->width > 320 || fliptr->height > 200) {
        cout << "this player only supports 320x200 or smaller flc files\n";
        close_fli(fliptr);
        return;
    }

// go into graphics mode
	
	regs.w.ax = 0x13;
	int386(0x10, &regs, &regs);

// loop until esc
	while (ch != 27) {

// wait fliptr->speed frames
		for (i = 0; i < fliptr->speed; i++) {
			while (inp(0x3da) & 0x8)
				;
			while (!(inp(0x3da) & 0x8))
				;
		}

// play next frame of the fli
		play_frame(fliptr, (char *)0xa0000, 320);
		if (kbhit())
			ch = getch();
	}

// close the fli in case we were reading from disk
	close_fli(fliptr);

// go to text mode
	regs.w.ax = 3;
	int386(0x10, &regs, &regs);

}
