#include <wgt5.h>
#include <stdio.h>
#include <dos.h>
#include <math.h>
#include <malloc.h>

#define MAXCOL 128L
#define NUMFRAMES 16L

int oldmode;

block picture1;
block picture2;
block destination;
color pal[256];

unsigned char *fade_table;



/* Fade table creation routines */
/* ------------------------------------------------------------------------ */
unsigned char closest_match (int red, int green, int blue, color *pal)
{
int colnum;                     /* Color number to compare */
int delta_r, delta_g, delta_b;  /* Difference between new and existing */
float distance;                 /* Distance from new color */
float lowest_distance;          /* Lowest distance found */
int closest_color;              /* Color with the lowest distance */


   lowest_distance = 33333;
   /* Set to a high number, higher than anything possible.
      The highest distance we can have is sqrt (64*64 + 64*64 + 64*64)
      which is 110.85 */

   for  (colnum = 0; colnum < MAXCOL; colnum++)
   /* Compare each color from the existing palette */
     {

      delta_r = (pal[colnum].r - red);
      delta_g = (pal[colnum].g - green);
      delta_b = (pal[colnum].b - blue);

      distance = sqrt (delta_r*delta_r*30 + delta_g*delta_g*59 + delta_b*delta_b*11);

      if  (distance < lowest_distance)
        {
         lowest_distance = distance;
         closest_color = colnum;
        }
     }

 return (closest_color);
}



void create_fade_table (int frame, int maxframe,
                        unsigned char *fadetable, color *pal)
{

float lightlevel1;      /* Percentage of color 1 */
float lightlevel2;      /* Percentage of color 2 */

float fr, fg, fb;       /* Floating point RGB values of color 1 */
float fr2, fg2, fb2;    /* Floating point RGB values of color 2 */
int   ir,  ig,  ib;     /* Integer RGB values after combing the two above */

int col1, col2;

unsigned char bestcolor; /* Best match */

 lightlevel1 = (float)frame / (float)maxframe;
 /* Calculate the percentage of color 1 */

 lightlevel2 = 1.0 - lightlevel1;
 /* Percentage of color 2 is the 100% - lightlevel1 */


 for (col2 = 0; col2 < MAXCOL; col2++)
   for (col1 = 0; col1 < MAXCOL; col1++)
     {
      
      fr = (float)pal[col1].r * lightlevel1;
      fg = (float)pal[col1].g * lightlevel1;
      fb = (float)pal[col1].b * lightlevel1;

      fr2= (float)pal[col2].r * lightlevel2;
      fg2= (float)pal[col2].g * lightlevel2;
      fb2= (float)pal[col2].b * lightlevel2;

      /* Calculate the two new colors */

      ir = (fr + fr2);
      ig = (fg + fg2);
      ib = (fb + fb2);
      /* Combine the percentage of color 1 with the percentage of color 2
         to form a new color */

      bestcolor = closest_match (ir, ig, ib, pal);

      fadetable[frame * (MAXCOL*MAXCOL) + col2 * MAXCOL + col1] = bestcolor;
      wsetcolor (bestcolor);
      wputpixel (col1, col2);
      /* Store the color at fadetable[frame][col2][col1] */

  }

}



void create_all_frames (int numframes, unsigned char *fadetable,
                        color *pal)
{
int i;

 wtextcolor (255);  /* White color */
 wtexttransparent (TEXTFGBG);

 for (i = 0; i < numframes; i++)
  { 
   wgtprintf (160, 0, NULL, "Frame: %hi/%hi", i, numframes-1);
   create_fade_table (i, numframes, fadetable, pal);
  }
}




/* Frame creation routines */
/* ------------------------------------------------------------------------ */

void fade_frame_asm (block pic1, block pic2, block table, block dest, int length);
#pragma aux fade_frame_asm = \
 "push ebp" \
 "mov ebp, edx" \
 "mov ebx, 0" \
 "fadeloop: mov bl, 0" \
 "mov bh, [esi]" \
 "shr bx, 1" \
 "add bl, [edi]" \
 "mov dl, [ebp + ebx]" \
 "inc esi" \
 "inc edi" \
 "mov bl, 0" \
 "mov bh, [esi]" \
 "shr bx, 1" \
 "add bl, [edi]" \
 "mov dh, [ebp + ebx]" \
 "inc esi" \
 "inc edi" \
 "mov [eax], dx" \
 "add eax, 2" \
 "dec ecx" \
 "jnz fadeloop" \
 "pop ebp"\
parm [esi] [edi] [edx] [eax] [ecx] \
modify exact [eax ebx ecx edx esi edi] nomemory;


void fade_frame (block pic1, block pic2, block dest, block fade_table,
                 int frame)
{
 fade_table += frame * (MAXCOL * MAXCOL);
 pic1 += 4;
 pic2 += 4;
 dest += 4;

 fade_frame_asm (pic1, pic2, fade_table, dest, 25600);
 /* Length is 256*200 / 2 because we're moving words */
}



void save_table (char *filename, block table, long size)
{
FILE *out;
int i;

 out = fopen (filename, "wb");
 fwrite (table, size, 1, out);
 fclose (out);
}


block load_table (char *filename, long size)
{
FILE *in;
int i;
block table;

 if  ((in = fopen (filename, "rb")) == NULL)
     return NULL;

 table = (unsigned char *)malloc (size);
 fread (table, size, 1, libf);
 fclose (libf);
 return table;
}


void main (void)
{
int frame;
int framedir;

 oldmode = wgetmode ();

 vga256 ();

 picture1 = wloadpcx ("amber.pcx", pal);
 picture2 = wloadpcx ("termnate.pcx", pal);
 destination = wallocblock (256, 200);

 wsetrgb (255, 63, 63, 63, pal);
 /* Create a white color for text */

 wsetpalette (0, 255, pal);


 fade_table = load_table ("fade.tab", MAXCOL * MAXCOL * NUMFRAMES);
 if (fade_table == NULL)
   {

    wresize (0, 140, 50, 190, picture1, 0);
    wresize (100, 140, 150, 190, picture2, 0);
    /* Show some thumbnail versions of the pictures to fade */

    fade_table = malloc (MAXCOL * MAXCOL * NUMFRAMES);
    create_all_frames (NUMFRAMES, fade_table, pal);
    save_table ("fade.tab", fade_table, MAXCOL * MAXCOL * NUMFRAMES);
   }


 wcls (0);

 framedir = 1;
 frame = 0;

 do
   {
    fade_frame (picture1, picture2, destination, fade_table, frame);
    wputblock (32, 0, destination, 0);

    frame += framedir;
    if (frame == NUMFRAMES - 1)
      framedir = -1;
    if (frame == 0)
      framedir = 1;
   } while (!kbhit ());     


 free (fade_table);
 wfreeblock (picture1);
 wfreeblock (picture2);
 wfreeblock (destination);
 wsetmode (oldmode);
}


