////////////////////////////////////////////////////////////
//
//  BMP_TEST.CPP - MS-Windows BMP Color Quantization Test
//                 Program
//
//  Version:    1.00B
//
//  History:    94/08/23 - Version 1.00A release.
//              94/11/10 - Updated program title display.
//              94/11/11 - Version 1.00B release.
//
//  Compilers:  Microsoft Visual C/C++ Professional V1.5
//              Borland C++ Version 4.0
//
//  Author:     Ian Ashdown, P.Eng.
//              byHeart Software Limited
//              620 Ballantree Road
//              West Vancouver, B.C.
//              Canada V7S 1W3
//              Tel. (604) 922-6148
//              Fax. (604) 987-7621
//
//  Copyright 1994 byHeart Software Limited
//
////////////////////////////////////////////////////////////

// BMP_TEST.CPP - BMP Color Quantization Test Program

#include <stdio.h>
#include "bmp_quan.h"

static char InFileName[128];    // Input file name buffer
static char OutFileName[128];   // Output file name buffer

int main( int argc, char *argv )
{
  BMP_Quantize color_reducer;   // Color reduction object

  // Display program title
  printf("\nMS-Windows BMP Color Quantization Utility, "
      "Version 1.00B\n");
  printf("Copyright 1994 byHeart Software Limited\n");
  printf("All rights reserved\n\n");

  // Get BMP file names
  printf("Enter 24-bit BMP input file name: ");
  (void) gets(InFileName);
  printf("Enter 8-bit BMP output file name: ");
  (void) gets(OutFileName);

  // Perform color reduction
  if (color_reducer.Quantize(InFileName, OutFileName) ==
      TRUE)
    return 0;
  else
    return 2;
}

