////////////////////////////////////////////////////////////
//
//  DIB_DOS.H - MS-Windows DIB Data Structures for MS-DOS
//              Include File
//
//  Version:    1.00B
//
//  History:    94/08/23 - Version 1.00A release.
//              94/11/11 - Version 1.00B release.
//
//  Compilers:  Microsoft Visual C/C++ Professional V1.5
//              Borland C++ Version 4.0
//
//  Author:     Ian Ashdown, P.Eng.
//              byHeart Software Limited
//              620 Ballantree Road
//              West Vancouver, B.C.
//              Canada V7S 1W3
//              Tel. (604) 922-6148
//              Fax. (604) 987-7621
//
//  Copyright 1994 byHeart Software Limited
//
////////////////////////////////////////////////////////////

#ifndef _DIB_DOS_H
#define _DIB_DOS_H

#include "gen_defs.h"

// The following are MS-DOS equivalents of the BM and RGB
// definitions and data structures defined in <windows.h>
// for MS-Windows device-independent bitmaps (DIBs).

static const DWORD DIB_BI_RGB = 0L;    // No compression

struct DIB_FileHeader   // DIB file header
{
  UINT bfType;          // File type - must be 'BM'
  DWORD bfSize;         // File size (in bytes)
  UINT bfReserved1;     // Reserved (must be zero)
  UINT bfReserved2;     // Reserved (must be zero)
  DWORD bfOffBits;      // Bitmap data offset (in bytes)
};

struct DIB_InfoHeader   // DIB information header
{
  DWORD biSize;         // Structure size (in bytes)
  LONG biWidth;         // Bitmap width (in pixels)
  LONG biHeight;        // Bitmap height (in pixels)
  WORD biPlanes;        // Number of planes (always 1)
  WORD biBitCount;      // Bits per pixel
  DWORD biCompression;  // Compression type
  DWORD biSizeImage;    // Image size (in bytes)
  LONG biXPelsPerMeter; // Horizontal resolution
  LONG biYPelsPerMeter; // Vertical resolution
  DWORD biClrUsed;      // Number of color indices used
  DWORD biClrImportant; // Number of important color indices
};

struct DIB_Palette      // RGB color (RGBQUAD)
{
  BYTE rgbBlue;
  BYTE rgbGreen;
  BYTE rgbRed;
  BYTE rgbReserved;     // Reserved (must be zero)
};

#endif

