;if you want to change the bitmap used for the planet, do the following:
;
;  convert your image to TGA format (use F2 in Graphic Workshop)
;  modify MAKEFILE to use your converted TGA file, instead of EARTHMAP.TGA
;  type 'MAKE -B' to recompile everything

ideal
jumps
locals
p386
model huge
stack 100h

LoopDemo = 0                ;1 to repeat text at end, 0 to quit at end


segment     Code
            assume cs:Code,ds:Code
;
include     "palette.inc"
include     "scrolly.inc"
include     "stars.inc"
include     "rotate.inc"
include     "scale1.inc"
;
TempHeight  dw ?
TempWidth   dw ?
TempRow     dw ?
TempCol     dw ?
TempSpeed   dw ?
;           AX = width
;           BX = height
;           CX = column
;           DX = row
;           DI = speed (and direction)
proc        DoSanta
            mov [cs:TempHeight],bx 
            mov [cs:TempWidth],ax
            mov [cs:TempRow],dx 
            mov [cs:TempCol],cx
            mov [cs:TempSpeed],di

@@Loop:     ;**** clear the work buffer to all black ****
            mov ax,WorkSegment
            mov es,ax
            mov di,offset WorkBuffer
            xor eax,eax
            mov cx,(320*200)/4
            cld
            rep stosd

            ;**** draw the stars on the background ****
            mov ax,WorkSegment
            mov es,ax
            mov di,offset WorkBuffer
            call DrawStars

            ;**** map the image to the planet and display it ****
            mov ax,WorkSegment
            mov es,ax
            mov di,offset WorkBuffer
            call MapIt

            ;**** map Santa on the screen ***
            mov [word cs:ScreenPtr+0],offset WorkBuffer
            mov [word cs:ScreenPtr+2],WorkSegment
            push SantaSegment SantaData
            push SantaHeight SantaWidth
            push [cs:TempHeight] [cs:TempWidth]
            push [cs:TempRow] [cs:TempCol]
            call Scale
            add sp,16
            or ax,ax
            jnz @@Quit

            ;**** display the hidden buffer ****
            mov ax,WorkSegment
            mov ds,ax
            mov si,offset WorkBuffer
            mov ax,0A000h
            mov es,ax
            xor di,di
            mov cx,(320*200)/4
            cld
            rep movsd

            ;**** rotate the planet a little ****
            call RotateIt

            ;**** wait for a vertical retrace (for delay) ****
            WaitForRetrace

            mov ax,[cs:TempSpeed]
            add [cs:TempCol],ax
            jmp @@Loop

@@Quit:     ret
endp        DoSanta
;
proc        Start
            ;**** change into graphics mode ****
            mov ax,0013h
            int 10h

            ;**** set the palette to all black ****
            mov ax,cs
            mov ds,ax
            mov si,offset CurPalette
            xor al,al
            mov cx,256
            SetPalette

            ;**** draw the stars on the background ****
            mov ax,0A000h
            mov es,ax
            xor di,di
            call DrawStars

            ;**** convert the TGA palette to a normal palette ****
            mov ax,MapSegment
            mov ds,ax
            mov si,offset MapPalette
            call Fix_TGA_palette

            ;**** fade the real palette in ****
            mov ax,cs
            mov ds,ax
            mov si,offset CurPalette
            mov ax,MapSegment
            mov es,ax
            mov di,offset MapPalette
            call fade_in

@@MainLoop: ;**** clear the work buffer to all black ****
            mov ax,WorkSegment
            mov es,ax
            mov di,offset WorkBuffer
            xor eax,eax
            mov cx,(320*200)/4
            cld
            rep stosd

            ;**** draw the stars on the background ****
            mov ax,WorkSegment
            mov es,ax
            mov di,offset WorkBuffer
            call DrawStars

            ;**** map the image to the planet and display it ****
            mov ax,WorkSegment
            mov es,ax
            mov di,offset WorkBuffer
            call MapIt

            ;**** draw row 1 of the text on screen ****
            mov ax,cs                       ;\ set DS to CS
            mov ds,ax                       ;/
            mov si,[ScrollPos]              ;
            add si,offset ScrollText+0      ;SI = offset to this row of text
            mov ax,WorkSegment              ;\
            mov es,ax                       ; \ ES:DI ==> position in buffer
            mov di,offset WorkBuffer        ; /
            add di,[si]                     ;/
            add si,2                        ;DS:SI ==> text to draw
            mov ax,[NumCols]                ;AX = number of cols to draw
            call DoRowOfText                ;draw the text

            ;**** draw row 2 of the text on screen ****
            mov ax,cs                       ;\ set DS to CS
            mov ds,ax                       ;/
            mov si,[ScrollPos]              ;
            add si,offset ScrollText+42     ;SI = offset to this row of text
            mov ax,WorkSegment              ;\
            mov es,ax                       ; \ ES:DI ==> position in buffer
            mov di,offset WorkBuffer        ; /
            add di,[si]                     ;/
            add si,2                        ;DS:SI ==> text to draw
            mov ax,[NumCols]                ;AX = number of cols to draw
            call DoRowOfText                ;draw the text

            ;**** draw row 3 of the text on screen ****
            mov ax,cs                       ;\ set DS to CS
            mov ds,ax                       ;/
            mov si,[ScrollPos]              ;
            add si,offset ScrollText+42+42  ;SI = offset to this row of text
            mov ax,WorkSegment              ;\
            mov es,ax                       ; \ ES:DI ==> position in buffer
            mov di,offset WorkBuffer        ; /
            add di,[si]                     ;/
            add si,2                        ;DS:SI ==> text to draw
            mov ax,[NumCols]                ;AX = number of cols to draw
            call DoRowOfText                ;draw the text

            ;**** display the hidden buffer ****
            mov ax,WorkSegment
            mov ds,ax
            mov si,offset WorkBuffer
            mov ax,0A000h
            mov es,ax
            xor di,di
            mov cx,(320*200)/4
            cld
            rep movsd

            ;**** figure out how much more text we display next time ****
            mov ax,cs
            mov ds,ax
            inc [NumCols]
            cmp [NumCols],320+20
            jbe @@TextDone
@@NewText:  mov [NumCols],0
            add [ScrollPos],(42)*3
@@Recheck:  mov si,[ScrollPos]
            cmp [word offset ScrollText+si],-2
            jnz @@NotSpecial

            mov ax,[word offset ScrollText+si+2]    ;Width
            mov bx,[word offset ScrollText+si+4]    ;Height
            mov cx,[word offset ScrollText+si+6]    ;Starting column
            mov dx,[word offset ScrollText+si+8]    ;Starting row
            mov di,[word offset ScrollText+si+10]   ;Velocity
            call DoSanta

            mov ax,cs
            mov ds,ax
            add [ScrollPos],12
            jmp @@Recheck
@@NotSpecial:cmp [word offset ScrollText+si],-1
            jnz @@TextDone
            if LoopDemo eq 0
                jmp @@Quit
            else
                mov [ScrollPos],0
            endif
@@TextDone:

            ;**** rotate the planet a little ****
            call RotateIt

            ;**** wait for a vertical retrace (for delay) ****
            WaitForRetrace

            ;**** check stdio.  If something's been pressed, quit ****
            mov ah,6
            mov dl,0FFh
            int 21h
            jz @@MainLoop
            cmp al,'/'
            jz @@NewText

@@Quit:     ;**** clear the work buffer to all black ****
            mov ax,WorkSegment
            mov es,ax
            mov di,offset WorkBuffer
            xor eax,eax
            mov cx,(320*200)/4
            cld
            rep stosd

            ;**** draw the stars on the background ****
            mov ax,WorkSegment
            mov es,ax
            mov di,offset WorkBuffer
            call DrawStars

            ;**** map the image to the planet and display it ****
            mov ax,WorkSegment
            mov es,ax
            mov di,offset WorkBuffer
            call MapIt

            ;**** display the hidden buffer ****
            mov ax,WorkSegment
            mov ds,ax
            mov si,offset WorkBuffer
            mov ax,0A000h
            mov es,ax
            xor di,di
            mov cx,(320*200)/4
            cld
            rep movsd

            ;**** fade the palette back out to black ****
            call fade_out

            ;**** return to text mode ****
            ;mov ax,0003h
            ;int 10h

            ;**** terminate program ****
            mov ax,4C00h
            int 21h
endp        Start
;
ends        Code

segment     SphereSegment
include     "sphere.inc"
ends        SphereSegment

segment     MapSegment
include     "earthmap.dmp"
MapPalette  equ offset MapOffset+18
MapData     equ offset MapOffset+18+768
ends        MapSegment

segment     SantaSegment
include     "santa.dmp"
SantaPalette equ offset SantaOffset+18
SantaData   equ offset SantaOffset+18+768
SantaWidth  = 228
SantaHeight = 68
ends        SantaSegment

segment     WorkSegment
label       WorkBuffer byte
ends        WorkSegment

            end     Start
