;=============================================================================
; worm.asm - Worm Hole palette demostration.
;                                                    File created: 10/04/93
; Copyright (c) 1993, Carlos Hasan                  Last modified: 10/04/93
;
; Description:
;   This file demostrates a palette animation routine, the main piccy
; was created using the pascal source file. This one uses the VGA card
; in 320x200x256 graphics mode.
;
; Portability:
;  Requires Turbo Assembler 3.2 or better to be assembled.
;  Dependent on the IBM PC 286 and the VGA graphics card.
;
; Modifications:
;  10/22/93 - Startup Code and Picture on .OBJ file.
;=============================================================================

                .model  small,pascal
                .286

                dosseg                          ; used to link like
                .stack  1024                    ; and standalone program.

                global  WormHole:proc
                global  WormPic:byte            ; in WORMRAW.OBJ file.

;====================== Demo Equates and Data ================================

TIMEOUT         equ     70 * 8                  ; About 8 sec for timeout.

                .data

Palette         db      768 dup (?)             ; hold the color palette
FadePalette     db      768 dup (?)             ; and the faded palette.
Timer           dw      ?                       ; timer counter.

;========================== Demo routines ====================================

                .code

;-----------------------------------------------------------------------------
; SetPalette - set the 256 entries of the VGA color palette.
; In:
;   DS:SI - Palette structure address.
;-----------------------------------------------------------------------------

SetPalette      proc near

                mov     cx,768
                mov     dx,3C8h
                xor     al,al
                out     dx,al
                mov     dx,3DAh
WaitVRT1:       in      al,dx                   ; wait the start of
                test    al,8                    ; vertical retrace.
                jz      WaitVRT1
WaitVRT2:       in      al,dx                   ; wait the end of
                test    al,8                    ; vertical retrace.
                jnz     WaitVRT2
                mov     dx,3C9h
                rep     outsb
                ret

SetPalette      endp

;-----------------------------------------------------------------------------
; RotPalette - Rotates the palette and do fading.
; In:
;   Palette - Source palette.
;   Fade    - Fading level.
;-----------------------------------------------------------------------------

RotPalette      proc near Fade:word

                mov     ax,ds
                mov     es,ax

                lea     di,[FadePalette]
                mov     cx,16*3
                xor     ax,ax
                cld
                rep     stosb
                lea     si,[Palette+32*3]
                mov     cx,224*3
                cld
                rep     movsb
                lea     si,[Palette+16*3]
                mov     cx,16*3
                rep     movsb

                lea     bx,[FadePalette]
                mov     cx,16
RotLoop:        push    cx
                mov     si,bx
                mov     di,bx
                lodsb
                mov     ah,al
                lodsb
                mov     dl,al
                lodsb
                mov     dh,al
                mov     cx,15*3
                rep     movsb
                mov     al,ah
                stosb
                mov     al,dl
                stosb
                mov     al,dh
                stosb
                add     bx,16*3
                pop     cx
                loop    RotLoop

                lea     si,[FadePalette]
                lea     di,[Palette]
                mov     cx,768
                rep     movsb

                lea     si,[FadePalette]
                mov     cx,768
                mov     dx,[Fade]
FadeLoop:       mov     al,[si]
                mul     dl
                shr     ax,7
                mov     [si],al
                inc     si
                loop    FadeLoop

                lea     si,[FadePalette]
                call    SetPalette
                ret

RotPalette      endp

;-----------------------------------------------------------------------------
; WormHole - Worm Hole demostration.
; In:
;   DS     - Data segment.
;   PicSeg - 320x200x256 picture segment address.
;-----------------------------------------------------------------------------

WormHole        proc    PicPtr:dword
                local   Fade:word

                mov     ax,0013h                ; set 320x200x256 mode.
                int     10h

                mov     ax,ds                   ; set black palette.
                mov     es,ax
                lea     di,[Palette]
                mov     cx,768
                xor     ax,ax
                cld
                rep     stosb
                lea     si,[Palette]
                call    SetPalette

                lea     di,[Palette]            ; generate the palette.
                mov     cx,256
                xor     bx,bx
GenPalette:     mov     ax,bx
                shr     ax,4
                and     ax,0Fh
                shl     ax,2
                mov     [di+0],al
                mov     ax,bx
                and     ax,0Fh
                shl     ax,1
                mov     [di+1],al
                mov     al,3Fh
                mov     [di+2],al
                add     di,3
                inc     bx
                loop    GenPalette

                push    ds                      ; write the picture.
                mov     ax,0A000h
                mov     es,ax
                lds     si,[PicPtr]
                xor     di,di
                mov     cx,320*200
                cld
                rep     movsb
                pop     ds

                mov     [Fade],0
                mov     [Timer],0

WormIn:         call    RotPalette,[Fade]       ; rotate palette.
                cmp     [Fade],128              ; adjust fade level.
                jae     WormTime
                inc     [Fade]
WormTime:       inc     [Timer]                 ; check if timeout,
                cmp     [Timer],TIMEOUT
                jae     WormOut
WormKey:        mov     ah,1                    ; or any key pressed.
                int     16h
                jz      WormIn

WormOut:        cmp     [Fade],128              ; start fading-out.
                ja      WormExit
                call    RotPalette,[Fade]
                dec     [Fade]
                jmp     WormOut

WormExit:       mov     ax,03h                  ; restore 80x25x16 textmode.
                int     10h
                ret

WormHole        endp

;-----------------------------------------------------------------------------
; Start - Startup Code called from DOS.
; In:
;   ES - Program Segment Prefix.
;-----------------------------------------------------------------------------

Start           proc

                mov     ax,@Data
                mov     ds,ax
                call    WormHole,SEG WormPic,OFFSET WormPic
                mov     ax,4C00h
                int     21h

Start           endp

                end     Start
