.386
.387
Assume Cs:_Code,Ds:_Data
;
_Code Segment Para Public 'Code' Use16
Proge Proc Near
;ͻ
; MAIN PROGRAM  
;ͼ
Start:	mov	ax,_Data
	mov	ds,ax
	mov	ax,0a000h
	mov	es,ax

	call	VGAChk
	call	CoChk
	call	HookIRQ1
	call	VariousStuff

www:	fldz				;t= 0
	fstp	t

	mov	cx,LoopLen
qqq:	call	Compute

	fld	t			;t= t+ Step
	fadd	step
	fstp	t

	loop	qqq

	mov	bp,15
	call	ScalePixel
	call	PutPixel
	
	jmp	www

;ͻ
; SUBROUTINES  
;ͼ
;List of subroutines and brief explanation
;
;  CoChk	Checks presence of coprocessor. If no then quit with error.
;  VGAChk	Checks if VGA. If no then quit with error else go on.
;  VariousStuff	Set video mode 12. Prints texts. Calculates Step and LoopLen.
;  Compute	Main formula implementation subroutine.
;  HookIRQ1	Setup keyboard interrupt vector.
;  IRQ1Handler	Subroutine, which will be executed by keypress. Quit by ESC.
;  ReleaseIRQ1	Restores old interrupt vector.
;  Quit/ErrQuit	Simple quit/ Quit with error message.
;  ScalePixel	Transfers coordinates for PutPixel.
;  PutPixel	Optimized PutPixel subroutine. (bp=color, lower byte)
;
;-------------- Co check -----------------------------------

CoChk:	fninit				;Coprocessor presence test.
	fstcw	wordtmp			;Subroutine uses 378's Control Word
	fwait
	and	wordtmp,0f3fh
	cmp	wordtmp,033fh
	jne	NoCo

	not	wordtmp
	fldcw	wordtmp
	fstcw	wordtmp
	fwait
	and	wordtmp,0f3fh
	cmp	wordtmp,0c00h
	jne	NoCo

	fninit
	retn

NoCo:	mov	dx,Offset CoMess
	jmp	ErrQuit

;-------------- VGA Check ----------------------------------

VGAChk:	mov	ax,1a00h		;No comment
	int	10h
	cmp	al,1ah
	jnz	NoVGA

	retn

NoVGA:	mov	dx,Offset VGAMess
	jmp	ErrQuit

;-------------- This and that ------------------------------

VariousStuff:

	mov	ax,12h		;VideoMode 12
	int	10h

	mov	ah,9		;PrintText
	mov	dx,Offset Text
	int	21h

	fld1			;Step= 1/ d
	fdiv	d
	fstp	Step

	fldpi			;LoopLen= 2* pi* d
	fldpi
	fadd
	fmul	d
	fistp	LoopLen

	retn

;-------------- Ueda attr calculation step -----------------

Compute:
	fld	t		;xii= a* Cos(t)- b* xi- c* x^3
	fcos
	fmul	a
	fld	b
	fmul	xi
	fsub
	fld	c
	fmul	x
	fmul	x
	fmul	x
	fsub
	fstp	xii

	fld	xii		;xi= xi+ xii/ d
	fdiv	d
	fadd	xi
	fstp	xi

	fld	xi		;x= x+ xi/d
	fdiv	d
	fadd	x
	fstp	x

	retn

;-------------- IRQ 1 Hooking ------------------------------

HookIRQ1:

	push	ds es

	mov	ah,35h		;Read current interrupt vector
	mov	al,9
	int	21h

	mov	OldIRQ1,bx	;... and store it
	mov	OldIRQ1+2,es

	mov	ax,cs		;Put in use new interrupt vector
	mov	ds,ax
	mov	dx,offset cs:IRQ1Handler
	mov	ah,25h
	mov	al,9
	int	21h
	sti

	pop	es ds
	retn

;-------------- IRQ 1 Handler ------------------------------

IRQ1Handler:

	pusha
	mov	al,20h		;Announce about IRQ ending (so soon!)
	out	20h,al

	in	al,60h		;Check if Esc Pressed
	cmp	al,1
	jnz	NoEsc

	call	ReleaseIRQ1	;Action if [Esc]
	mov	ax,3
	int	10h
	jmp	Quit

NoEsc:	popa			;End IRQ
	iret

;-------------- IRQ 1 Releasing ----------------------------

ReleaseIRQ1:

	push	ds
	mov	ax,_Data
	mov	ds,ax

	mov	dx,OldIRQ1	;Restore old interrupt vector
	mov	ax,OldIRQ1+2
	mov	ds,ax
	mov	ah,25h
	mov	al,9
	int	21h

	pop	ds
	retn

;-------------- Quit ---------------------------------------

ErrQuit:
	mov	ah,9
	int	21h

Quit:	mov	ax,4c00h
	int	21h

;-------------- Pixel Scaling ------------------------------

ScalePixel:

	fld	x		;pX= x* Xmul+ Xadd_
	fmul	Xmul
	fadd	Xadd_
	fistp	pX

	fld	xi		;pY= xi* Ymul+ Yadd
	fmul	Ymul
	fadd	Yadd
	fistp	pY

	retn

;-------------- Putpixel -----------------------------------

PutPixel:			;bp=color(lower byte), destoys many regs,
				;no range chk. Expects es= 0a000h
	mov	ax,word ptr pY
	mov	bx,ax
	shl	ax,6
	shl	bx,4
	add	ax,bx
	mov	bx,word ptr pX
	shr	bx,3
	add	bx,ax		;bx=address of current byte

	mov	cx,4

	mov	dx,3ceh		;Prepare bitplane read
	mov	al,4
	out	dx,al

	mov	dx,3c4h		;Prepare bitplane write
	mov	al,2
	out	dx,al

PixelLoop:

	mov	dx,3cfh		;Swich bitplane for read
	mov	al,4
	sub	al,cl
	out	dx,al
	
	mov	dx,3c5h		;Swich bitplane for write
	mov	al,16
	shr	al,cl
	out	dx,al

	push	cx		;BitChemistry
	mov	ah,es:[bx]
	mov	cx,word ptr pX
	and	cx,0111b
	inc	cx
	rcl	ah,cl
	shr	bp,1
	rcr	ah,cl
	mov	es:[bx],ah
	pop	cx
	dec	cx
	jnz	PixelLoop
	retn

;
Proge Endp
_Code Ends
;
_Data Segment Para Public 'Data' Use16

a	dq	7.5			;Object parameters
b 	dq	0.05
c 	dq	1.0
d	dq	20.0			;Exactness/time


WordTmp	dw	?
OldIRQ1	dw	?
	dw	?
pX	dd	?
pY	dd	?
Xadd_	dq	-250.0			;Object scaling/moving
Xmul	dq	+250.0
Yadd	dq	+280.0
Ymul	dq	-45.0
x	dq	1.954006048799486	;Startvalues. If integers, then some
xi	dq	0.865803028271145	;first pixels might be out of object.
xii	dq	1.26028649783987	
t	dq	?
step	dq	?
LoopLen	dw	?
Text	db	'Ŀ',10,13
	db	' Poincar Section of Ueda Attractor ',10,13
	db	'        Ragnar Kurm / Styx          ',10,13
	db	'$'
VGAMess	db	10,13,'   VGA required',10,13,7,'$'
CoMess	db	10,13,'   387 required',10,13,7,'$'

_Data Ends
;
_Stack Segment Para Stack 'Stack' Use16
db 256 dup (0)
_Stack Ends
;
End Proge