#include <stdlib.h>
#include <conio.h>
#include <stdio.h>
#include <dos.h>
#include <ctype.h>
#include <time.h>
#include <dosfunc.h>
#include <zsort.h>
#include <3ds.h>


float RAND(void);
object *init(void);
void shutdown(object *o);
void displayobject(object *o);
outbuffer *init256(void);
void free256(outbuffer *b);
void test_d(object *o);
int seeded=0;
int x=0;
float dx=0,dy=0,dz=0;
int drawing=1;
int do_rotation(matrix orientation);



float RAND(void)
	{
	if(!seeded)
		{
		srand(time(0));
		seeded++;
		}

	return (rand()/((float)RAND_MAX));
	}


/***********************************************************************
 Disabled code
 -------------
 ***********************************************************************/
#if 0
unsigned long far *screen;
object *init(void)
	{
	object *o;
	long a,b,c,x,y,z;
	union REGS r;


	o=alloc_object(100);

	if(!o)
		return 0;

	for(a=0;a<100;a++)
		{
		for(b=0;b<3;b++)
			{
			o->points->vertex[a].location[b]=
				floattoreal(RAND()-.5);
			}
		}

	r.x.ax=0x13;
	int86(0x10,&r,&r);

	outp(0x3c2,0xe3);

	screen=_x386_mk_protected_ptr(0xa0000);
/*      screen=((unsigned long far *)0xa0000000);*/

	return o;
	}



void shutdown(object *o)
	{
	union REGS r;

	r.x.ax=0x3;

	int86(0x10,&r,&r);

	free_object(o);
	}




void displayobject(object *o)
	{
	static unsigned char *vscr=0;
	unsigned long *_v_;
	long a,b,c,xx,yy;
	float x,y,z;

	if(!vscr)
		{
		vscr=malloc(64000);
		if(!vscr)
			{
			puts("malloc error in displayobject!");
			abort();
			}
		}


	_v_=((unsigned long *)vscr);
	for(a=0;a<16000;a++)
		_v_[a]=0;


	for(a=0;a<o->numpoints;a++)
		{
		x=realtofloat(
			div(
				o->x_vertex[a].location[0],
				o->x_vertex[a].location[2]
				)
			);
		y=realtofloat(
			div(
				o->x_vertex[a].location[1],
				o->x_vertex[a].location[2])
			);


		xx=x*300+160;
		yy=y*300+100;

		vscr[xx+yy*320]=15;
		}

	for(a=0;a<16000;a++)
		screen[a]=_v_[a];
	}


void test_a(void)
	{
	object *o;
	matrix orientation;
	vector position;
	int x;
	float dx,dy,dz;


	initmatrix(orientation,
		1,0,0,
		0,1,0,
		0,0,1);


	o=init();
	initvector(position,0,0,3);

	if(!o)
		{
		puts("Could not initialize stuff");
		return;
		}

	x=0;
	while(x!='#')
		{
		xform_object(*o,orientation,position);
		displayobject(o);
		rotatebase(orientation,0,floattoreal(dx));
		rotatebase(orientation,1,floattoreal(dy));
		rotatebase(orientation,2,floattoreal(dz));
		if(kbhit())
			{
			x=getch();
			switch(toupper(x))
				{
				case 'Q':
					dx+=.01;
					break;
				case 'A':
					dx-=.01;
					break;
				case 'W':
					dy+=.01;
					break;
				case 'S':
					dy-=.01;
					break;
				case 'E':
					dz+=.01;
					break;
				case 'D':
					dz-=.01;
					break;
				case ' ':
					dx=0;
					dy=0;
					dz=0;
					break;
				}
			}
		else
			{
			x=0;
			}
/*              mat_orthonormalize(orientation);*/
		}

	shutdown(o);
	}
#endif
/***********************************************************************
 End disabled code
 -----------------
 ***********************************************************************/


void test_b(void)
	{
	matrix m,r,q;
	int x,y,z;


	srand(time(0));
	for(x=0;x<3;x++)
		for(y=0;y<3;y++)
			m[x][y]=floattoreal((rand()&3)*1.0);


	printmatrix(m);
	z=invert(m,r);

	if(z)
		{
		printf("Matrix is not inversible, determinant is %f\n",
			realtofloat(determinant(m)));
		}
	else
		{
		puts("Matrix is inversible");
		printmatrix(r);

		puts("Matrix product should be identity matrix");
		mat_mul(q,m,r);
		printmatrix(q);
		}
	}




object *init_c(void)
	{
	object *o;
	point *p;
	long a,b,c;

	o=0;
/*	do
		{*/
		if(o)
			free_object(o);

		o=alloc_object(4,4);
		p=o->pts_data->vertex;
		for(a=0;a<4;a++,p++)
			{
			initvector(p->location,(RAND()-.5)*2,(RAND()-.5)*2,(RAND()-.5)*2);
			}
	/*	}
	while(*/make_tetrahedron(o)/*)*/;

	normalize_object(o);

	return o;
	}



outbuffer *init256(void)
	{
	to256();
	setgrayscale(20,80);
	return allocbuf(99,99);
	}


void free256(outbuffer *b)
	{
	totxt();
	destroybuf(b);
	}




void test_d(object *o)
	{
	pipeline *pip;
	affine camera;
	outbuffer *buf;
	polygon pol;
	edge edg[3];
	face *f;
	point *p;
	long a,b,c;
	long *pp;
	REAL r;

	pip=alloc_pipeline(100,100,100);
	if(!pip)
		{
		puts("Memory allocation error");
		return;
		}

	initmatrix(camera.m,
		1,0,0,
		0,1,0,
		0,0,1);
	initvector(camera.v,0,0,3);

	buf=init256();
	if(!buf)
		{
		totxt();
		puts("Memory allocation error");
		return;
		}


	do
		{
		reset_pipeline(pip);
		cull_object(o,pip,&camera);
		f=pip->fbase;

		memset(buf->buffer,1,buf->width*buf->height);

		for(a=0;a<pip->fptr;a++,f++)
			{
			pol.edgetable=edg;
			pol.color=30*f->normal[2]+70;
			for(b=0;b<3;b++)
				{
				p=&pip->pbase[f->index[b]].point;
				edg[b].x1=realtofloat(div(p->location[0],p->location[2]))*500.0;
				edg[b].y1=realtofloat(div(p->location[1],p->location[2]))*500.0;
				}
			pol.numedges=3;
			drawpolygon(&pol,buf);
			}

		blit(buf);
		}
	while(!do_rotation(camera.m));
	free256(buf);
	}



void test_c(void)
	{
	long a,b,c;
	face *f;
	point *p;
	object *o;
	REAL r;

	o=init_c();

	if(!o)
		{
		puts("Error initializing object");
		return;
		}

	printf("Verification of plane equations:\n\n");
	f=o->face_data->face;
	p=o->pts_data->vertex;
	for(a=0;a<o->face_data->numfaces;a++,f++)
		{
		printf("Plane equation:\n%fx+%fy+%fz=%f\nVertices yield:\n",
			realtofloat(f->normal[0]),
			realtofloat(f->normal[1]),
			realtofloat(f->normal[2]),
			realtofloat(f->D)
			);

		printvector(f->normal);
		for(b=0;b<f->numpoints;b++)
			{
			printf("%i)",b);
			printvector(p[f->index[b]].location);
			r=vec_dot(f->normal,p[f->index[b]].location);
			r-=f->D;
			printf("%f\n",
				realtofloat(r)
				);
			}
		}

	puts("numpoly data");

	for(a=0;a<4;a++)
		printf("Vertex %li: %li\n",a,o->pts_data->vertex[a].clipping);

	puts("\nDone.");
	test_d(o);
	}



int do_rotation(matrix orientation)
	{
	rotatebase(orientation,0,floattoreal(dx));
	rotatebase(orientation,1,floattoreal(dy));
	rotatebase(orientation,2,floattoreal(dz));
	if(kbhit())
		{
		x=getch();
		switch(toupper(x))
			{
			case 'Q':
				dx+=.01;
				break;
			case 'A':
				dx-=.01;
				break;
			case 'W':
				dy+=.01;
				break;
			case 'S':
				dy-=.01;
				break;
			case 'E':
				dz+=.01;
				break;
			case 'D':
				dz-=.01;
				break;
			case ' ':
				dx=0;
				dy=0;
				dz=0;
				break;
			case '=':
				drawing=0;
				break;
			}
		}
	else
		{
		x=0;
		}

	if(x=='#')
		return -1;

	return 0;
	}





void test_e(void)
	{
	pipeline *p;
	long a,b,c;


	p=alloc_pipeline(1,20,1);
	if(!p)
		{
		puts("Memory allocation error");
		return;
		}

	puts("Initial state:");
	for(a=0;a<20;a++)
		{
		p->maxZ[a]=(RAND()-.5)*65536*2;
		printf("%8lX\n",p->maxZ[a]);
		}

	puts("Sorting...");
	sort_pipeline(p);
	puts("Done.");
	}





void test_f(void)
	{
	object *o,*oo;
	pipeline *pip;
	affine camera;
	outbuffer *buf;
	polygon pol;
	edge edg[3];
	face *f;
	point *p;
	long a,b,c;
	long *pp;
	REAL r;


	o=init_c();
	oo=init_c();

	for(a=0;a<4;a++)
		{
		o->pts_data->vertex[a].location[2]+=1.5;
		}

	for(a=0;a<4;a++)
		{
		oo->pts_data->vertex[a].location[2]-=1.5;
		}

	pip=alloc_pipeline(100,100,100);
	if(!pip)
		{
		puts("Memory allocation error");
		return;
		}

	initmatrix(camera.m,
		1,0,0,
		0,1,0,
		0,0,1);
	initvector(camera.v,0,0,4);

	buf=init256();
	if(!buf)
		{
		totxt();
		puts("Memory allocation error");
		return;
		}


	do
		{
		reset_pipeline(pip);
		cull_object(o,pip,&camera);
		cull_object(oo,pip,&camera);
		sort_pipeline(pip);
		memset(buf->buffer,1,buf->width*buf->height);

		for(a=pip->fptr-1;a>=0;a--)
			{
			f=pip->fbase+pip->index1[a];
/*                      f=pip->fbase+a;*/

			pol.edgetable=edg;
			pol.color=30*f->normal[2]+70;
			for(b=0;b<3;b++)
				{
				p=&pip->pbase[f->index[b]].point;
				edg[b].x1=realtofloat(div(p->location[0],p->location[2]))*500.0;
				edg[b].y1=realtofloat(div(p->location[1],p->location[2]))*500.0;
				}
			pol.numedges=3;
			if(drawing)
				drawpolygon(&pol,buf);
			}

		blit(buf);
		}
	while(!do_rotation(camera.m));
	free256(buf);
	}





void test_g(void)
	{
	object *o;
	pipeline *pip;
	affine camera;
	outbuffer *buf;
	polygon pol;
	edge edg[3];
	face *f;
	pipe_point *p;
	long a,b,c;
	long *pp;
	REAL r;
	float A,B,C;
	long time0,time1,polycount;
	float total_time;


	o=read_3ds_file("duck.asc",1);

	if(!o)
		{
		puts("Error reading file");
		return;
		}
	A=B=C=0;
	for(a=0;a<o->pts_data->numpoints;a++)
		{
		A+=realtofloat(o->pts_data->vertex[a].location[0]);
		B+=realtofloat(o->pts_data->vertex[a].location[1]);
		C+=realtofloat(o->pts_data->vertex[a].location[2]);
		}
	A/=o->pts_data->numpoints;
	B/=o->pts_data->numpoints;
	C/=o->pts_data->numpoints;
	for(a=0;a<o->pts_data->numpoints;a++)
		{
		o->pts_data->vertex[a].location[0]-=floattoreal(A);
		o->pts_data->vertex[a].location[1]-=floattoreal(B);
		o->pts_data->vertex[a].location[2]-=floattoreal(C);
		}

	pip=alloc_pipeline(300,700,2100);
	if(!pip)
		{
		puts("Memory allocation error");
		return;
		}

	initmatrix(camera.m,
		1,0,0,
		0,1,0,
		0,0,1);
	initvector(camera.v,0,0,3000);

	buf=init256();
	if(!buf)
		{
		totxt();
		puts("Memory allocation error");
		return;
		}

	polycount=0;
	time0=clock();

	do
		{
		reset_pipeline(pip);
		cull_object(o,pip,&camera);
		sort_pipeline(pip);
		memset(buf->buffer,1,buf->width*buf->height);

		for(a=pip->fptr-1;a>=0;a--)
			{
			f=pip->fbase+pip->index1[a];
/*                      f=pip->fbase+a;*/

			pol.edgetable=edg;
			pol.color=realtofloat(mul(f->normal[2],floattoreal(30)))+70;
			for(b=0;b<3;b++)
				{
				p=&pip->pbase[f->index[b]];
				edg[b].x1=realtofloat(p->scr_X)*500.0;
				edg[b].y1=realtofloat(p->scr_Y)*500.0;
				}
			pol.numedges=3;
			if(drawing)
				drawpolygon(&pol,buf);
			}

		blit(buf);
		mat_orthonormalize(camera.m);
		polycount+=o->face_data->numfaces;
		}
	while(!do_rotation(camera.m));

	time1=clock();

	free256(buf);

	total_time=(time1-time0)/CLK_TCK;

	printf("Total time elapsed: %f seconds\nTotal # of polygon blitted: %li\nPolygons per second: %f\n\n",
		total_time,polycount,polycount/total_time);
	}





void main(void)
	{
	test_g();
	}
